/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.mq.TmcMQParam;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.EntityEnum;
import kd.tmc.ifm.enums.InterestSettleTypeEnum;
import kd.tmc.ifm.enums.SettleTypeEnum;
import kd.tmc.ifm.resource.IfmBizResource;

public class BizDealHelper {
    private static final Log logger = LogFactory.getLog(BizDealHelper.class);

    public static void setBankAccountF7(IDataModel model, List<QFilter> qFilters) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        qFilters.add(new QFilter("company", "=", org.getPkValue()));
        DynamicObject creditor = (DynamicObject)model.getValue("creditor");
        qFilters.add(new QFilter("bank", "=", creditor.getPkValue()));
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            qFilters.add(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
        }
    }

    public static void pushInnerSettlePayBill(DynamicObject bill) {
        if (!BizDealHelper.isCanPush2IfmBill(bill)) {
            return;
        }
        Object[] transHandle = TmcBotpHelper.push((DynamicObject)bill, (String)"ifm_transhandlebill");
        if (EmptyUtil.isEmpty((Object[])transHandle)) {
            return;
        }
        Object transHandleBill = transHandle[0];
        String transHandleBillNo = CodeRuleServiceHelper.readNumber((String)"ifm_transhandlebill", (DynamicObject)transHandleBill, null);
        transHandleBill.set("billno", (Object)transHandleBillNo);
        OperateOption operateOption = OperateOption.create();
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"ifm_transhandlebill", (DynamicObject[])transHandle, (OperateOption)operateOption);
        if (!submitResult.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)";", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)submitResult)));
        }
        Object[] idArr = submitResult.getSuccessPkIds().toArray();
        OperationResult auditResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
        if (!auditResult.isSuccess()) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            throw new KDBizException(String.join((CharSequence)";", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)auditResult)));
        }
        OperationResult conmmitfmResult = TmcOperateServiceHelper.execOperate((String)"commitifm", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
        if (!conmmitfmResult.isSuccess()) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])idArr, (OperateOption)operateOption);
            throw new KDBizException(String.join((CharSequence)";", TmcOperateServiceHelper.decodeErrorMsg((OperationResult)conmmitfmResult)));
        }
        DynamicObject payBill = QueryServiceHelper.queryOne((String)"ifm_transhandlebill", (String)"bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idArr)});
        if (EmptyUtil.isNoEmpty((DynamicObject)payBill)) {
            bill.set("bankcheckflag", (Object)payBill.getString("bankcheckflag"));
            SaveServiceHelper.update((DynamicObject)bill);
        }
    }

    public static boolean isCanPush2IfmBill(DynamicObject bill) {
        DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
        return properties.containsKey((Object)"isrelcash") && bill.getBoolean("isrelcash") && properties.containsKey((Object)"eassrcid") && EmptyUtil.isEmpty((Object)bill.get("eassrcid"));
    }

    public static void deleteInnerSettlePayRec(DynamicObject billDyn, String entityName) {
        if (EmptyUtil.isEmpty((DynamicObject)billDyn)) {
            return;
        }
        List targetList = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billDyn.getLong("id"))}, null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)targetList)) {
            return;
        }
        TmcOperateServiceHelper.execOperate((String)"canclepay", (String)entityName, (Object[])targetList.toArray(), (OperateOption)OperateOption.create());
    }

    public static void deleteBatchIntBill(DynamicObject repayBill, String entityName) {
        for (DynamicObject entry : repayBill.getDynamicObjectCollection("loans")) {
            DynamicObject loanBill;
            QFilter intFilter;
            List batchIntBill;
            if (!entry.getBoolean("e_ispayinst") || CollectionUtils.isEmpty((Collection)(batchIntBill = QueryServiceHelper.queryPrimaryKeys((String)"ifm_intbill_batch_loan", (QFilter[])(intFilter = new QFilter("entry.loanbillid", "=", (Object)(loanBill = entry.getDynamicObject("e_loanbill")).getLong("id")).and(new QFilter("interesttype", "=", (Object)InterestSettleTypeEnum.HBFX.getValue()))).toArray(), null, (int)-1)))) continue;
            OperationResult unAuditResult = TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])batchIntBill.toArray(), (OperateOption)OperateOption.create());
            if (!EmptyUtil.isEmpty((Collection)unAuditResult.getSuccessPkIds())) {
                Object[] batchIntBillIds = unAuditResult.getSuccessPkIds().toArray();
                TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])batchIntBillIds, (OperateOption)OperateOption.create());
                continue;
            }
            throw new KDBizException(String.join((CharSequence)";", ((OperateErrorInfo)((ValidateResult)unAuditResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage()));
        }
    }

    public static String findExistBillsMsg(IfmBizResource ifmBizResource, String targetEntityName, HashSet<Long> targetBillIds) {
        DynamicObjectCollection query;
        QFilter filter = new QFilter("id", "in", targetBillIds);
        if (StringUtils.equals((CharSequence)targetEntityName, (CharSequence)EntityEnum.CAS_PAYBILL.getValue())) {
            filter.and(new QFilter("billstatus", "!=", (Object)"G"));
        }
        if ((query = QueryServiceHelper.query((String)targetEntityName, (String)"billno", (QFilter[])new QFilter[]{filter})) == null || query.size() <= 0) {
            return "";
        }
        List billnos = query.stream().map(v -> v.getString("billno")).collect(Collectors.toList());
        String targetBillName = EntityEnum.getName(targetEntityName);
        return String.format(ifmBizResource.getExistTargetBillDetail(), StringUtils.isBlank((CharSequence)targetBillName) ? targetEntityName : targetBillName, String.join((CharSequence)",", billnos));
    }

    public static void genBatchIntBill(Long sourceBillId, String type, String dataSource) {
        DynamicObject intBill = TmcDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ifm_interestbill");
        QFilter filter = new QFilter("entry.intbillid", "=", (Object)intBill.getLong("id"));
        boolean isExistBatchBill = TmcDataServiceHelper.exists((String)"ifm_intbill_batch_loan", (QFilter[])filter.toArray());
        if (!isExistBatchBill) {
            BizDealHelper.genBatchBill(intBill, type, dataSource);
        }
    }

    private static void genBatchBill(DynamicObject intBill, String type, String dataSource) {
        DynamicObject batchBill = TmcDataServiceHelper.newDynamicObject((String)"ifm_intbill_batch_loan");
        String batchNo = CodeRuleServiceHelper.getNumber((String)"ifm_intbill_batch_loan", (DynamicObject)batchBill, null);
        batchBill.set("billno", (Object)batchNo);
        batchBill.set("settlecenter", (Object)intBill.getLong("creditor"));
        batchBill.set("bizdate", (Object)DateUtils.getNextDay((Date)intBill.getDate("endinstdate"), (int)1));
        batchBill.set("businessdate", (Object)intBill.getDate("businessdate"));
        batchBill.set("org", (Object)intBill.getDynamicObject("org"));
        batchBill.set("description", (Object)ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u53f7+\u3010\u5408\u540c\u5355\u636e\u53f7\u3011+\u3010\u7ed3\u606f\u65e5\u671f\u3011+\u4ed8\u606f+\u3010\u501f\u6b3e\u5e01\u79cd\u3011+\u3010\u5b9e\u4ed8\u5229\u606f\u3011", (String)"BizDealHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
        DynamicObject entry = batchBill.getDynamicObjectCollection("entry").addNew();
        entry.set("intbillid", (Object)intBill.getLong("id"));
        entry.set("intdetailnum", (Object)intBill.getString("billno"));
        entry.set("company", (Object)intBill.getDynamicObject("org"));
        logger.info("sourcebillid: {}", (Object)intBill.getLong("sourcebillid"));
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)intBill.getLong("sourcebillid"), (String)"cfm_loanbill");
        entry.set("loanbillid", (Object)loanBill.getLong("id"));
        entry.set("loanbillno", (Object)loanBill.getString("billno"));
        DynamicObject loancontractbill = loanBill.getDynamicObject("loancontractbill");
        entry.set("loancontractbillno", (Object)loancontractbill.getString("number"));
        entry.set("contractnum", (Object)loancontractbill.getString("contractno"));
        entry.set("currency", (Object)loanBill.getDynamicObject("currency"));
        entry.set("loancurrency", (Object)loanBill.getDynamicObject("currency"));
        entry.set("inttype", (Object)SettleTypeEnum.JX.getValue());
        Date startDate = intBill.getDate("startinstdate");
        Date endDate = intBill.getDate("endinstdate");
        entry.set("startdate", (Object)startDate);
        entry.set("enddate", (Object)endDate);
        entry.set("payintdate", (Object)intBill.getDate("bizdate"));
        entry.set("accountbank", (Object)intBill.getDynamicObject("instbankacct"));
        entry.set("creditorg", (Object)intBill.getDynamicObject("creditorg"));
        entry.set("textcreditor", (Object)intBill.getString("textcreditor"));
        entry.set("status", (Object)"success");
        int intDays = 0;
        BigDecimal intAmt = BigDecimal.ZERO;
        for (DynamicObject entrys : intBill.getDynamicObjectCollection("entrys")) {
            intAmt = intAmt.add(entrys.getBigDecimal("instamt"));
            intDays += entrys.getInt("instdays");
        }
        entry.set("intdays", (Object)intDays);
        entry.set("interestamt", (Object)intAmt);
        entry.set("actualinstamt", (Object)intBill.getBigDecimal("actualinstamt"));
        entry.set("convertrate", (Object)BigDecimal.ONE);
        entry.set("convertintamt", (Object)intBill.getBigDecimal("actualinstamt"));
        String inComment = String.format(ResManager.loadKDString((String)"\u5408\u540c\u5355\u636e\u53f7%1$s%2$s,\u4ed8\u606f%3$s%4$s", (String)"BizDealHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]), loancontractbill.getString("number"), DateUtils.formatString((Date)intBill.getDate("endinstdate"), (String)"yyyyMMdd"), loanBill.getDynamicObject("currency").getString("name"), intAmt);
        entry.set("intcomment", (Object)inComment);
        IntBillInfo intBillInfo = BizDealHelper.genIntDetail(intBill);
        List details = intBillInfo.getDetails();
        if (EmptyUtil.isNoEmpty((Object)details)) {
            details.sort((arg0, arg1) -> arg1.getEndDate().compareTo(arg0.getEndDate()));
            entry.set("rate", (Object)((IntBillDetailInfo)details.get(0)).getRate());
            entry.set("principle", (Object)((IntBillDetailInfo)details.get(0)).getPrinciple());
        } else {
            entry.set("rate", (Object)BigDecimal.ZERO);
            entry.set("principle", (Object)BigDecimal.ZERO);
        }
        entry.set("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)intBillInfo));
        batchBill.set("biztype", (Object)"loan");
        batchBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        batchBill.set("createtime", (Object)new Date());
        batchBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        if ("1".equals(type)) {
            batchBill.set("interesttype", (Object)InterestSettleTypeEnum.HBFX.getValue());
        } else {
            batchBill.set("interesttype", (Object)InterestSettleTypeEnum.FX.getValue());
        }
        batchBill.set("datasource", (Object)dataSource);
        batchBill.set("bizdealno", (Object)intBill.getString("bizdealno"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{batchBill});
    }

    private static IntBillInfo genIntDetail(DynamicObject intBill) {
        IntBillInfo detail = new IntBillInfo();
        detail.setAmount(intBill.getBigDecimal("amount"));
        detail.setBizDate(intBill.getDate("bizdate"));
        DynamicObjectCollection entrys = intBill.getDynamicObjectCollection("entrys");
        int index = 0;
        ArrayList<IntBillDetailInfo> intDetails = new ArrayList<IntBillDetailInfo>(16);
        for (DynamicObject entry : entrys) {
            IntBillDetailInfo intDetail = new IntBillDetailInfo();
            intDetail.setPrinciple(entry.getBigDecimal("instprincipalamt"));
            intDetail.setDays(entry.getInt("instdays"));
            intDetail.setBeginDate(entry.getDate("inststartdate"));
            intDetail.setEndDate(entry.getDate("instenddate"));
            InterTypeEnum intType = InterTypeEnum.valueOf((String)entry.getString("instctg"));
            intDetail.setIntType(intType);
            intDetail.setBasisDay(entry.getInt("ratetrandays"));
            intDetail.setAmount(entry.getBigDecimal("instamt"));
            intDetail.setRate(entry.getBigDecimal("rate"));
            intDetail.setSeq(index++);
            intDetails.add(intDetail);
        }
        detail.setDetails(intDetails);
        return detail;
    }

    public static DynamicObject updateSrcBillInfo(String entityName, String fields, QFilter qFilter) {
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((String)entityName, (String)fields, (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)srcBill)) {
            srcBill.set("settlestatus", (Object)"submit");
            srcBill.set("bankcheckflag", null);
            if ("cfm_loanbill".equals(entityName)) {
                srcBill.set("drawtype", (Object)"drawing");
            }
            SaveServiceHelper.update((DynamicObject)srcBill);
        }
        return srcBill;
    }

    public static void asyncDelRecPayInfo(Object[] bizIds, boolean isPay) {
        QFilter filter;
        if (EmptyUtil.isEmpty((Object[])bizIds)) {
            return;
        }
        HashMap<String, Object> msgParamMap = new HashMap<String, Object>();
        String innerBillName = isPay ? "ifm_transhandlebill" : "ifm_rectransbill";
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)innerBillName, (String)"id", (QFilter[])(filter = new QFilter("sourcebillid", "in", (Object)bizIds)).toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)transBills)) {
            Object[] transBillIds = transBills.stream().map(v -> v.get("id")).toArray();
            msgParamMap.put("ifmentityname", innerBillName);
            msgParamMap.put("transbillids", transBillIds);
        }
        filter.and("billstatus", "!=", (Object)"G");
        String casBillName = isPay ? "cas_paybill" : "cas_recbill";
        DynamicObjectCollection casBills = QueryServiceHelper.query((String)casBillName, (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)casBills)) {
            Object[] casBillIds = casBills.stream().map(v -> v.get("id")).toArray();
            msgParamMap.put("casentityname", casBillName);
            msgParamMap.put("recpayids", casBillIds);
        }
        if (EmptyUtil.isNoEmpty(msgParamMap)) {
            TmcMQParam.build((TmcMQTypeEnum)TmcMQTypeEnum.AUTO_ASYNC_DEL_RECPAY, msgParamMap).sendMessageInDbTranscation("kd.tmc.ifm.trans");
        }
    }
}

