/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.bean.DeductionPayBean;
import kd.tmc.ifm.enums.DeductionPayTypeEnum;
import kd.tmc.ifm.enums.PayStatusEnum;

public class DeductionPayHelper {
    public static void payStatusWriteBack(DynamicObject[] deductions) {
        Object[] sourceBillIds = Arrays.stream(deductions).filter(o -> EmptyUtil.isNoEmpty((Object)o.get("sourcebillid"))).map(d -> d.get("sourcebillid")).toArray();
        if (EmptyUtil.isEmpty((Object[])sourceBillIds)) {
            return;
        }
        Object[] agentDeductions = BusinessDataServiceHelper.load((Object[])sourceBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fs_agentdeduction"));
        if (EmptyUtil.isEmpty((Object[])agentDeductions)) {
            return;
        }
        Map<Long, BigDecimal> deductionAmountMap = Arrays.stream(deductions).collect(Collectors.toMap(o -> o.getLong("sourcebillid"), o -> o.getBigDecimal("realamount"), (v1, v2) -> v2));
        for (Object agentDeduction : agentDeductions) {
            BigDecimal deductionAmount = deductionAmountMap.get(agentDeduction.getLong("id"));
            if (deductionAmount == null) continue;
            agentDeduction.set("realamount", (Object)deductionAmount);
        }
        List deductionsEntryRows = Arrays.stream(deductions).map(d -> d.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).collect(Collectors.toList());
        List agentDeductionsEntryRows = Arrays.stream(agentDeductions).map(d -> d.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).collect(Collectors.toList());
        for (DynamicObject agentDeductionsEntryRow : agentDeductionsEntryRows) {
            for (DynamicObject deductionsEntryRow : deductionsEntryRows) {
                if (!Objects.equals(deductionsEntryRow.get("sourceentryid"), agentDeductionsEntryRow.getPkValue())) continue;
                agentDeductionsEntryRow.set("paystatus", deductionsEntryRow.get("paystatus"));
                agentDeductionsEntryRow.set("returncomment", deductionsEntryRow.get("returncomment"));
            }
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fs_agentdeduction", (DynamicObject[])agentDeductions, (OperateOption)OperateOption.create());
    }

    public static void revertDeductionBill(DynamicObject transBill) {
        if (!"ifm_deduction".equals(transBill.getString("sourcebilltype"))) {
            return;
        }
        Long deductionBillId = (Long)transBill.get("sourcebillid");
        Long sourceBillEntryId = (Long)transBill.get("sourcebillentryid");
        if (EmptyUtil.isNoEmpty((Long)deductionBillId) && EmptyUtil.isNoEmpty((Long)sourceBillEntryId)) {
            ArrayList<DeductionPayBean> deductionPayBeans = new ArrayList<DeductionPayBean>(10);
            DeductionPayBean deductionPayBean = new DeductionPayBean();
            deductionPayBean.setBillId(deductionBillId);
            deductionPayBean.setEntryRowId(sourceBillEntryId);
            deductionPayBeans.add(deductionPayBean);
            DeductionPayHelper.payCancel(deductionPayBeans);
        }
    }

    public static void payConfirm(List<DeductionPayBean> deductionPayBeans) {
        DeductionPayHelper.checkDeductionPayBean(deductionPayBeans, DeductionPayTypeEnum.CONFIRM);
        Object[] billIds = deductionPayBeans.stream().map(DeductionPayBean::getBillId).distinct().toArray();
        DynamicObject[] deductions = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_deduction"));
        if (deductions.length == 0) {
            return;
        }
        for (DynamicObject deduction : deductions) {
            DynamicObjectCollection entry = deduction.getDynamicObjectCollection("entryentity");
            BigDecimal realAmount = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                if (Objects.equals(row.get("paystatus"), PayStatusEnum.SUCCEED.getValue())) {
                    realAmount = realAmount.add(row.getBigDecimal("payamount"));
                }
                for (DeductionPayBean deductionPayBean : deductionPayBeans) {
                    if (!Objects.equals(deduction.getPkValue(), deductionPayBean.getBillId()) || !Objects.equals(row.getPkValue(), deductionPayBean.getEntryRowId())) continue;
                    row.set("paystatus", (Object)PayStatusEnum.SUCCEED.getValue());
                    realAmount = realAmount.add(row.getBigDecimal("payamount"));
                }
            }
            BigDecimal amount = deduction.getBigDecimal("receiveamount");
            if (realAmount.compareTo(amount) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u9645\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6263\u6b3e\u91d1\u989d", (String)"DeductionPayHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
            }
            deduction.set("realamount", (Object)realAmount);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_deduction", (DynamicObject[])deductions, (OperateOption)OperateOption.create());
        DeductionPayHelper.payStatusWriteBack(deductions);
    }

    public static void payBack(List<DeductionPayBean> deductionPayBeans) {
        DeductionPayHelper.checkDeductionPayBean(deductionPayBeans, DeductionPayTypeEnum.BACK);
        Object[] billIds = deductionPayBeans.stream().map(DeductionPayBean::getBillId).distinct().toArray();
        DynamicObject[] deductions = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_deduction"));
        if (deductions.length == 0) {
            return;
        }
        for (DynamicObject deduction : deductions) {
            DynamicObjectCollection entry = deduction.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                for (DeductionPayBean deductionPayBean : deductionPayBeans) {
                    if (!Objects.equals(deduction.getPkValue(), deductionPayBean.getBillId()) || !Objects.equals(row.getPkValue(), deductionPayBean.getEntryRowId())) continue;
                    row.set("paystatus", (Object)PayStatusEnum.FAILED.getValue());
                    row.set("returncomment", (Object)deductionPayBean.getReturnMessage());
                }
            }
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_deduction", (DynamicObject[])deductions, (OperateOption)OperateOption.create());
        DeductionPayHelper.payStatusWriteBack(deductions);
    }

    public static void payCancel(List<DeductionPayBean> deductionPayBeans) {
        Object[] billIds = deductionPayBeans.stream().map(DeductionPayBean::getBillId).distinct().toArray();
        DynamicObject[] deductions = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_deduction"));
        if (deductions.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> idToDOMap = new HashMap<Long, DynamicObject>(16);
        for (Object deduction : deductions) {
            idToDOMap.put(deduction.getLong("id"), (DynamicObject)deduction);
        }
        for (DeductionPayBean deductionPayBean : deductionPayBeans) {
            DynamicObject deductionDO = (DynamicObject)idToDOMap.get(deductionPayBean.getBillId());
            if (deductionDO == null) continue;
            DynamicObjectCollection entry = deductionDO.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                if (!Objects.equals(row.getPkValue(), deductionPayBean.getEntryRowId())) continue;
                row.set("paystatus", (Object)PayStatusEnum.DOING.getValue());
                row.set("returncomment", null);
            }
        }
        for (Object deduction : deductions) {
            DynamicObjectCollection entry = deduction.getDynamicObjectCollection("entryentity");
            BigDecimal realAmount = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                if (!Objects.equals(row.get("paystatus"), PayStatusEnum.SUCCEED.getValue())) continue;
                realAmount = realAmount.add(row.getBigDecimal("payamount"));
            }
            deduction.set("realamount", (Object)realAmount);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_deduction", (DynamicObject[])deductions, (OperateOption)OperateOption.create());
        DeductionPayHelper.payStatusWriteBack(deductions);
    }

    private static void checkDeductionPayBean(List<DeductionPayBean> deductionPayBeans, DeductionPayTypeEnum payType) {
        for (DeductionPayBean deductionPayBean : deductionPayBeans) {
            if (deductionPayBean == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionPayHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]));
            }
            if (Objects.isNull(deductionPayBean.getBillId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionPayHelper_2", (String)"tmc-ifm-common", (Object[])new Object[0]));
            }
            if (Objects.isNull(deductionPayBean.getEntryRowId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u884cID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionPayHelper_3", (String)"tmc-ifm-common", (Object[])new Object[0]));
            }
            if (!Objects.equals((Object)payType, (Object)DeductionPayTypeEnum.BACK) || !StringUtils.isEmpty((CharSequence)deductionPayBean.getReturnMessage())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeductionPayHelper_4", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
    }
}

