/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.helper.IntSegmentHelper;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import kd.tmc.ifm.enums.ReleaseTypeEnum;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class DepositHelper {
    public static final BigDecimal RATE_MAX = BigDecimal.valueOf(Math.pow(10.0, 13.0));
    private static final Log LOG = LogFactory.getLog(DepositHelper.class);

    public static boolean judgeUseDemandRate(DynamicObject depositF7, String releaseType, Date redeemDate) {
        Date expireDate;
        boolean isNoticeTemporary = StringUtils.equals((CharSequence)ReleaseTypeEnum.temporary.getValue(), (CharSequence)releaseType);
        boolean isFixInAdvance = StringUtils.equals((CharSequence)ReleaseTypeEnum.inadvance.getValue(), (CharSequence)releaseType);
        boolean isFixAgreeOnAndExpire = false;
        if (StringUtils.equals((CharSequence)ReleaseTypeEnum.expire.getValue(), (CharSequence)releaseType) && EmptyUtil.isNoEmpty((Object)(expireDate = depositF7.getDate("expiredate"))) && redeemDate.compareTo(expireDate) > 0) {
            isFixAgreeOnAndExpire = true;
        }
        return isNoticeTemporary || isFixInAdvance || isFixAgreeOnAndExpire;
    }

    public static void addRevenueCalDetailEntry(DynamicObjectCollection intDetails, List<IntBillDetailInfo> details) {
        intDetails.clear();
        if (EmptyUtil.isEmpty(details)) {
            return;
        }
        for (IntBillDetailInfo detail : details) {
            DynamicObject intDetail = intDetails.addNew();
            intDetail.set("estartdate", (Object)detail.getBeginDate());
            intDetail.set("eenddate", (Object)detail.getEndDate());
            intDetail.set("edays", (Object)detail.getDays());
            intDetail.set("efinamount", (Object)detail.getPrinciple());
            intDetail.set("eplanrevenue", (Object)detail.getRate());
            intDetail.set("econvertdays", (Object)detail.getBasisDay());
            intDetail.set("erevenueamount", (Object)detail.getAmount());
        }
    }

    public static IntBillInfo calcDepositBillInt(DynamicObject releaseBill) {
        DynamicObject depositF7 = releaseBill.getDynamicObject("finbillno");
        Date beginDate = depositF7.getDate("intdate");
        Date endDate = releaseBill.getDate("redeemdate");
        if (endDate.compareTo(beginDate) <= 0) {
            IntBillInfo intBillInfo = new IntBillInfo();
            intBillInfo.setAmount(BigDecimal.ZERO);
            return intBillInfo;
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = DepositHelper.getBizBill(releaseBill);
        request.setBizBill(bizBill);
        Set<RateInfo> rateSet = DepositHelper.getRateList(releaseBill, bizBill);
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        DepositHelper.calOverDatePartInt(releaseBill, bizBill, request, stragety, intBillInfo);
        DepositHelper.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    private static void validateIntMaxValue(IntBillInfo intBillInfo) {
        if (intBillInfo.getAmount().compareTo(RATE_MAX) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d4b\u7b97\u672a\u6765\u6536\u76ca\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepositDealEdit_1", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
    }

    private static BizBillInfo getBizBill(DynamicObject releaseBill) {
        DynamicObject depositF7;
        DynamicObject productFactory;
        BizBillInfo bizBill = new BizBillInfo();
        String releaseType = releaseBill.getString("releasetype");
        if (StringUtils.equals((CharSequence)ReleaseTypeEnum.expire.getValue(), (CharSequence)releaseType)) {
            bizBill.setIntCalMethod(IntCalMethodEnum.periodcallint);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(productFactory = (depositF7 = releaseBill.getDynamicObject("finbillno")).getDynamicObject("productfactory")))) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"cim_investmodel");
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
            IntCalMethodEnum intCalMethod = IntCalMethodEnum.valueOf((String)productFactory.getString("intcalmethod"));
            bizBill.setIntCalMethod(intCalMethod);
            String intheadtailrule = productFactory.getString("intheadtailrule");
            bizBill.setHtRule(IntHTRuleEnum.valueOf((String)intheadtailrule));
        }
        bizBill.setBeginDate(depositF7.getDate("intdate"));
        bizBill.setEndDate(releaseBill.getDate("redeemdate"));
        bizBill.setBasis(BasisEnum.getEnum((String)depositF7.getString("basis")));
        bizBill.setLoanAmount(releaseBill.getBigDecimal("amount"));
        bizBill.setCurrencyId(releaseBill.getDynamicObject("currency").getLong("id"));
        return bizBill;
    }

    private static Set<RateInfo> getRateList(DynamicObject releaseBill, BizBillInfo bizBill) {
        Set<RateInfo> set = new HashSet<RateInfo>(2);
        DynamicObject depositF7 = releaseBill.getDynamicObject("finbillno");
        String intType = depositF7.getString("interesttype");
        Date startDate = bizBill.getBeginDate();
        Date redeemDate = releaseBill.getDate("redeemdate");
        String investType = Optional.ofNullable(releaseBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isNotice((String)investType)) {
            if (ReleaseTypeEnum.isAgreeon(releaseBill.getString("releasetype"))) {
                if (InterestTypeEnum.isFixed((String)intType)) {
                    DepositHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("interestrate"));
                } else {
                    set = DepositHelper.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                }
            } else {
                DepositHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("demandrate"));
            }
        } else {
            Date expireDate = depositF7.getDate("expiredate");
            if (redeemDate.compareTo(expireDate) < 0) {
                bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
                DepositHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("demandrate"));
            } else if (redeemDate.compareTo(expireDate) == 0) {
                if (InterestTypeEnum.isFixed((String)intType)) {
                    DepositHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("interestrate"));
                } else {
                    set = DepositHelper.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                }
            } else {
                bizBill.setEndDate(expireDate);
                if (InterestTypeEnum.isFixed((String)intType)) {
                    DepositHelper.addElementForSet(set, startDate, releaseBill.getBigDecimal("interestrate"));
                } else {
                    set = DepositHelper.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                }
            }
        }
        return set;
    }

    private static void addElementForSet(Set<RateInfo> set, Date startDate, BigDecimal rate) {
        RateInfo rateInfo = new RateInfo();
        rateInfo.setEffectiveDate(startDate);
        rateInfo.setRate(rate);
        set.add(rateInfo);
    }

    public static Set<RateInfo> getRateInfoWhenFloat(DynamicObject deposit, Date beginDate, Date endDate) {
        String referRateNumber = Optional.ofNullable(deposit.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
        Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)beginDate, (Date)endDate);
        if (CollectionUtils.isEmpty((Map)rateDateVal)) {
            throw DepositHelper.refferRateNotExistException();
        }
        String rateSign = deposit.getString("ratesign");
        BigDecimal rateFloatPoint = deposit.getBigDecimal("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>(rateDateVal.size());
        for (Map.Entry entry : rateDateVal.entrySet()) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)entry.getKey());
            info.setRate(((BigDecimal)entry.getValue()).add(rateFloat));
            rateSet.add(info);
        }
        return rateSet;
    }

    private static void calOverDatePartInt(DynamicObject releaseBill, BizBillInfo bizBill, IntCalRequest request, IIntCallStragety stragety, IntBillInfo intBillInfo) {
        DynamicObject depositF7 = releaseBill.getDynamicObject("finbillno");
        String investType = Optional.ofNullable(releaseBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isFixed((String)investType)) {
            Date expireDate = depositF7.getDate("expiredate");
            Date redeemDate = releaseBill.getDate("redeemdate");
            if (redeemDate.compareTo(expireDate) > 0) {
                bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
                bizBill.setBeginDate(expireDate);
                bizBill.setEndDate(redeemDate);
                HashSet<RateInfo> set = new HashSet<RateInfo>(2);
                DepositHelper.addElementForSet(set, expireDate, releaseBill.getBigDecimal("demandrate"));
                request.setRateList(set);
                IntBillInfo overDateIntBill = stragety.callInt(request);
                if (EmptyUtil.isEmpty((Object)overDateIntBill)) {
                    return;
                }
                List details = overDateIntBill.getDetails();
                if (EmptyUtil.isNoEmpty((Object)details)) {
                    intBillInfo.setEndDate(((IntBillDetailInfo)details.get(details.size() - 1)).getEndDate());
                }
                intBillInfo.getDetails().addAll(details);
                intBillInfo.setAmount(intBillInfo.getAmount().add(overDateIntBill.getAmount()));
            }
        }
    }

    public static IntBillInfo calReleasePlanAmountAndAddEntry(DynamicObject depositBizDealBill) {
        Date redeemDate;
        Date startDate;
        Triple<Date, Date, Integer> dateTriple;
        IntBillInfo intBillInfo = new IntBillInfo();
        DynamicObject depositF7 = depositBizDealBill.getDynamicObject("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositF7)) {
            return intBillInfo;
        }
        DynamicObject productFactory = depositF7.getDynamicObject("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"cim_investmodel");
        }
        if ((Integer)(dateTriple = DepositHelper.reCalBeginEndDate(startDate = depositF7.getDate("intdate"), redeemDate = depositBizDealBill.getDate("redeemdate"), productFactory)).getRight() <= 0) {
            intBillInfo.setAmount(BigDecimal.ZERO);
            return intBillInfo;
        }
        intBillInfo.setBizDate((Date)dateTriple.getLeft());
        intBillInfo.setBeginDate((Date)dateTriple.getLeft());
        intBillInfo.setEndDate((Date)dateTriple.getMiddle());
        List<IntBillDetailInfo> detailInfos = new ArrayList<IntBillDetailInfo>();
        RoundingMode roundMode = DepositHelper.buildRoundingMode(productFactory);
        int yearDay = TermHelper.getBasis_YearDay((Date)intBillInfo.getBeginDate(), (Date)intBillInfo.getEndDate(), (BasisEnum)BasisEnum.getEnum((String)depositF7.getString("basis")));
        String investType = Optional.ofNullable(depositBizDealBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        String intType = depositF7.getString("interesttype");
        detailInfos = InvestTypeEnum.isNotice((String)investType) ? DepositHelper.buildNoticeIntDetailList(intType, depositBizDealBill, dateTriple, yearDay, roundMode, detailInfos) : DepositHelper.buildFixIntDetailList(depositF7, depositBizDealBill, productFactory, dateTriple, yearDay, roundMode, detailInfos);
        intBillInfo.setDetails(detailInfos);
        Optional<BigDecimal> totalAmt = detailInfos.stream().map(IntBillDetailInfo::getAmount).reduce(BigDecimal::add);
        intBillInfo.setAmount(totalAmt.orElse(BigDecimal.ZERO));
        return intBillInfo;
    }

    public static RoundingMode buildRoundingMode(DynamicObject productFactory) {
        RoundingMode roundMode = RoundingMode.HALF_UP;
        String intRoundRule = Optional.ofNullable(productFactory).map(r -> r.getString("introundrule")).orElse("");
        if (StringUtils.equals((CharSequence)RoundRuleEnum.give.getValue(), (CharSequence)intRoundRule)) {
            roundMode = RoundingMode.FLOOR;
        } else if (StringUtils.equals((CharSequence)RoundRuleEnum.carry.getValue(), (CharSequence)intRoundRule)) {
            roundMode = RoundingMode.CEILING;
        }
        return roundMode;
    }

    private static Triple<Date, Date, Integer> reCalBeginEndDate(Date startDate, Date endDate, DynamicObject productFactory) {
        IntHTRuleEnum intHTRuleEnum = Optional.ofNullable(productFactory).filter(r -> "cash".equals(r.getString("profittype"))).map(r -> IntHTRuleEnum.valueOf((String)r.getString("intheadtailrule"))).orElse(IntHTRuleEnum.headnotail);
        switch (intHTRuleEnum) {
            case headnotail: {
                endDate = DateUtils.getLastDay((Date)endDate, (int)1);
                break;
            }
            case noheadnotail: {
                startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                endDate = DateUtils.getLastDay((Date)endDate, (int)1);
                break;
            }
            case noheadtail: {
                startDate = DateUtils.getNextDay((Date)startDate, (int)1);
            }
        }
        return Triple.of((Object)startDate, (Object)endDate, (Object)DateUtils.getDiffDays((Date)startDate, (Date)endDate));
    }

    private static List<IntBillDetailInfo> buildNoticeIntDetailList(String intType, DynamicObject depositBizDealBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode, List<IntBillDetailInfo> detailInfos) {
        String releaseType = Optional.ofNullable(depositBizDealBill.getString("releasetype")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u89e3\u6d3b\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"DepositHelper_2", (String)"tmc-ifm-common", (Object[])new Object[0])));
        if (StringUtils.equals((CharSequence)ReleaseTypeEnum.agreeon.getValue(), (CharSequence)releaseType)) {
            if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
                IntBillDetailInfo detailInfo = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, true);
                detailInfos.add(detailInfo);
            } else {
                detailInfos = DepositHelper.buildListIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode);
            }
        } else {
            IntBillDetailInfo detailInfo = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, false);
            detailInfos.add(detailInfo);
        }
        return detailInfos;
    }

    private static List<IntBillDetailInfo> buildFixIntDetailList(DynamicObject depositF7, DynamicObject depositBizDealBill, DynamicObject productFactory, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode, List<IntBillDetailInfo> detailInfos) {
        Date expireDate = depositF7.getDate("expiredate");
        String intType = depositF7.getString("interesttype");
        Date startDate = depositF7.getDate("intdate");
        Date redeemDate = depositBizDealBill.getDate("redeemdate");
        if (redeemDate.compareTo(expireDate) < 0) {
            IntBillDetailInfo detailInfo = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, false);
            detailInfos.add(detailInfo);
        } else if (redeemDate.compareTo(expireDate) == 0) {
            if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
                IntBillDetailInfo detailInfo = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, true);
                detailInfos.add(detailInfo);
            } else {
                detailInfos = DepositHelper.buildListIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode);
            }
        } else if (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType)) {
            dateTriple = DepositHelper.reCalBeginEndDate(startDate, expireDate, productFactory);
            IntBillDetailInfo detailInfo1 = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, true);
            detailInfos.add(detailInfo1);
            dateTriple = DepositHelper.reCalBeginEndDate(expireDate, redeemDate, productFactory);
            IntBillDetailInfo detailInfo2 = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, false);
            detailInfos.add(detailInfo2);
        } else {
            dateTriple = DepositHelper.reCalBeginEndDate(startDate, expireDate, productFactory);
            detailInfos = DepositHelper.buildListIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode);
            dateTriple = DepositHelper.reCalBeginEndDate(expireDate, redeemDate, productFactory);
            IntBillDetailInfo detailInfo = DepositHelper.buildSingleIntBillDetailInfo(depositBizDealBill, dateTriple, yearDay, roundMode, false);
            detailInfos.add(detailInfo);
        }
        return detailInfos;
    }

    public static IntBillDetailInfo buildSingleIntBillDetailInfo(DynamicObject finBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode) {
        IntBillDetailInfo detailInfo = new IntBillDetailInfo();
        detailInfo.setBeginDate((Date)dateTriple.getLeft());
        detailInfo.setEndDate((Date)dateTriple.getMiddle());
        detailInfo.setDays(((Integer)dateTriple.getRight()).intValue());
        detailInfo.setBasisDay(yearDay);
        BigDecimal amount = finBill.getBigDecimal("surplusamount");
        detailInfo.setPrinciple(amount);
        BigDecimal useInt = finBill.getBigDecimal("interestrate");
        detailInfo.setRate(useInt);
        BigDecimal rateAmount = amount.multiply(useInt.divide(Constants.ONE_HUNDRED, 6, roundMode)).multiply(BigDecimal.valueOf(((Integer)dateTriple.getRight()).intValue())).divide(BigDecimal.valueOf(yearDay), 6, roundMode);
        detailInfo.setAmount(rateAmount);
        return detailInfo;
    }

    public static IntBillDetailInfo buildSingleIntBillDetailInfo(DynamicObject releaseBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode, boolean useDepositInt) {
        IntBillDetailInfo detailInfo = new IntBillDetailInfo();
        detailInfo.setBeginDate((Date)dateTriple.getLeft());
        detailInfo.setEndDate((Date)dateTriple.getMiddle());
        detailInfo.setDays(((Integer)dateTriple.getRight()).intValue());
        detailInfo.setBasisDay(yearDay);
        BigDecimal releaseAmount = releaseBill.getBigDecimal("amount");
        detailInfo.setPrinciple(releaseAmount);
        BigDecimal useInt = useDepositInt ? releaseBill.getBigDecimal("interestrate") : releaseBill.getBigDecimal("demandrate");
        detailInfo.setRate(useInt);
        BigDecimal rateAmount = releaseAmount.multiply(useInt.divide(Constants.ONE_HUNDRED, 6, roundMode)).multiply(BigDecimal.valueOf(((Integer)dateTriple.getRight()).intValue())).divide(BigDecimal.valueOf(yearDay), 6, roundMode);
        detailInfo.setAmount(rateAmount);
        return detailInfo;
    }

    public static List<IntBillDetailInfo> buildListIntBillDetailInfo(DynamicObject releaseBill, Triple<Date, Date, Integer> dateTriple, int yearDay, RoundingMode roundMode) {
        DynamicObject depositF7 = releaseBill.getDynamicObject("finbillno");
        String referRateNumber = Optional.ofNullable(depositF7.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
        Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)((Date)dateTriple.getLeft()), (Date)((Date)dateTriple.getMiddle()));
        if (CollectionUtils.isEmpty((Map)rateDateVal)) {
            throw DepositHelper.refferRateNotExistException();
        }
        String rateSign = depositF7.getString("ratesign");
        BigDecimal rateFloatPoint = depositF7.getBigDecimal("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if ("subtract".equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        TreeMap referRateTree = new TreeMap(Date::compareTo);
        referRateTree.putAll(rateDateVal);
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>(referRateTree.size());
        for (Map.Entry entry : referRateTree.entrySet()) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)entry.getKey());
            info.setRate(((BigDecimal)entry.getValue()).add(rateFloat));
            rateSet.add(info);
        }
        List<IntBillDetailInfo> intDetailInfo = DepositHelper.getSubRate(rateSet, (Date)dateTriple.getLeft(), (Date)dateTriple.getMiddle());
        BigDecimal releaseAmount = releaseBill.getBigDecimal("amount");
        intDetailInfo.forEach(r -> {
            r.setBasisDay(yearDay);
            r.setPrinciple(releaseAmount);
            r.setAmount(releaseAmount.multiply(r.getRate().divide(Constants.ONE_HUNDRED, 6, roundMode)).multiply(BigDecimal.valueOf(r.getDays())).divide(BigDecimal.valueOf(yearDay), 6, roundMode));
        });
        return intDetailInfo;
    }

    public static KDBizException refferRateNotExistException() {
        return new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"DepositHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]));
    }

    public static List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        List detailList = IntSegmentHelper.getSubRate(rateList, (Date)beginDate, (Date)endDate);
        return IntSegmentHelper.orderAGenEndDateAndDays((List)detailList, (Date)endDate);
    }

    public static void writeBackApplyBill(DynamicObject[] bizDealBills, String applyStatus) {
        DynamicObject[] applyBills;
        List applyBIllIds = Arrays.stream(bizDealBills).map(v -> v.getDynamicObject("apply")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(applyBIllIds)) {
            return;
        }
        for (DynamicObject applyBill : applyBills = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"applystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBIllIds)})) {
            applyBill.set("applystatus", (Object)applyStatus);
        }
        SaveServiceHelper.update((DynamicObject[])applyBills);
    }

    public static void writeBackRevenueBill(DynamicObject[] dataEntities, String confirmstatus) {
        List revenueBillNos = Arrays.stream(dataEntities).map(v -> v.getString("sourcebillno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(revenueBillNos)) {
            DynamicObject[] revenueBills;
            for (DynamicObject revenueBill : revenueBills = TmcDataServiceHelper.load((String)"cim_dptrevenue", (String)"id,confirmstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", revenueBillNos)})) {
                revenueBill.set("confirmstatus", (Object)confirmstatus);
            }
            TmcDataServiceHelper.save((DynamicObject[])revenueBills);
        }
    }

    public static boolean isSettleCenterBill(DynamicObject bizDealBill) {
        DynamicObject finOrgInfo = bizDealBill.getDynamicObject("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return false;
        }
        finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)finOrgInfo.getPkValue(), (String)"bd_finorginfo");
        return StringUtils.equals((CharSequence)finOrgInfo.getDynamicObject("finorgtype").getString("type"), (CharSequence)"1");
    }

    public static boolean isContainCurrency(DynamicObject bankAcct, long currencyId) {
        if (EmptyUtil.isEmpty((DynamicObject)bankAcct)) {
            return false;
        }
        DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
        for (DynamicObject currency : currencys) {
            if (currency.getDynamicObject("fbasedataid").getLong("id") != currencyId) continue;
            return true;
        }
        return false;
    }

    public static void clearRevenueInfo(DynamicObject ... bills) {
        if (EmptyUtil.isEmpty((Object[])bills)) {
            return;
        }
        for (DynamicObject bill : bills) {
            String applyType = bill.getString("applytype");
            boolean isRevenue = bill.getBoolean("isrevenue");
            if (!StringUtils.equals((CharSequence)applyType, (CharSequence)"release") || isRevenue) continue;
            bill.set("predictinstamt", (Object)0);
            bill.set("realrevenue", (Object)0);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entrys");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) continue;
            entrys.clear();
        }
    }

    public static BigDecimal calcRealRate(DynamicObjectCollection rows, BigDecimal revenueAmt) {
        BigDecimal totalPlanAmt = BigDecimal.ZERO;
        BigDecimal totalFinAmt = BigDecimal.ZERO;
        for (Object row : rows) {
            totalPlanAmt = totalPlanAmt.add(row.getBigDecimal("erevenueamount"));
            totalFinAmt = totalFinAmt.add(row.getBigDecimal("efinamount"));
        }
        ArrayList<BigDecimal> realRateList = new ArrayList<BigDecimal>(rows.size());
        for (DynamicObject row : rows) {
            BigDecimal dividedAmt = row.getBigDecimal("efinamount").multiply(new BigDecimal(row.getInt("edays"))).multiply(totalPlanAmt);
            if (EmptyUtil.isEmpty((BigDecimal)dividedAmt)) {
                return BigDecimal.ZERO;
            }
            BigDecimal realRatePerRow = revenueAmt.multiply(row.getBigDecimal("erevenueamount")).multiply(new BigDecimal(row.getInt("econvertdays"))).divide(dividedAmt, 10, 4);
            BigDecimal perRate = realRatePerRow.multiply(row.getBigDecimal("efinamount")).multiply(new BigDecimal("100")).divide(totalFinAmt, 10, 4);
            realRateList.add(perRate);
        }
        BigDecimal realRate = realRateList.stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        DepositHelper.validateIntMaxValue(realRate);
        return realRate;
    }

    private static void validateIntMaxValue(BigDecimal amount) {
        if (amount.compareTo(RATE_MAX) > 0) {
            LOG.info("\u5b9e\u9645\u6536\u76ca\u7387\u503c:{}", (Object)amount);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u9645\u6536\u76ca\u7387\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepositHelper_3", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
    }

    public static IntBillInfo calcDepositBillInt(DynamicObject depositBill, Date beginDate, Date endDate) {
        if (endDate.compareTo(beginDate) <= 0) {
            IntBillInfo intBillInfo = DepositHelper.buildEmptyIntBill();
            intBillInfo.setBeginDate(beginDate);
            intBillInfo.setEndDate(endDate);
            return intBillInfo;
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = DepositHelper.getBizBill(depositBill, beginDate, endDate);
        request.setBizBill(bizBill);
        request.setRepayList(DepositHelper.getAllReleasePlanList(depositBill, endDate));
        Set<RateInfo> rateSet = DepositHelper.getRateList(depositBill, beginDate, bizBill.getEndDate());
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return DepositHelper.buildEmptyIntBill();
        }
        DepositHelper.calOverDatePartInt(depositBill, bizBill, request, stragety, intBillInfo, endDate);
        DepositHelper.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    public static IntBillInfo calcDepositBillIntForReport(DynamicObject depositBill, Date beginDate, Date endDate) {
        if (endDate.compareTo(beginDate) <= 0) {
            IntBillInfo intBillInfo = DepositHelper.buildEmptyIntBill();
            intBillInfo.setBeginDate(beginDate);
            intBillInfo.setEndDate(endDate);
            return intBillInfo;
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = DepositHelper.getBizBill(depositBill, beginDate, endDate);
        request.setBizBill(bizBill);
        request.setRepayList(DepositHelper.getAllReleasePlanListForReport(depositBill, endDate));
        Set<RateInfo> rateSet = DepositHelper.getRateList(depositBill, beginDate, bizBill.getEndDate());
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return DepositHelper.buildEmptyIntBill();
        }
        DepositHelper.calOverDatePartInt(depositBill, bizBill, request, stragety, intBillInfo, endDate);
        DepositHelper.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    private static IntBillInfo buildEmptyIntBill() {
        IntBillInfo intBillInfo = new IntBillInfo();
        intBillInfo.setAmount(BigDecimal.ZERO);
        return intBillInfo;
    }

    private static BizBillInfo getBizBill(DynamicObject depositBill, Date beginDate, Date endDate) {
        DynamicObject productFactory;
        BizBillInfo bizBill = new BizBillInfo();
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isFixed((String)investType)) {
            bizBill.setIntCalMethod(IntCalMethodEnum.periodcallint);
            Date expireDate = depositBill.getDate("expiredate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && endDate.compareTo(expireDate) > 0) {
                endDate = expireDate;
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(productFactory = depositBill.getDynamicObject("productfactory")))) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"cim_investmodel");
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
            IntCalMethodEnum intCalMethod = IntCalMethodEnum.valueOf((String)productFactory.getString("intcalmethod"));
            bizBill.setIntCalMethod(intCalMethod);
            String intheadtailrule = productFactory.getString("intheadtailrule");
            bizBill.setHtRule(IntHTRuleEnum.valueOf((String)intheadtailrule));
        }
        bizBill.setBeginDate(beginDate);
        bizBill.setEndDate(endDate);
        bizBill.setBasis(BasisEnum.getEnum((String)depositBill.getString("basis")));
        bizBill.setLoanAmount(depositBill.getBigDecimal("amount"));
        bizBill.setCurrencyId(depositBill.getDynamicObject("currency").getLong("id"));
        if (bizBill.getBasis() == BasisEnum.Actual_365 || bizBill.getBasis() == BasisEnum.Actual_360) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        }
        Optional.ofNullable(depositBill.getDynamicObject("revenueproject")).ifPresent(r -> bizBill.setIntSchemeId(r.getLong("id")));
        return bizBill;
    }

    private static List<PlanCallResult> getAllReleasePlanList(DynamicObject depositBill, Date endDate) {
        DynamicObject[] releaseBills;
        ArrayList<PlanCallResult> releasePlanList = new ArrayList<PlanCallResult>(10);
        String tradeChannel = depositBill.getString("tradechannel");
        QFilter filter = new QFilter("finbillno", "=", depositBill.getPkValue());
        filter = "offline".equals(tradeChannel) ? filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())) : filter.and(new QFilter("bebankstatus", "=", (Object)"TS"));
        filter.and(new QFilter("redeemdate", "<=", (Object)endDate));
        for (DynamicObject releaseBill : releaseBills = TmcDataServiceHelper.load((String)"ifm_release", (String)"isrevenue,redeemdate,amount", (QFilter[])filter.toArray())) {
            PlanCallResult info = new PlanCallResult();
            info.setPayInt(releaseBill.getBoolean("isrevenue"));
            info.setBizDate(releaseBill.getDate("redeemdate"));
            info.setPrinciple(releaseBill.getBigDecimal("amount"));
            releasePlanList.add(info);
        }
        return releasePlanList;
    }

    private static List<PlanCallResult> getAllReleasePlanListForReport(DynamicObject depositBill, Date endDate) {
        DynamicObject[] releaseBills;
        ArrayList<PlanCallResult> releasePlanList = new ArrayList<PlanCallResult>(10);
        String tradeChannel = depositBill.getString("tradechannel");
        QFilter filter = new QFilter("finbillno", "=", depositBill.getPkValue());
        filter = "offline".equals(tradeChannel) ? filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())) : filter.and(new QFilter("bebankstatus", "=", (Object)"TS"));
        filter.and(new QFilter("redeemdate", "<=", (Object)endDate));
        for (DynamicObject releaseBill : releaseBills = TmcDataServiceHelper.load((String)"ifm_release", (String)"isrevenue,redeemdate,amount", (QFilter[])filter.toArray())) {
            PlanCallResult info = new PlanCallResult();
            info.setPayInt(false);
            info.setBizDate(releaseBill.getDate("redeemdate"));
            info.setPrinciple(releaseBill.getBigDecimal("amount"));
            releasePlanList.add(info);
        }
        return releasePlanList;
    }

    private static Set<RateInfo> getRateList(DynamicObject depositBill, Date beginDate, Date endDate) {
        Set<RateInfo> set = new HashSet<RateInfo>();
        String intType = depositBill.getString("interesttype");
        if (InterestTypeEnum.isFixed((String)intType)) {
            DepositHelper.addElementForSet(set, beginDate, depositBill.getBigDecimal("interestrate"));
        } else if (InterestTypeEnum.isFloat((String)intType)) {
            set = DepositHelper.getRateInfoWhenFloat(depositBill, beginDate, endDate);
        }
        return set;
    }

    private static void calOverDatePartInt(DynamicObject depositBill, BizBillInfo bizBill, IntCalRequest request, IIntCallStragety stragety, IntBillInfo intBillInfo, Date endDate) {
        Date expireDate;
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isFixed((String)investType) && endDate.compareTo(expireDate = depositBill.getDate("expiredate")) > 0) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
            bizBill.setBeginDate(expireDate);
            bizBill.setEndDate(endDate);
            HashSet<RateInfo> set = new HashSet<RateInfo>(2);
            DepositHelper.addElementForSet(set, expireDate, depositBill.getBigDecimal("demandrate"));
            request.setRateList(set);
            IntBillInfo overDateIntBill = stragety.callInt(request);
            if (EmptyUtil.isEmpty((Object)overDateIntBill)) {
                return;
            }
            List details = overDateIntBill.getDetails();
            if (EmptyUtil.isNoEmpty((Object)details)) {
                intBillInfo.setEndDate(((IntBillDetailInfo)details.get(details.size() - 1)).getEndDate());
            }
            intBillInfo.getDetails().addAll(details);
            intBillInfo.setAmount(intBillInfo.getAmount().add(overDateIntBill.getAmount()));
        }
    }

    public static void setRevenueEntry(DynamicObject revenueBill, IntBillInfo intBillInfo) {
        if (EmptyUtil.isEmpty((Object)intBillInfo)) {
            return;
        }
        revenueBill.set("prestartdate", (Object)intBillInfo.getBeginDate());
        revenueBill.set("prestenddate", (Object)intBillInfo.getEndDate());
        revenueBill.set("predictinstamt", (Object)intBillInfo.getAmount());
        revenueBill.set("realrevenue", (Object)intBillInfo.getAmount());
        List details = intBillInfo.getDetails();
        DynamicObjectCollection entrys = revenueBill.getDynamicObjectCollection("entrys");
        entrys.clear();
        if (EmptyUtil.isEmpty((Collection)details)) {
            return;
        }
        for (IntBillDetailInfo intDetail : details) {
            DynamicObject newRow = entrys.addNew();
            newRow.set("estartdate", (Object)intDetail.getBeginDate());
            newRow.set("eenddate", (Object)intDetail.getEndDate());
            newRow.set("edays", (Object)intDetail.getDays());
            newRow.set("efinamount", (Object)intDetail.getPrinciple());
            newRow.set("eplanrevenue", (Object)intDetail.getRate());
            newRow.set("econvertdays", (Object)intDetail.getBasisDay());
            newRow.set("erevenueamount", (Object)intDetail.getAmount());
        }
    }

    public static Map<String, Pair<String, String>> getBotpMap(boolean isFixed) {
        HashMap<String, Pair<String, String>> botpMap = new HashMap<String, Pair<String, String>>();
        if (isFixed) {
            botpMap.put("apply", Pair.of((Object)"cim_deposit_apply", (Object)"cim_release"));
            botpMap.put("cim", Pair.of((Object)"cim_deposit", (Object)"cim_release"));
            botpMap.put("ifm", Pair.of((Object)"ifm_deposit", (Object)"ifm_release"));
        } else {
            botpMap.put("apply", Pair.of((Object)"cim_deposit_apply", (Object)"cim_noticerelease"));
            botpMap.put("cim", Pair.of((Object)"cim_noticedeposit", (Object)"cim_noticerelease"));
            botpMap.put("ifm", Pair.of((Object)"ifm_notice_deposit", (Object)"ifm_notice_release"));
        }
        return botpMap;
    }

    public static List<Object> getScFinOrgTypeIds() {
        QFilter finOrgFilter = new QFilter("type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorgtype", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        return finOrgTypeIds;
    }
}

