/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;

public class InnerAcctFrozenHelper {
    public static final BigDecimal MAX_AMOUNT = new BigDecimal("999999999999.99");

    public static BigDecimal getTotalFrozenAmountByAcctBankId(Long acctBankId, Date bizDate) {
        long innerAcctId = InnerAcctFrozenHelper.getInnerAcctIdByAcctBankId(acctBankId);
        return innerAcctId > 0L ? InnerAcctFrozenHelper.getTotalFrozenAmountByInnerAcctId(innerAcctId, bizDate) : BigDecimal.ZERO;
    }

    public static long getInnerAcctIdByAcctBankId(Long accountBankId) {
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBankId, (String)"bd_accountbanks", (String)"inneracct.id");
        return accountBank != null ? accountBank.getLong("inneracct.id") : 0L;
    }

    public static BigDecimal getTotalFrozenAmountByInnerAcctId(Long innerAcctId, Date endDate) {
        DynamicObjectCollection accountFrozens;
        QFilter frozenFilter = new QFilter("account", "=", (Object)innerAcctId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (endDate != null) {
            frozenFilter.and("applydate", "<=", (Object)endDate);
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(accountFrozens = QueryServiceHelper.query((String)"ifm_accountfrozen", (String)"id,frozentype,applydate,auditdate,totalfrozenamount", (QFilter[])frozenFilter.toArray(), (String)"applydate desc")))) {
            return BigDecimal.ZERO;
        }
        accountFrozens.sort((a1, a2) -> a2.getDate("auditdate").compareTo(a1.getDate("auditdate")));
        return InnerAcctFrozenHelper.getTotalFrozenAmount((DynamicObject)accountFrozens.get(0));
    }

    private static BigDecimal getTotalFrozenAmount(DynamicObject accountFrozen) {
        switch (InnerAccountFrozenTypeEnum.getByValue(accountFrozen.getString("frozentype"))) {
            case ACCOUNT_FROZEN: {
                return MAX_AMOUNT;
            }
            case ACCOUNT_THAW: 
            case AMOUNT_THAW: 
            case AMOUNT_FROZEN: {
                return accountFrozen.getBigDecimal("totalfrozenamount");
            }
        }
        return BigDecimal.ZERO;
    }

    public static TreeMap<Date, BigDecimal> getFrozenAmountMapByAcctBankId(Long acctBankId, Date endDate) {
        DynamicObjectCollection accountFrozens;
        Long innerAcctId = InnerAcctFrozenHelper.getInnerAcctIdByAcctBankId(acctBankId);
        QFilter frozenFilter = new QFilter("account", "=", (Object)innerAcctId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (endDate != null) {
            frozenFilter.and("applydate", "<=", (Object)endDate);
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(accountFrozens = QueryServiceHelper.query((String)"ifm_accountfrozen", (String)"id,frozentype,applydate,totalfrozenamount,createtime", (QFilter[])frozenFilter.toArray(), (String)"applydate desc")))) {
            return new TreeMap<Date, BigDecimal>();
        }
        TreeMap<Date, BigDecimal> map = new TreeMap<Date, BigDecimal>(Date::compareTo);
        TreeMap<Date, List<DynamicObject>> applyDateMap = new TreeMap<Date, List<DynamicObject>>(accountFrozens.stream().collect(Collectors.groupingBy(b -> DateUtils.truncateDate((Date)b.getDate("applydate")))));
        for (Map.Entry entry : applyDateMap.entrySet()) {
            List frozenList = (List)entry.getValue();
            frozenList.sort(Comparator.comparing(a -> a.getDate("createtime")));
            map.put((Date)entry.getKey(), InnerAcctFrozenHelper.getTotalFrozenAmount((DynamicObject)frozenList.get(frozenList.size() - 1)));
        }
        return map;
    }
}

