/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.ifm.expoint.ExtPlanCallResult;
import kd.sdk.tmc.ifm.expoint.IInstBalanceCalcSecondDev;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.bean.IntObjectCalcRequest;
import kd.tmc.ifm.bean.IntObjectInfo;
import kd.tmc.ifm.enums.CategoryEnum;
import kd.tmc.ifm.enums.IntSourceEnum;
import kd.tmc.ifm.helper.BankAccountBalanceHelper;
import kd.tmc.ifm.helper.BankAccountHelper;
import kd.tmc.ifm.helper.GLBalanceHelper;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;
import kd.tmc.ifm.helper.IntObjectCalcHelper;

public class InterestCalcHelper {
    private static final String SERVICE = "intCalcService";
    private static final Log logger = LogFactory.getLog(InterestCalcHelper.class);
    private static final String INTOBJECT_PROPS = "intobject,lastintdate,interesttype,referrate,intinneracct,iscaloverint,oversign,overpoints,accountorg,startintdate,intfreeamt,initaccum,intthreshold,interestway,currency,lastpreintdate,depositint_entry.depositamtbegin,depositint_entry.depositamtend,depositint_entry.intfloatpoint,depositint_entry.intfloatway,overint_entry.depositbegin,overint_entry.depositend,overint_entry.overintfloatpoint,overint_entry.overfloatway";

    public static IntBillInfo callInt(Long loanBillid, Date beginDate, Date endDate) {
        return (IntBillInfo)DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)TmcAppEnum.CFM.getValue(), (String)SERVICE, (String)"callLoanInt", (Object[])new Object[]{loanBillid, beginDate, endDate});
    }

    public static IntBillInfo callPreInt(Long loanBillid, Date beginDate, Date endDate) {
        return (IntBillInfo)DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)TmcAppEnum.CFM.getValue(), (String)SERVICE, (String)"callLoanInt", (Object[])new Object[]{loanBillid, beginDate, endDate});
    }

    public static IntBillInfo callInt(Long loanBillid, Date endDate, BigDecimal repayAmt) {
        return (IntBillInfo)DispatchServiceHelper.invokeBizService((String)TmcAppEnum.TMC.getValue(), (String)TmcAppEnum.CFM.getValue(), (String)SERVICE, (String)"calRepayInt", (Object[])new Object[]{loanBillid, endDate, repayAmt});
    }

    public static IntBillInfo callInt(DynamicObject innerAcct, DynamicObject currency, Date beginDate, Date endDate, boolean isCalOverInt, boolean isPreCallInt) {
        DynamicObject intObject = InterestCalcHelper.queryIntObject(innerAcct);
        if (null == intObject) {
            return null;
        }
        List<PlanCallResult> balanceList = InterestCalcHelper.getBalanceList(innerAcct, currency, beginDate, endDate);
        currency = currency != null ? currency : intObject.getDynamicObject("currency");
        IntObjectCalcRequest calcRequest = new IntObjectCalcRequest();
        calcRequest.setCurrencyId((Long)currency.getPkValue()).initBalanceList(balanceList).setBeginDate(beginDate).setEndDate(endDate).setCalOverInt(intObject.getBoolean("iscaloverint")).setPreCallInt(isPreCallInt).setIntObjectInfo(IntObjectInfo.initInitObjectInfo(intObject));
        return IntObjectCalcHelper.calcIntObjectInterest(calcRequest);
    }

    public static IntBillInfo callAccountInt(DynamicObject intObject, Date endDate, boolean isCalOverInt, boolean isPreCallInt) {
        Date beginDate = DateUtils.getNextDay((Date)intObject.getDate("lastintdate"), (int)1);
        List<PlanCallResult> balanceList = InterestCalcHelper.getBalanceList(intObject, beginDate, endDate);
        DynamicObject currency = intObject.getDynamicObject("currency");
        IntObjectCalcRequest calcRequest = new IntObjectCalcRequest();
        calcRequest.setCurrencyId((Long)currency.getPkValue()).initBalanceList(balanceList).setBeginDate(beginDate).setEndDate(endDate).setCalOverInt(isCalOverInt).setPreCallInt(isPreCallInt).setIntObjectInfo(IntObjectInfo.initInitObjectInfo(intObject));
        return IntObjectCalcHelper.calcIntObjectInterest(calcRequest);
    }

    public static IntBillInfo callBankInt(DynamicObject intObject, Date beginDate, Date endDate, boolean isCalOverInt, boolean isPreCallInt, String source) {
        DynamicObject currency = intObject.getDynamicObject("currency");
        List<PlanCallResult> balanceList = InterestCalcHelper.getBalanceByBank(intObject, beginDate, endDate, source);
        IntObjectCalcRequest calcRequest = new IntObjectCalcRequest();
        calcRequest.setCurrencyId((Long)currency.getPkValue()).initBalanceList(balanceList).setBeginDate(beginDate).setEndDate(endDate).setCalOverInt(isCalOverInt).setPreCallInt(isPreCallInt).setIntObjectInfo(IntObjectInfo.initInitObjectInfo(intObject, endDate));
        return IntObjectCalcHelper.calcIntObjectInterest(calcRequest);
    }

    public static IntBillInfo callInt(DynamicObject innerAcct, DynamicObject currency, Date beginDate, Date endDate, boolean isCalOverInt) {
        return InterestCalcHelper.callInt(innerAcct, currency, beginDate, endDate, isCalOverInt, false);
    }

    public static Set<RateInfo> queryRateList(DynamicObject product) {
        return IntObjectCalcHelper.querySubsectionRateList(product);
    }

    public static DynamicObject queryProduct(DynamicObject currency) {
        return TmcDataServiceHelper.loadSingle((String)"ifm_product", (String)"currency,price_num,e_effectivedate,hist_entry,price,e_price,effectivedate,interestratedays", (QFilter[])new QFilter[]{new QFilter("currency", "=", currency.getPkValue()), new QFilter("category", "=", (Object)CategoryEnum.HQCK.getValue()), new QFilter("enable", "=", (Object)Boolean.TRUE)});
    }

    private static List<PlanCallResult> getBalanceList(DynamicObject innerAcct, DynamicObject currency, Date beginDate, Date endDate) {
        DynamicObjectCollection balances = QueryServiceHelper.query((String)"ifm_accountbalance", (String)"amount,bizdate", (QFilter[])new QFilter[]{new QFilter("accountbank.id", "=", innerAcct.get("id")), new QFilter("currency", "=", currency.getPkValue()), new QFilter("bizdate", ">=", (Object)DateUtils.truncateDate((Date)beginDate)), new QFilter("bizdate", "<=", (Object)DateUtils.truncateDate((Date)endDate))});
        HashMap<Date, Integer> bizDateMap = new HashMap<Date, Integer>(balances.size());
        ArrayList<PlanCallResult> balanceList = new ArrayList<PlanCallResult>(8);
        for (DynamicObject balance : balances) {
            PlanCallResult plan = new PlanCallResult();
            Date bizdate = balance.getDate("bizdate");
            plan.setBizDate(bizdate);
            plan.setPrinciple(balance.getBigDecimal("amount"));
            plan.setPayInt(false);
            balanceList.add(plan);
            bizDateMap.put(bizdate, 1);
        }
        if (!bizDateMap.containsKey(beginDate)) {
            BigDecimal balance = InnerAccountBalanceHelper.getBalance(innerAcct.getLong("id"), currency.getLong("id"), beginDate);
            PlanCallResult plan = new PlanCallResult();
            plan.setBizDate(beginDate);
            plan.setPrinciple(balance);
            plan.setPayInt(false);
            balanceList.add(plan);
        }
        InterestCalcHelper.instBalanceCalcSecondDev(balanceList, innerAcct, currency, beginDate, endDate);
        return balanceList;
    }

    private static List<PlanCallResult> getBalanceList(DynamicObject intObject, Date beginDate, Date endDate) {
        Map<Date, BigDecimal> balance;
        DynamicObject selectFlex;
        ArrayList<PlanCallResult> balanceList = new ArrayList<PlanCallResult>(8);
        Long orgId = intObject.getDynamicObject("accountorg").getLong("id");
        Long currencyId = intObject.getDynamicObject("currency").getLong("id");
        Long accountId = intObject.getDynamicObject("intobject").getLong("id");
        String itemType = null;
        Long flexId = null;
        DynamicObjectCollection entrys = intObject.getDynamicObjectCollection("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) && (selectFlex = (DynamicObject)entrys.stream().filter(v -> v.getBoolean("select")).findFirst().orElse(null)) != null) {
            itemType = selectFlex.getDynamicObject("asstactitem").getDynamicObject("valuesource").getString("number");
            flexId = selectFlex.getLong("detailid");
        }
        if (EmptyUtil.isEmpty(balance = GLBalanceHelper.getBalance(orgId, currencyId, accountId, itemType, flexId, beginDate, endDate))) {
            return balanceList;
        }
        for (Map.Entry<Date, BigDecimal> entry : balance.entrySet()) {
            PlanCallResult plan = new PlanCallResult();
            plan.setBizDate(entry.getKey());
            plan.setPrinciple(entry.getValue());
            plan.setPayInt(false);
            balanceList.add(plan);
        }
        return balanceList;
    }

    private static List<PlanCallResult> getBalanceByBank(DynamicObject intObject, Date beginDate, Date endDate, String source) {
        List<DynamicObject> balances;
        QFilter[] filters;
        String fields;
        DynamicObjectCollection accountbalancesBank;
        QFilter qFilter;
        Long accountIdsBank;
        DynamicObject bankAccounts;
        ArrayList<PlanCallResult> balanceList = new ArrayList<PlanCallResult>(8);
        Long orgId = intObject.getDynamicObject("org").getLong("id");
        Long bankAccountId = intObject.getDynamicObject("intobject").getLong("id");
        Object currencyId = intObject.getDynamicObject("currency").getPkValue();
        if (IntSourceEnum.BANKJOURNAL.getValue().equals(source)) {
            bankAccounts = BankAccountHelper.getBankAccounts(bankAccountId);
            accountIdsBank = bankAccounts.getLong("id");
            qFilter = new QFilter("bookdate", "<", (Object)DateUtils.truncateDate((Date)beginDate));
            qFilter.and(new QFilter("bankaccount", "=", (Object)accountIdsBank));
            qFilter.and(new QFilter("currency", "=", currencyId));
            accountbalancesBank = QueryServiceHelper.query((String)"cas_accountbalance", (String)"bookdate", (QFilter[])qFilter.toArray(), (String)"bookdate desc", (int)1);
            if (accountbalancesBank != null && accountbalancesBank.size() == 1) {
                beginDate = ((DynamicObject)accountbalancesBank.get(0)).getDate("bookdate");
            }
            fields = "org.id,bankaccount,currency,amount,bookdate";
            filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("currency", "=", currencyId), new QFilter("bookdate", ">=", (Object)DateUtils.truncateDate((Date)beginDate)), new QFilter("bookdate", "<=", (Object)DateUtils.truncateDate((Date)endDate))};
            balances = BankAccountBalanceHelper.getRecentAccountBalancesBank(accountIdsBank, fields, filters);
        } else {
            bankAccounts = BankAccountHelper.getBankAccounts(bankAccountId);
            accountIdsBank = bankAccounts.getLong("id");
            qFilter = new QFilter("bizdate", "<", (Object)DateUtils.truncateDate((Date)beginDate));
            qFilter.and(new QFilter("accountbank", "=", (Object)accountIdsBank));
            qFilter.and(new QFilter("currency", "=", currencyId));
            accountbalancesBank = QueryServiceHelper.query((String)"bei_bankbalance", (String)"bizdate", (QFilter[])qFilter.toArray(), (String)"bizdate desc", (int)1);
            if (accountbalancesBank != null && accountbalancesBank.size() == 1) {
                beginDate = ((DynamicObject)accountbalancesBank.get(0)).getDate("bizdate");
            }
            fields = "company.id,accountbank,currency,amount,bizdate";
            filters = new QFilter[]{new QFilter("company", "=", (Object)orgId), new QFilter("currency", "=", currencyId), new QFilter("bizdate", ">=", (Object)DateUtils.truncateDate((Date)beginDate)), new QFilter("bizdate", "<=", (Object)DateUtils.truncateDate((Date)endDate))};
            balances = BankAccountBalanceHelper.getRecentAccountBalancesNoBank(accountIdsBank, fields, filters);
        }
        for (DynamicObject balance : balances) {
            PlanCallResult plan = new PlanCallResult();
            Date bizdate = IntSourceEnum.BANKJOURNAL.getValue().equals(source) ? balance.getDate("bookdate") : balance.getDate("bizdate");
            plan.setBizDate(bizdate);
            plan.setPrinciple(balance.getBigDecimal("amount"));
            plan.setPayInt(false);
            balanceList.add(plan);
        }
        return balanceList;
    }

    public static DynamicObject queryIntObject(DynamicObject bankAcct) {
        if (EmptyUtil.isEmpty((DynamicObject)bankAcct)) {
            return null;
        }
        Object[] intObjects = TmcDataServiceHelper.load((String)"ifm_intobject", (String)INTOBJECT_PROPS, (QFilter[])new QFilter[]{new QFilter("intobject.id", "=", bankAcct.getPkValue()), new QFilter("status", "=", (Object)"C")});
        return EmptyUtil.isEmpty((Object[])intObjects) ? null : intObjects[0];
    }

    public static Date getLoanBillIntStartDate(DynamicObject loanBill) {
        Date startDate = loanBill.getDate("endpreinstdate");
        Date endInstDate = loanBill.getDate("endinstdate");
        return InterestCalcHelper.getIntStartDate(startDate, endInstDate, loanBill.getDate("startintdate"));
    }

    public static Date getIntObjectStartPreIntDate(DynamicObject intObject) {
        Date lastPreIntDate = intObject.getDate("lastpreintdate");
        Date lastIntDate = intObject.getDate("lastintdate");
        Date startPreIntDate = DateUtils.getNextDay((Date)lastIntDate, (int)1);
        if (EmptyUtil.isNoEmpty((Object)lastPreIntDate)) {
            startPreIntDate = DateUtils.getNextDay((Date)lastPreIntDate, (int)1);
        }
        return startPreIntDate;
    }

    public static Date getAcctIntStartDate(DynamicObject bankAcct) {
        Object innerAcctId = bankAcct.getDynamicObject("inneracct").getPkValue();
        DynamicObject innerAcct = TmcDataServiceHelper.loadSingle((Object)innerAcctId, (String)"ifm_inneracct");
        Date startDate = innerAcct.getDate("endpreinstdate");
        DynamicObject intObject = InterestCalcHelper.queryIntObject(bankAcct);
        Date interestDate = null == intObject ? null : intObject.getDate("lastintdate");
        return InterestCalcHelper.getIntStartDate(startDate, interestDate, innerAcct.getDate("intereststartdate"));
    }

    public static Date getBankIntStartDate(DynamicObject bankAcct) {
        Object innerAcctId = bankAcct.getDynamicObject("inneracct").getPkValue();
        DynamicObject innerAcct = TmcDataServiceHelper.loadSingle((Object)innerAcctId, (String)"ifm_bankacctintobject");
        Date startDate = innerAcct.getDate("endpreinstdate");
        DynamicObject intObject = InterestCalcHelper.queryIntObject(bankAcct);
        Date interestDate = null == intObject ? null : intObject.getDate("lastintdate");
        return InterestCalcHelper.getIntStartDate(startDate, interestDate, innerAcct.getDate("intereststartdate"));
    }

    private static Date getIntStartDate(Date startDate, Date interestDate, Date interestStartDate) {
        if (EmptyUtil.isNoEmpty((Object)startDate)) {
            if (EmptyUtil.isEmpty((Object)interestDate)) {
                return DateUtils.getNextDay((Date)startDate, (int)1);
            }
            return startDate.before(interestDate) ? DateUtils.getNextDay((Date)interestDate, (int)1) : DateUtils.getNextDay((Date)startDate, (int)1);
        }
        startDate = EmptyUtil.isNoEmpty((Object)interestDate) ? DateUtils.getNextDay((Date)interestDate, (int)1) : interestStartDate;
        return startDate;
    }

    private static void instBalanceCalcSecondDev(List<PlanCallResult> balanceList, DynamicObject innerAcct, DynamicObject currency, Date beginDate, Date endDate) {
        PluginProxy pluginProxy = PluginProxy.create(IInstBalanceCalcSecondDev.class, (String)"kd.sdk.tmc.ifm.expoint.IInstBalanceCalcSecondDev.getExtInstBalance");
        pluginProxy.callReplace(proxy -> {
            List extInstBalance = proxy.getExtInstBalance(innerAcct, currency, beginDate, endDate);
            if (EmptyUtil.isNoEmpty((Object)extInstBalance)) {
                balanceList.clear();
                for (ExtPlanCallResult extPlanCallResult : extInstBalance) {
                    PlanCallResult plan = new PlanCallResult();
                    plan.setBizDate(extPlanCallResult.getBizDate());
                    plan.setPrinciple(extPlanCallResult.getPrinciple());
                    plan.setPayInt(false);
                    balanceList.add(plan);
                }
                logger.info("\u6d3b\u671f\u8ba1\u606f\u5229\u606f\u8ba1\u7b97\u4e8c\u5f00\u5c01\u88c5\u4f59\u989d\u4fe1\u606f: {}", (Object)SerializationUtils.toJsonString((Object)extInstBalance));
            }
            return new Object();
        });
    }
}

