/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.ifm.enums.DrawTypeEnum;
import kd.tmc.ifm.enums.LoanContractStatusEnum;

public class LoanBillHelper {
    public static String validateIfAllowPushLoanBill(Long contractId) {
        String errorMsg = "";
        QFilter loanQF = new QFilter("sourcebillid", "=", (Object)contractId);
        loanQF.and(new QFilter("drawtype", "=", (Object)DrawTypeEnum.DRAWING.getValue()).or("drawtype", "=", (Object)"bitback"));
        QFilter contractQF = new QFilter("id", "=", (Object)contractId);
        DynamicObject contractDO = TmcDataServiceHelper.loadSingle((String)"ifm_loancontractbill", (String)"id, billstatus, contractstatus, notdrawamount", (QFilter[])contractQF.toArray());
        String contractStatus = contractDO.getString("contractstatus");
        if (!LoanContractStatusEnum.EXECUTING.getValue().equals(contractStatus) && !LoanContractStatusEnum.REGISTERED.getValue().equals(contractStatus)) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5408\u540c\u72b6\u6001\u662f\u5df2\u767b\u8bb0\u6216\u6267\u884c\u4e2d\u7684\u5408\u540c\u624d\u5141\u8bb8\u653e\u6b3e", (String)"LoanBillHelper_2", (String)"tmc-ifm-common", (Object[])new Object[0]);
            return errorMsg;
        }
        if (BigDecimal.ZERO.compareTo(contractDO.getBigDecimal("notdrawamount")) >= 0) {
            errorMsg = ResManager.loadKDString((String)"\u8be5\u5408\u540c\u501f\u6b3e\u5df2\u5168\u90e8\u53d1\u653e\uff0c\u4e0d\u80fd\u518d\u653e\u6b3e", (String)"LoanBillHelper_3", (String)"tmc-ifm-common", (Object[])new Object[0]);
            return errorMsg;
        }
        return errorMsg;
    }
}

