/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.DataSourceEnum;
import kd.tmc.ifm.enums.IntObjectTypeEnum;
import kd.tmc.ifm.enums.PreIntOperateTypeEnum;
import kd.tmc.ifm.enums.PreIntWayEnum;
import kd.tmc.ifm.enums.SettleTypeEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;

public class SettleIntWriteOffHelper {
    private static final Log logger = LogFactory.getLog(SettleIntWriteOffHelper.class);
    private static final String SELECTOR = "billno,intobject,nowriteoffamt,begindate,currency,settlecenter,interestday,actualinstamt,biztype,writeoffstatus,writeoffamt";

    public static void autoWriteOff(DynamicObject currentIntBill) {
        DynamicObject settleCenter = currentIntBill.getDynamicObject("settlecenter");
        if (SettleIntWriteOffHelper.isAutoWriteOffParam(settleCenter)) {
            Object[] preIntBills = SettleIntWriteOffHelper.getPreIntBills(new DynamicObject[]{currentIntBill}, null);
            if (EmptyUtil.isEmpty((Object[])preIntBills)) {
                return;
            }
            List preIntBillIds = Arrays.stream(preIntBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            logger.info("autoWriteOff preIntBillIds:{}", (Object)org.apache.commons.lang3.StringUtils.join(preIntBillIds, (String)","));
            BigDecimal writeOffAmt = currentIntBill.getBigDecimal("actualinstamt");
            OperateOption operate = OperateOption.create();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("writeoffamt", writeOffAmt);
            dataMap.put("intBillIds", JSON.toJSONString(preIntBillIds));
            operate.setVariableValue("param_writeoff", JSON.toJSONString(dataMap));
            TmcOperateServiceHelper.execOperate((String)"writeoff", (String)"ifm_currentintbill", (Object[])new Object[]{currentIntBill.getPkValue()}, (OperateOption)operate);
        }
    }

    public static void autoUnWriteOff(DynamicObject currentIntBill) {
        DynamicObject settleCenter = currentIntBill.getDynamicObject("settlecenter");
        if (SettleIntWriteOffHelper.isAutoWriteOffParam(settleCenter)) {
            String writeOffStatus = currentIntBill.getString("writeoffstatus");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)WriteOffStatusEnum.WRITEOFF.getValue(), (CharSequence)writeOffStatus)) {
                String entityName = currentIntBill.getDynamicObjectType().getName();
                OperateOption option = OperateOption.create();
                option.setVariableValue("back", "back");
                TmcOperateServiceHelper.execOperate((String)"unwriteoff", (String)entityName, (Object[])new Object[]{currentIntBill.getPkValue()}, (OperateOption)option);
            }
        }
    }

    public static void autoRedWriteOff(DynamicObject preIntBill) {
        DynamicObject settleCenter = preIntBill.getDynamicObject("settlecenter");
        if (SettleIntWriteOffHelper.isAutoRedWriteOffParam(settleCenter)) {
            DynamicObject intObject = preIntBill.getDynamicObject("intobject");
            if (EmptyUtil.isEmpty((DynamicObject)intObject)) {
                logger.info("\u81ea\u52a8\u7ea2\u51b2\u5931\u8d25\uff0c\u8ba1\u606f\u5bf9\u8c61\u4e3a\u7a7a");
                return;
            }
            QFilter filter = new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
            filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            filter.and("intobject", "=", intObject.getPkValue());
            filter.and("id", "!=", preIntBill.getPkValue());
            filter.and("biztype", "=", (Object)CurrentBizTypeEnum.PREINT.getValue());
            Object[] unWriteOffPreIntBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"id", (QFilter[])filter.toArray());
            if (EmptyUtil.isEmpty((Object[])unWriteOffPreIntBills)) {
                logger.info("\u81ea\u52a8\u7ea2\u51b2\u672a\u67e5\u627e\u5230\u672a\u51b2\u9500\u7684\u9884\u63d0\u5355");
                return;
            }
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("autoredwriteoff", "true");
            operate.setVariableValue("redwriteoffbatch", String.valueOf(preIntBill.getPkValue()));
            Object[] ids = Arrays.stream(unWriteOffPreIntBills).map(DataEntityBase::getPkValue).toArray();
            logger.info("autoRedWriteOff preIntBillIds:{}", (Object)org.apache.commons.lang3.StringUtils.join((Object[])ids, (String)","));
            TmcOperateServiceHelper.execOperate((String)"redwriteoff", (String)"ifm_currentintbill", (Object[])ids, (OperateOption)operate);
        }
    }

    public static void autoUnRedWriteOff(DynamicObject preIntBill) {
        DynamicObject settleCenter = preIntBill.getDynamicObject("settlecenter");
        if (SettleIntWriteOffHelper.isAutoRedWriteOffParam(settleCenter)) {
            long pkValue = preIntBill.getLong("id");
            QFilter filter = new QFilter("batchnoid", "=", (Object)pkValue);
            filter.and(new QFilter("id", "!=", preIntBill.getPkValue()));
            filter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue()));
            filter.and(new QFilter("biztype", "=", (Object)"reversepreint"));
            Object[] autoRedWriteOffBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"billno,id", (QFilter[])filter.toArray(), (String)"begindate desc,billno desc");
            if (EmptyUtil.isEmpty((Object[])autoRedWriteOffBills)) {
                logger.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u81ea\u52a8\u53cd\u7ea2\u5b57\u51b2\u9500\u7684\u5355\u636e");
                return;
            }
            Object[] ids = Arrays.stream(autoRedWriteOffBills).map(DataEntityBase::getPkValue).toArray();
            logger.info("autoUnRedWriteOff preIntBillIds:{}", (Object)org.apache.commons.lang3.StringUtils.join((Object[])ids, (String)","));
            TmcOperateServiceHelper.execOperate((String)"unredwriteoff", (String)"ifm_currentintbill", (Object[])ids, (OperateOption)OperateOption.create());
        }
    }

    private static boolean isAutoWriteOffParam(DynamicObject settleCenter) {
        DynamicObject setCenterSetting = SettleIntWriteOffHelper.getSetCenterSetting(settleCenter);
        return null != setCenterSetting && setCenterSetting.getBoolean("autowriteoff");
    }

    private static boolean isAutoRedWriteOffParam(DynamicObject settleCenter) {
        DynamicObject setCenterSetting = SettleIntWriteOffHelper.getSetCenterSetting(settleCenter);
        return null != setCenterSetting && setCenterSetting.getBoolean("autoredwriteoff");
    }

    private static boolean isRedWriteOffParam(DynamicObject settleCenter) {
        return PreIntWayEnum.isRedWriteOffParam(SettleIntWriteOffHelper.getPreIntWay(settleCenter));
    }

    public static void writeBackIntObjectPreIntDay(DynamicObject intBill) {
        DynamicObject intObject = intBill.getDynamicObject("intobject");
        if (EmptyUtil.isNoEmpty((DynamicObject)intObject)) {
            DynamicObject settleCenter = intBill.getDynamicObject("settlecenter");
            intObject = TmcDataServiceHelper.loadSingle((Object)intObject.getPkValue(), (String)"ifm_intobject", (String)"lastpreintdate");
            Date lastPreIntDay = SettleIntWriteOffHelper.getPreIntDay(intObject, settleCenter, intBill.getDate("begindate"));
            intObject.set("lastpreintdate", (Object)lastPreIntDay);
            SaveServiceHelper.update((DynamicObject)intObject);
        }
    }

    public static void batchDeleteIntBill(DynamicObject batchIntBill) {
        DynamicObjectCollection entry = batchIntBill.getDynamicObjectCollection("entry");
        OperateOption operateOption = OperateOption.create();
        ArrayList intDetails = new ArrayList(entry.size());
        intDetails.addAll(entry.stream().map(v -> v.get("intbillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList()));
        if (EmptyUtil.isNoEmpty(intDetails)) {
            Object[] intBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", intDetails)});
            if (EmptyUtil.isEmpty((Object[])intBills)) {
                return;
            }
            Object[] auditBillIds = Arrays.stream(intBills).filter(v -> org.apache.commons.lang3.StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())).map(DataEntityBase::getPkValue).toArray();
            Object[] submitBillIds = Arrays.stream(intBills).filter(v -> org.apache.commons.lang3.StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.SUBMIT.getValue())).map(DataEntityBase::getPkValue).toArray();
            if (EmptyUtil.isNoEmpty((Object[])auditBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"ifm_currentintbill", (Object[])auditBillIds, (OperateOption)operateOption);
            }
            if (EmptyUtil.isNoEmpty((Object[])submitBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_currentintbill", (Object[])submitBillIds, (OperateOption)operateOption);
            }
            Object[] intBillIds = Arrays.stream(intBills).map(DataEntityBase::getPkValue).toArray();
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_currentintbill", (Object[])intBillIds, (OperateOption)operateOption);
        }
        for (DynamicObject row : entry) {
            row.set("intbillid", (Object)0);
            row.set("intdetailnum", (Object)"");
            row.set("status", (Object)"");
        }
    }

    public static void writeBackIntObjectIntDay(DynamicObject intBill) {
        DynamicObject intObject = intBill.getDynamicObject("intobject");
        if (EmptyUtil.isNoEmpty((DynamicObject)intObject)) {
            Date lastIntDate = SettleIntWriteOffHelper.getLastIntDay(intObject = TmcDataServiceHelper.loadSingle((Object)intObject.getPkValue(), (String)"ifm_intobject", (String)"lastintdate"), CurrentBizTypeEnum.CURRENTINT.getValue());
            if (EmptyUtil.isEmpty((Object)lastIntDate)) {
                lastIntDate = DateUtils.getLastDay((Date)intBill.getDate("begindate"), (int)1);
            }
            intObject.set("lastintdate", (Object)lastIntDate);
            SaveServiceHelper.update((DynamicObject)intObject);
            DynamicObject settleCenter = intBill.getDynamicObject("settlecenter");
            if (SettleIntWriteOffHelper.isRedWriteOffParam(settleCenter)) {
                SettleIntWriteOffHelper.writeBackIntObjectPreIntDay(intBill);
            }
        }
    }

    public static DynamicObject getLastIntBill(DynamicObject intBill, String bizType) {
        DynamicObject intObject = intBill.getDynamicObject("intobject");
        if (null == intObject || EmptyUtil.isEmpty((String)bizType)) {
            return null;
        }
        DynamicObject[] currentIntBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("intobject", "=", intObject.getPkValue()), new QFilter("biztype", "=", (Object)bizType), new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue())}, (String)"begindate desc");
        return currentIntBills.length == 0 ? null : currentIntBills[0];
    }

    private static Date getPreIntDay(DynamicObject intObject, DynamicObject settleCenter, Date intDate) {
        Date lastIntDay;
        Date lastPreIntDay = SettleIntWriteOffHelper.isAutoRedWriteOffParam(settleCenter) ? null : SettleIntWriteOffHelper.getLastIntDay(intObject, CurrentBizTypeEnum.PREINT.getValue());
        String preIntWay = SettleIntWriteOffHelper.getPreIntWay(settleCenter);
        Date date = lastIntDay = org.apache.commons.lang3.StringUtils.equals((CharSequence)PreIntWayEnum.CEBTF.getValue(), (CharSequence)preIntWay) ? SettleIntWriteOffHelper.getLastIntDay(intObject, CurrentBizTypeEnum.CURRENTINT.getValue()) : null;
        if (null == lastPreIntDay && null == lastIntDay) {
            return DateUtils.getLastDay((Date)intDate, (int)1);
        }
        if (null == lastIntDay) {
            return lastPreIntDay;
        }
        if (null == lastPreIntDay) {
            return lastIntDay;
        }
        return lastPreIntDay.compareTo(lastIntDay) < 0 ? lastIntDay : lastPreIntDay;
    }

    private static Date getLastIntDay(DynamicObject intObject, String bizType) {
        QFilter qFilter = new QFilter("intobject", "=", intObject.getPkValue());
        qFilter.and("biztype", "=", (Object)bizType);
        qFilter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Object[] preIntBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"enddate", (QFilter[])new QFilter[]{qFilter}, (String)"enddate desc");
        return EmptyUtil.isEmpty((Object[])preIntBills) ? null : preIntBills[0].getDate("enddate");
    }

    public static String getPreIntWay(DynamicObject settleCenter) {
        DynamicObject setCenterSetting = SettleIntWriteOffHelper.getSetCenterSetting(settleCenter);
        return null == setCenterSetting ? "" : setCenterSetting.getString("preintway");
    }

    public static DynamicObject[] getPreIntBills(DynamicObject[] interestBills, List preIntBillIds) {
        if (EmptyUtil.isEmpty((Object[])interestBills)) {
            return new DynamicObject[0];
        }
        List intObjectIds = Arrays.stream(interestBills).map(r -> r.getDynamicObject("intobject")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("intobject", "in", intObjectIds);
        filter.and("writeoffstatus", "not in", Arrays.asList("writeoff", "red_writeoff"));
        filter.and("biztype", "=", (Object)CurrentBizTypeEnum.PREINT.getValue());
        filter.and("nowriteoffamt", "!=", (Object)0L);
        if (EmptyUtil.isNoEmpty((Object)preIntBillIds)) {
            filter.and(new QFilter("id", "in", (Object)preIntBillIds));
        }
        return TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)SELECTOR, (QFilter[])new QFilter[]{filter}, (String)"interestday asc");
    }

    public static DynamicObject[] getWriteOffPreIntBills(DynamicObject[] interestBills) {
        if (EmptyUtil.isEmpty((Object[])interestBills)) {
            return new DynamicObject[0];
        }
        DynamicObject[] writeOffRelations = SettleIntWriteOffHelper.getWriteOffRelations(interestBills);
        Object[] ids = Arrays.stream(writeOffRelations).map(v -> v.get("preinstbillid")).toArray();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        return TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)SELECTOR, (QFilter[])new QFilter[]{filter}, (String)"interestday asc");
    }

    public static void writeOffPreInts(DynamicObject[] preInstBills, BigDecimal writeOffAmt, long batchNoId) {
        ArrayList<DynamicObject> relationList = new ArrayList<DynamicObject>();
        List preIntBills = Arrays.stream(preInstBills).sorted(Comparator.comparing(o -> o.getDate("begindate"))).collect(Collectors.toList());
        String billNos = Arrays.stream(preInstBills).map(v -> v.getString("billno")).collect(Collectors.joining(","));
        logger.info("preInt writeOff info[billNos:{},writeOffAmt:{},batchNoId:{}]", new Object[]{billNos, writeOffAmt, batchNoId});
        boolean isNagetive = writeOffAmt.compareTo(BigDecimal.ZERO) < 0;
        for (DynamicObject preIntBill : preIntBills) {
            BigDecimal leftNoWriteOffAmt;
            if (isNagetive) {
                SettleIntWriteOffHelper.updatePreIntBill(preIntBill, writeOffAmt, true);
                DynamicObject relation = SettleIntWriteOffHelper.genWriteOffRelation(preIntBill, batchNoId, writeOffAmt);
                relationList.add(relation);
                break;
            }
            BigDecimal noWriteOffAmt = preIntBill.getBigDecimal("nowriteoffamt");
            boolean isPreInt = PreIntOperateTypeEnum.PREINT.getValue().equals(preIntBill.getString("biztype"));
            BigDecimal bigDecimal = leftNoWriteOffAmt = isPreInt ? noWriteOffAmt : noWriteOffAmt.negate();
            if (writeOffAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal beforeWriteOffAmt = writeOffAmt;
            BigDecimal actWriteOffAmt = (writeOffAmt = writeOffAmt.subtract(leftNoWriteOffAmt)).compareTo(BigDecimal.ZERO) >= 0 ? leftNoWriteOffAmt : beforeWriteOffAmt;
            SettleIntWriteOffHelper.updatePreIntBill(preIntBill, actWriteOffAmt, true);
            DynamicObject relation = SettleIntWriteOffHelper.genWriteOffRelation(preIntBill, batchNoId, actWriteOffAmt);
            relationList.add(relation);
        }
        if (EmptyUtil.isNoEmpty(relationList)) {
            SaveServiceHelper.save((DynamicObject[])relationList.toArray(new DynamicObject[0]));
        }
    }

    public static void updatePreIntBill(DynamicObject preIntBill, BigDecimal actWriteOffAmt, boolean isWriteOff) {
        if (isWriteOff) {
            preIntBill.set("writeoffamt", (Object)preIntBill.getBigDecimal("writeoffamt").add(actWriteOffAmt));
        } else {
            preIntBill.set("writeoffamt", (Object)preIntBill.getBigDecimal("writeoffamt").subtract(actWriteOffAmt));
        }
        BigDecimal actPreInstAmt = preIntBill.getBigDecimal("actualinstamt");
        BigDecimal noWriteOffAmt = actPreInstAmt.subtract(preIntBill.getBigDecimal("writeoffamt"));
        preIntBill.set("nowriteoffamt", (Object)noWriteOffAmt);
        if (noWriteOffAmt.compareTo(BigDecimal.ZERO) <= 0) {
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITEOFF.getValue());
        } else if (noWriteOffAmt.compareTo(actPreInstAmt) == 0) {
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        } else {
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.PART_WRITEOFF.getValue());
        }
    }

    public static DynamicObject[] getWriteOffRelations(DynamicObject[] interestBills) {
        if (EmptyUtil.isEmpty((Object[])interestBills)) {
            return new DynamicObject[0];
        }
        Object[] batchNoIds = Arrays.stream(interestBills).map(v -> v.get("batchnoid")).toArray();
        QFilter filter = new QFilter("batchnoid", "in", (Object)batchNoIds);
        return TmcDataServiceHelper.load((String)"ifm_instwriteoff_relation", (String)"batchnoid,preinstbillid,currency,amount", (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject genWriteOffRelation(DynamicObject preIntBill, long batchNoId, BigDecimal writeOffAmt) {
        DynamicObject relation = TmcDataServiceHelper.newDynamicObject((String)"ifm_instwriteoff_relation");
        relation.set("batchnoid", (Object)batchNoId);
        relation.set("preinstbillid", (Object)preIntBill.getLong("id"));
        relation.set("currency", (Object)preIntBill.getDynamicObject("currency"));
        relation.set("amount", (Object)writeOffAmt);
        return relation;
    }

    public static BigDecimal getTotalPreIntBillAmt(DynamicObject[] preIntBills) {
        BigDecimal noWriteOffAmt = Constants.ZERO;
        for (DynamicObject preIntBill : preIntBills) {
            noWriteOffAmt = PreIntOperateTypeEnum.REVERSEINT.getValue().equals(preIntBill.getString("biztype")) ? noWriteOffAmt.subtract(preIntBill.getBigDecimal("nowriteoffamt")) : noWriteOffAmt.add(preIntBill.getBigDecimal("nowriteoffamt"));
        }
        return noWriteOffAmt;
    }

    private static DynamicObject getSetCenterSetting(DynamicObject settleCenter) {
        if (EmptyUtil.isEmpty((DynamicObject)settleCenter)) {
            return null;
        }
        return TmcDataServiceHelper.loadSingleFromCache((String)"ifm_settcentersetting", (QFilter[])new QFilter[]{new QFilter("settlecenter", "=", settleCenter.getPkValue())});
    }

    public static void doPush(DynamicObject batchBill) {
        DynamicObject settleCenter = batchBill.getDynamicObject("settlecenter");
        String batchNo = batchBill.getString("billno");
        Date bizDate = batchBill.getDate("bizdate");
        String intSource = batchBill.getString("intsource");
        Long creator = RequestContext.get().getCurrUserId();
        String entityName = batchBill.getDynamicObjectType().getName();
        String bizType = org.apache.commons.lang3.StringUtils.equals((CharSequence)"ifm_intbill_batch_pre", (CharSequence)entityName) ? CurrentBizTypeEnum.PREINT.getValue() : CurrentBizTypeEnum.CURRENTINT.getValue();
        DynamicObjectCollection entry = batchBill.getDynamicObjectCollection("entry");
        ArrayList intBillIds = new ArrayList(entry.size());
        List intobjectIds = entry.stream().map(v -> v.getDynamicObject("intobject").getPkValue().toString()).collect(Collectors.toList());
        Map LimitMap = MutexServiceHelper.batchRequest(intobjectIds, (String)"ifm_intobject", (String)"submit");
        List lockIds = LimitMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        try {
            String lockErrorBillNos = entry.stream().filter(b -> Boolean.FALSE.equals(LimitMap.get(b.getDynamicObject("intobject").getPkValue().toString()))).map(b -> b.getDynamicObject("intobject").getString("name")).collect(Collectors.joining(","));
            if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u501f\u6b3e\u7ed3\u606f(\u9884\u63d0)\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"SettleIntWriteOffHelper_3", (String)"tmc-ifm-common", (Object[])new Object[0]), lockErrorBillNos));
            }
            for (DynamicObject row : entry) {
                DynamicObject intObject = row.getDynamicObject("intobject");
                if (null == intObject) continue;
                DynamicObject innerAcct = row.getDynamicObject("inneracct");
                DynamicObject currency = row.getDynamicObject("currency");
                DynamicObject currentIntBill = TmcDataServiceHelper.newDynamicObject((String)"ifm_currentintbill");
                currentIntBill.set("interestday", (Object)bizDate);
                currentIntBill.set("begindate", (Object)row.getDate("startdate"));
                currentIntBill.set("enddate", (Object)row.getDate("enddate"));
                currentIntBill.set("inneracct", (Object)innerAcct);
                currentIntBill.set("currency", (Object)currency);
                currentIntBill.set("intcomment", (Object)row.getString("intcomment"));
                currentIntBill.set("datasource", (Object)DataSourceEnum.HAND.getValue());
                currentIntBill.set("batchno", (Object)batchNo);
                currentIntBill.set("settlecenter", (Object)settleCenter);
                currentIntBill.set("biztype", (Object)bizType);
                currentIntBill.set("intsource", (Object)intSource);
                currentIntBill.set("intobject", (Object)intObject);
                currentIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
                IntBillInfo intBillInfo = (IntBillInfo)JSON.parseObject((String)row.getString("intdetail_tag"), IntBillInfo.class);
                currentIntBill.set("actualinstamt", (Object)row.getBigDecimal("actualinstamt"));
                SettleIntWriteOffHelper.fillIntAmount(currentIntBill, intBillInfo);
                String intType = bizType.equals(CurrentBizTypeEnum.PREINT.getValue()) ? SettleTypeEnum.JX.getValue() : row.getString("inttype");
                SettleIntWriteOffHelper.fillIntEntry(currentIntBill, intBillInfo, intType);
                currentIntBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                currentIntBill.set("creator", (Object)creator);
                currentIntBill.set("org", (Object)intObject.getLong("org.id"));
                currentIntBill.set("createtime", (Object)DateUtils.getCurrentTime());
                SettleIntWriteOffHelper.setScOrg(currentIntBill, intObject);
                SettleIntWriteOffHelper.doSaveIntBill(row, currentIntBill, intBillIds);
            }
            SettleIntWriteOffHelper.checkFail(intBillIds, batchBill, (List<DynamicObject>)entry);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5b58\u6b3e\u7ed3\u606f(\u9884\u63d0)\u5355\u5931\u8d25:%s", (String)"SettleIntWriteOffHelper_4", (String)"tmc-ifm-common", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (!lockIds.isEmpty()) {
                MutexServiceHelper.batchRelease(lockIds, (String)"ifm_intobject", (String)"submit");
            }
        }
    }

    public static void setScOrg(DynamicObject currentIntBill, DynamicObject intObject) {
        DynamicObject settleCenter;
        if (null == intObject) {
            return;
        }
        intObject = TmcDataServiceHelper.loadSingleFromCache((Object)intObject.getPkValue(), (String)"ifm_intobject");
        String bizType = intObject.getString("biztype");
        long scOrg = 0L;
        if (IntObjectTypeEnum.isExtIntObject(bizType) || IntObjectTypeEnum.isBankIntObject(bizType)) {
            scOrg = intObject.getDynamicObject("accountorg").getLong("id");
        } else if (IntObjectTypeEnum.isInternalIntObject(bizType) && EmptyUtil.isNoEmpty((DynamicObject)(settleCenter = currentIntBill.getDynamicObject("settlecenter")))) {
            scOrg = settleCenter.getDynamicObject("org").getLong("id");
        }
        currentIntBill.set("scorg", (Object)scOrg);
    }

    private static void checkFail(List intBillIds, DynamicObject batchIntBill, List<DynamicObject> batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)batchIntBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{batchIntBill}, (OperateOption)OperateOption.create(), (boolean)true);
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664", (String)"SettleIntWriteOffHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
    }

    private static void doSaveIntBill(DynamicObject batchIntEntry, DynamicObject targetBill, List intBillIds) {
        OperationResult result = null;
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        try {
            result = TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_currentintbill", (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)operateOption);
        }
        catch (Exception e) {
            batchIntEntry.set("status", (Object)"fail");
            batchIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5229\u606f\u5355\u751f\u6210\u5931\u8d25\uff1a%s", (String)"SettleIntWriteOffHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
        }
        if (result == null) {
            return;
        }
        if (result.isSuccess()) {
            Object successPkId = result.getSuccessPkIds().toArray()[0];
            if (EmptyUtil.isNoEmpty((Object)result.getBillNos())) {
                batchIntEntry.set("intbillid", successPkId);
                batchIntEntry.set("intdetailnum", result.getBillNos().values().toArray()[0]);
                batchIntEntry.set("status", (Object)"success");
                intBillIds.add(successPkId);
            }
        }
    }

    public static void auditIntBill(DynamicObject batchBill) {
        DynamicObjectCollection entry = batchBill.getDynamicObjectCollection("entry");
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (DynamicObject batchPreIntEntry : entry) {
            DynamicObject targetBill = TmcDataServiceHelper.loadSingle((Object)batchPreIntEntry.getLong("intbillid"), (String)"ifm_currentintbill");
            if (!EmptyUtil.isNoEmpty((DynamicObject)targetBill)) continue;
            targetBill.set("actualinstamt", (Object)batchPreIntEntry.getBigDecimal("actualinstamt"));
            try {
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_currentintbill", (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)operateOption, (boolean)false);
            }
            catch (Exception e) {
                batchPreIntEntry.set("status", (Object)"fail");
                batchPreIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5229\u606f\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"SettleIntWriteOffHelper_2", (String)"tmc-ifm-common", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
            }
        }
    }

    private static void fillIntEntry(DynamicObject currentIntBill, IntBillInfo intBillInfo, String intType) {
        DynamicObjectCollection intEntry = currentIntBill.getDynamicObjectCollection("entry");
        List intDetails = intBillInfo.getDetails();
        for (IntBillDetailInfo intDetail : intDetails) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            DynamicObject newEntry = intEntry.addNew();
            newEntry.set("inststartdate", (Object)intDetail.getBeginDate());
            newEntry.set("instenddate", (Object)intDetail.getEndDate());
            newEntry.set("instdays", (Object)intDetail.getDays());
            newEntry.set("instprincipal", (Object)intDetail.getPrinciple());
            newEntry.set("intrate", (Object)intDetail.getRate());
            newEntry.set("instctg", (Object)intType);
            newEntry.set("instamount", (Object)intDetail.getAmount());
            newEntry.set("intType", (Object)intDetail.getIntType().getValue());
        }
    }

    private static void fillIntAmount(DynamicObject currentIntBill, IntBillInfo intBillInfo) {
        currentIntBill.set("amount", (Object)intBillInfo.getAmount());
        List details = intBillInfo.getDetails();
        BigDecimal deposit = BigDecimal.ZERO;
        BigDecimal depositIntAmt = BigDecimal.ZERO;
        BigDecimal overDraft = BigDecimal.ZERO;
        BigDecimal overDraftIntAmt = BigDecimal.ZERO;
        for (IntBillDetailInfo detail : details) {
            if (detail.getIntType() == InterTypeEnum.overdue) {
                overDraft = overDraft.add(detail.getPrinciple());
                overDraftIntAmt = overDraftIntAmt.add(detail.getAmount());
                continue;
            }
            deposit = deposit.add(detail.getPrinciple());
            depositIntAmt = depositIntAmt.add(detail.getAmount());
        }
        if (CurrentBizTypeEnum.isPreInt(currentIntBill.getString("biztype"))) {
            currentIntBill.set("nowriteoffamt", (Object)currentIntBill.getBigDecimal("actualinstamt"));
        }
        currentIntBill.set("deposit", (Object)deposit);
        currentIntBill.set("intamount", (Object)depositIntAmt);
        currentIntBill.set("overdraft", (Object)overDraft);
        currentIntBill.set("overintamt", (Object)overDraftIntAmt);
    }

    public static void deleteRecInfo(DynamicObject currentBill) {
        SettleIntWriteOffHelper.deleteRecTransBill(currentBill);
        SettleIntWriteOffHelper.deleteRecBill(currentBill);
    }

    private static void deleteRecTransBill(DynamicObject currentBill) {
        QFilter filter = new QFilter("sourcebillid", "=", currentBill.getPkValue());
        DynamicObjectCollection recTransBills = QueryServiceHelper.query((String)"ifm_rectransbill", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recTransBills)) {
            Object[] ids = recTransBills.stream().map(v -> v.get("id")).toArray();
            logger.info("\u5220\u9664\u6536\u6b3e\u4ea4\u6613\u5904\u7406\uff0cID{}", (Object)org.apache.commons.lang3.StringUtils.join((Object[])ids, (String)","));
            TmcOperateServiceHelper.execOperate((String)"canclepay", (String)"ifm_rectransbill", (Object[])ids, (OperateOption)OperateOption.create());
        }
    }

    private static void deleteRecBill(DynamicObject currentBill) {
        QFilter filter = new QFilter("sourcebillid", "=", currentBill.getPkValue());
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billstatus", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recBills)) {
            DynamicObject recBill = (DynamicObject)recBills.get(0);
            String billStatus = recBill.getString("billstatus");
            ArrayList<String> operateKeys = new ArrayList<String>(4);
            if (StringUtils.equals((CharSequence)billStatus, (CharSequence)kd.tmc.ifm.enums.BillStatusEnum.PAY.getValue())) {
                operateKeys.addAll(Arrays.asList("cancelrec", "unaudit"));
            } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)kd.tmc.ifm.enums.BillStatusEnum.AUDIT.getValue())) {
                operateKeys.add("unaudit");
            } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)kd.tmc.ifm.enums.BillStatusEnum.SUBMIT.getValue())) {
                operateKeys.add("unsubmit");
            }
            operateKeys.add("delete");
            for (String operateKey : operateKeys) {
                TmcOperateServiceHelper.execOperate((String)operateKey, (String)"cas_recbill", (Object[])new Object[]{recBill.get("id")}, (OperateOption)OperateOption.create(), (boolean)true);
            }
        }
    }
}

