/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.bean.DeductionPayBean;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;
import kd.tmc.ifm.enums.PayStatusEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.TransSourceTypeEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.JournalBookHelper;

public class TransBillHelper {
    private static final Log logger = LogFactory.getLog(TransBillHelper.class);
    public static final String QUOTATION_DIRECT = "0";
    public static final String QUOTATION_INDIRECT = "1";
    public static final int CURRENCY_ROUND = 10;

    public static void addToIepWhiteList(DynamicObject[] dataEntities, String op) {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String entityName = dataEntities[0].getDataEntityType().getName();
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            DynamicObject bizTask = TmcDataServiceHelper.newDynamicObject((String)"iep_businesstask");
            bizTask.set("business", (Object)entityName);
            bizTask.set("oper", (Object)op);
            bizTask.set("entityid", entity.getPkValue());
            tasks.add(bizTask);
        }
        try (TXHandle handle = TX.requiresNew((String)"iep.iep_businesstask");){
            SaveServiceHelper.save((DynamicObject[])tasks.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject getCasPaySrcBill(DynamicObject RecTransObj) {
        String bankCheckFlag = RecTransObj.getString("bankcheckflag");
        String sourceBillType = RecTransObj.getString("sourcebilltype");
        if (!"fca_transdownbill".equals(sourceBillType)) {
            return null;
        }
        long entryId = Long.parseLong(bankCheckFlag);
        QFilter qFilter = new QFilter("entry.e_sourcebillentryid", "=", (Object)entryId);
        DynamicObjectCollection payObjs = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        return !payObjs.isEmpty() ? (DynamicObject)payObjs.get(0) : null;
    }

    public static DynamicObject getCasRecSrcBill(DynamicObject RecTransObj) {
        String bankCheckFlag = RecTransObj.getString("bankcheckflag");
        String sourceBillType = RecTransObj.getString("sourcebilltype");
        if (!"fca_transupbill".equals(sourceBillType)) {
            return null;
        }
        long entryId = Long.parseLong(bankCheckFlag);
        QFilter qFilter = new QFilter("entry.e_sourcebillentryid", "=", (Object)entryId);
        DynamicObjectCollection recObjs = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        return !recObjs.isEmpty() ? (DynamicObject)recObjs.get(0) : null;
    }

    public static BigDecimal getExchangeRateByTable(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date exratedate, Long exchangeRateTableId) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (exchangeRateTableId == 0L || EmptyUtil.isEmpty((Long)exchangeRateTableId)) {
            exchangeRateTableId = TransBillHelper.getExrateTable(orgId).getLong("id");
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exratedate);
        return exchangeRate;
    }

    public static DynamicObject getExrateTable(long orgId) {
        DynamicObject systemStatusCtrol = TransBillHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("exratetable") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"TransBillHelper_0", (String)"tmc-ifm-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("exratetable");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static String getBankCheckFlagToCas(DynamicObject transBill, String bankCheckFlag, String beiBankCheckFlag) {
        DynamicObject bankAccount = transBill.getDynamicObject("bankaccount");
        String transType = transBill.getString("transtype");
        if (!TransTypeEnum.isLinkagePAY(transType) || EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
            return bankCheckFlag;
        }
        bankAccount = TmcDataServiceHelper.loadSingleFromCache((Object)bankAccount.getPkValue(), (String)"bd_accountbanks", (String)"bank,company");
        DynamicObject company = bankAccount.getDynamicObject("company");
        if (bankAccount.getDynamicObject("company") == null) {
            return bankCheckFlag;
        }
        boolean isBookInner = TransBillHelper.isBookInner(company.getLong("id"));
        if (isBookInner) {
            logger.info("transbillid:{},is_book_inner is true\uff0cbankcheckflag\uff1a{}", transBill.getPkValue(), (Object)beiBankCheckFlag);
            return beiBankCheckFlag;
        }
        return bankCheckFlag;
    }

    public static Map<String, Object> getExchangeRateMap(DynamicObject sCurrency, DynamicObject tCurrency, DynamicObject exTable, Date date) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{sCurrency, tCurrency, exTable})) {
            return null;
        }
        if (EmptyUtil.isEmpty((Object)date)) {
            date = DateUtils.getCurrentDate();
        }
        return BaseDataServiceHelper.getExchangeRateMap((Long)sCurrency.getLong("id"), (Long)tCurrency.getLong("id"), (Long)exTable.getLong("id"), (Date)date);
    }

    public static BigDecimal getLocalAmt(BigDecimal amt, BigDecimal rate, String quotaTion, int round) {
        if (rate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (QUOTATION_INDIRECT.equals(quotaTion)) {
            return amt.divide(rate, round, RoundingMode.HALF_UP);
        }
        return amt.multiply(rate).setScale(round, RoundingMode.HALF_UP);
    }

    public static boolean isBaseCurrencyRate(long orgId) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.IFM.getId(), (long)orgId, (String)"basecurrencyrate");
    }

    public static boolean isBookIfm(long orgId) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CAS.getId(), (long)orgId, (String)"is_book_ifm");
    }

    public static boolean isBookInner(long orgId) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.CAS.getId(), (long)orgId, (String)"is_book_inner");
    }

    public static List<IOperateInfo> getErrorInfos(OperationResult result) {
        ArrayList<IOperateInfo> errorInfos = new ArrayList<IOperateInfo>();
        if (result == null) {
            return errorInfos;
        }
        if (result.getAllErrorOrValidateInfo().size() > 0) {
            errorInfos.addAll(result.getAllErrorOrValidateInfo());
        } else {
            OperateInfo errorInfo = new OperateInfo();
            errorInfo.setMessage(result.getMessage());
            errorInfos.add((IOperateInfo)errorInfo);
        }
        return errorInfos;
    }

    public static boolean isPassivePay(DynamicObject paymentIde, String deductionType) {
        if (EmptyUtil.isEmpty((DynamicObject)paymentIde) || EmptyUtil.isEmpty((String)deductionType)) {
            return false;
        }
        return DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType) && QUOTATION_INDIRECT.equals(paymentIde.getString("type"));
    }

    public static boolean isTranPassivePay(DynamicObject transBill) {
        DynamicObject paymentIde = transBill.getDynamicObject("paymentidentify");
        String transType = transBill.getString("transtype");
        if (EmptyUtil.isEmpty((DynamicObject)paymentIde) || EmptyUtil.isEmpty((String)transType)) {
            return false;
        }
        return TransTypeEnum.isAgentPay(transType) && QUOTATION_INDIRECT.equals(paymentIde.getString("type"));
    }

    public static boolean isAutoPaid(DynamicObject transBill) {
        String transType = transBill.getString("deductiontype");
        return DeductionTypeEnum.isAgentDeduction(transType) || DeductionTypeEnum.isDeduction(transType) || TransBillHelper.isPassivePay(transBill.getDynamicObject("paymentidentify"), transType);
    }

    public static DynamicObject syncAcceptanceBill(DynamicObject transBill) {
        if (!"ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) {
            return null;
        }
        Long payacceptBillId = (Long)transBill.get("sourcebillid");
        DynamicObject payacceptBill = BusinessDataServiceHelper.loadSingle((Object)payacceptBillId, (String)"ifm_payacceptancebill", (String)"id,bizstatus,sourcebillid,sourcebilltype");
        payacceptBill.set("bizstatus", (Object)PayAcceptBizStatusEnum.PAID.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payacceptBill});
        return payacceptBill;
    }

    public static String checkCurrencyAmt(DynamicObject data) {
        String sourceBillType = data.getString("sourcebilltype");
        Long sourceBillId = data.getLong("sourcebillid");
        DynamicObject currency = data.getDynamicObject("currency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{sourceBillType, sourceBillId})) {
            return "";
        }
        Long sourceBillCurr = 0L;
        BigDecimal sourceBillAmount = BigDecimal.ZERO;
        String errorMsg = "";
        DynamicObject paymentIdentify = data.getDynamicObject("paymentidentify");
        boolean isActivePay = QUOTATION_DIRECT.equals(paymentIdentify.getString("type"));
        if ("ifm_payacceptancebill".equals(sourceBillType)) {
            errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7ed3\u7b97\u53d7\u7406", (String)"TransBillHelper_1", (String)"tmc-ifm-common", (Object[])new Object[0]);
            DynamicObjectCollection payAcceptBills = QueryServiceHelper.query((String)sourceBillType, (String)"transtype,currency,actpayamt,payeebanknum,recaccbankname,payeename", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payAcceptBills) && payAcceptBills.size() > 0) {
                DynamicObject payAcceptBill = (DynamicObject)payAcceptBills.get(0);
                if (EmptyUtil.isEmpty((DynamicObject)payAcceptBill)) {
                    return String.format(ResManager.loadKDString((String)"ID\u4e3a[%1$s]\u7684%2$s\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_2", (String)"tmc-ifm-common", (Object[])new Object[0]), sourceBillId, errorMsg);
                }
                sourceBillCurr = payAcceptBill.getLong("currency");
                sourceBillAmount = payAcceptBill.getBigDecimal("actpayamt");
                String transType = payAcceptBill.getString("transtype");
                if (isActivePay && !TransTypeEnum.isLinkagePAY(transType) && !TransTypeEnum.isAgentPay(transType)) {
                    return ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u4e3a\u4e3b\u52a8\u4ed8\u6b3e\uff0c\u5185\u90e8\u7ed3\u7b97\u53d7\u7406\u5355\u7684\u4ea4\u6613\u7c7b\u578b\u5fc5\u987b\u4e3a\u5185\u90e8\u4ee3\u4ed8\u6216\u8054\u52a8\u652f\u4ed8\u3002", (String)"TransBillHelper_3", (String)"tmc-ifm-common", (Object[])new Object[0]);
                }
                String checkMsg = TransBillHelper.checkRecerAndBankAcct(payAcceptBill, data, isActivePay, errorMsg);
                if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                    return checkMsg;
                }
            }
        } else if ("ifm_deduction".equals(sourceBillType)) {
            DynamicObjectCollection deductions = QueryServiceHelper.query((String)sourceBillType, (String)"deductiontype,paymentidentify,payeebanknum,recaccbankname,payeename,receivecurrency,entryentity.id,entryentity.payamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId), new QFilter("entryentity.id", "=", (Object)data.getLong("sourcebillentryid"))});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)deductions) && deductions.size() > 0) {
                errorMsg = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e", (String)"TransBillHelper_4", (String)"tmc-ifm-common", (Object[])new Object[0]);
                DynamicObject deduction = deductions.stream().filter(o -> data.getLong("sourcebillentryid") == o.getLong("entryentity.id")).findFirst().orElse(null);
                if (EmptyUtil.isEmpty((DynamicObject)deduction)) {
                    return String.format(ResManager.loadKDString((String)"ID\u4e3a[%1$s]\u7684%2$s\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_2", (String)"tmc-ifm-common", (Object[])new Object[0]), sourceBillId, errorMsg);
                }
                sourceBillCurr = deduction.getLong("receivecurrency");
                sourceBillAmount = deduction.getBigDecimal("entryentity.payamount");
                long payIdentyId = deduction.getLong("paymentidentify");
                DynamicObject payIdenty = QueryServiceHelper.queryOne((String)"cas_paymentidentify", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payIdentyId)});
                if (!(!isActivePay || DeductionTypeEnum.isCenterAgent(deduction.getString("deductiontype")) && payIdenty != null && QUOTATION_DIRECT.equals(payIdenty.getString("type")))) {
                    return ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u4e3a\u4e3b\u52a8\u4ed8\u6b3e\uff0c\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5355\u6263\u6b3e\u7c7b\u578b\u5fc5\u987b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\u4e14\u4ed8\u6b3e\u6807\u8bc6\u4e3a\u4e3b\u52a8\u4ed8\u6b3e\u3002", (String)"TransBillHelper_5", (String)"tmc-ifm-common", (Object[])new Object[0]);
                }
                String checkMsg = TransBillHelper.checkRecerAndBankAcct(deduction, data, isActivePay, errorMsg);
                if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                    return checkMsg;
                }
            }
        } else {
            if (isActivePay) {
                DynamicObjectType objType = data.getDynamicObjectType();
                ValueMapItem item = ((ComboProp)objType.getProperty("sourcebilltype")).getComboItems().stream().filter(o -> o.getValue().equals(sourceBillType)).findFirst().orElse(null);
                return ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u7684\u6e90\u5355\u7c7b\u578b\u4e3a%s\uff0c\u4e0d\u652f\u6301\u4ed8\u6b3e\u6807\u8bc6\u4e3a\u4e3b\u52a8\u4ed8\u6b3e\u3002", (String)"TransBillHelper_6", (String)"tmc-ifm-common", (Object[])new Object[]{item == null ? "" : item.getName().getLocaleValue()});
            }
            return "";
        }
        if (currency == null || currency.getLong("id") != sourceBillCurr.longValue()) {
            return String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u4ed8\u6b3e\u5e01\u79cd[%1$s]\u548c%2$s\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_7", (String)"tmc-ifm-common", (Object[])new Object[0]), currency != null ? currency.getString("name") : "", errorMsg);
        }
        if (sourceBillAmount.compareTo(data.getBigDecimal("actpayamt")) != 0) {
            currency = TmcDataServiceHelper.loadSingleFromCache((Object)sourceBillCurr, (String)"bd_currency", (String)"amtprecision");
            int amtPrecision = currency.getInt("amtprecision");
            return String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u4ed8\u6b3e\u91d1\u989d[%1$s]\u548c%2$s\u5355\u91d1\u989d[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_8", (String)"tmc-ifm-common", (Object[])new Object[0]), data.getBigDecimal("actpayamt").setScale(amtPrecision, RoundingMode.HALF_UP), errorMsg, sourceBillAmount.setScale(amtPrecision, 4));
        }
        return "";
    }

    private static String checkRecerAndBankAcct(DynamicObject bill, DynamicObject data, boolean isActivePay, String errorMsg) {
        if (!isActivePay) {
            return "";
        }
        String payeeAcctNum = data.getString("payeebanknum");
        String rerName = data.getString("recaccbankname");
        String paymentChannel = data.getString("paymentchannel");
        String payeeBankNum = bill.getString("payeebanknum");
        String recBankName = bill.getString("recaccbankname");
        if (!PaymentChanEnum.BEI.getValue().equals(paymentChannel)) {
            rerName = data.getString("payeename");
            recBankName = bill.getString("payeename");
        }
        if (!rerName.equals(recBankName)) {
            return String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u7684\u6536\u6b3e\u4eba\u6237\u540d[%1$s]\u548c%2$s\u5355\u7684\u6237\u540d[%3$s]\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_9", (String)"tmc-ifm-common", (Object[])new Object[0]), rerName, errorMsg, recBankName);
        }
        if (!payeeAcctNum.equals(payeeBankNum)) {
            return String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u7684\u6536\u6b3e\u8d26\u53f7[%1$s]\u548c%2$s\u5355\u7684\u6536\u6b3e\u8d26\u53f7[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_10", (String)"tmc-ifm-common", (Object[])new Object[0]), payeeAcctNum, errorMsg, payeeBankNum);
        }
        return "";
    }

    public static String checkTranDetailToDeduction(DynamicObject dataEntity) {
        if (!"bei_transdetail".equals(dataEntity.getString("sourcebilltype"))) {
            return "";
        }
        long sourceBillId = dataEntity.getLong("sourcebillid");
        boolean isExist = QueryServiceHelper.exists((String)"ifm_deduction", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId).and("id", "!=", dataEntity.getPkValue())});
        if (isExist) {
            return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6[%s]\u5df2\u751f\u6210\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5355\u3002", (String)"TransBillHelper_14", (String)"tmc-ifm-common", (Object[])new Object[]{dataEntity.getString("sourcebillno")});
        }
        DynamicObject payIdenty = dataEntity.getDynamicObject("paymentidentify");
        if (QUOTATION_DIRECT.equals(payIdenty.getString("type"))) {
            return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5355\u7684\u4ed8\u6b3e\u6807\u8bc6\u5fc5\u987b\u4e3a\u88ab\u52a8\u4ed8\u6b3e\u3002", (String)"TransBillHelper_11", (String)"tmc-ifm-common", (Object[])new Object[0]);
        }
        DynamicObject currency = dataEntity.getDynamicObject("receivecurrency");
        BigDecimal receiveAmount = dataEntity.getBigDecimal("receiveamount");
        DynamicObject transDetail = QueryServiceHelper.queryOne((String)"bei_transdetail", (String)"currency,debitamount,creditamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
        if (EmptyUtil.isNoEmpty((DynamicObject)transDetail)) {
            long detailCurrId = transDetail.getLong("currency");
            BigDecimal amount = transDetail.getBigDecimal("debitamount");
            if (BigDecimal.ZERO.compareTo(amount) > 0) {
                amount = transDetail.getBigDecimal("creditamount");
            }
            if (currency == null || currency.getLong("id") != detailCurrId) {
                return ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5355\u7684\u5e01\u79cd\u548c\u4ea4\u6613\u660e\u7ec6\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_12", (String)"tmc-ifm-common", (Object[])new Object[0]);
            }
            if (receiveAmount.compareTo(amount) != 0) {
                return ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5355\u7684\u91d1\u989d\u548c\u4ea4\u6613\u660e\u7ec6\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransBillHelper_13", (String)"tmc-ifm-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static void writePayAccStatus(DynamicObject transBill) {
        String sourceBillType = transBill.getString("sourcebilltype");
        Long sourceBillId = transBill.getLong("sourcebillid");
        if ("ifm_payacceptancebill".equals(sourceBillType)) {
            DynamicObject[] payAccBills;
            for (DynamicObject payAccBill : payAccBills = BusinessDataServiceHelper.load((String)"ifm_payacceptancebill", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId), new QFilter("bizstatus", "!=", (Object)PayAcceptBizStatusEnum.PAID.getValue())})) {
                payAccBill.set("bizstatus", (Object)PayAcceptBizStatusEnum.PAID.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])payAccBills);
        } else if ("ifm_deduction".equals(sourceBillType)) {
            Long sourcebillEntryId = transBill.getLong("sourcebillentryid");
            TransBillHelper.writBackDeduction(sourceBillId, sourcebillEntryId);
        }
    }

    public static void writBackDeduction(Long sourceBillId, Long sourcebillEntryId) {
        DynamicObject[] deductions;
        for (DynamicObject deduction : deductions = TmcDataServiceHelper.load((Object[])new Object[]{sourceBillId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_deduction"))) {
            DynamicObjectCollection entry = deduction.getDynamicObjectCollection("entryentity");
            BigDecimal realAmount = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                if (Objects.equals(row.get("paystatus"), PayStatusEnum.SUCCEED.getValue())) {
                    realAmount = realAmount.add(row.getBigDecimal("payamount"));
                }
                if (!Objects.equals(deduction.getPkValue(), sourceBillId) || !Objects.equals(row.getPkValue(), sourcebillEntryId)) continue;
                row.set("paystatus", (Object)PayStatusEnum.SUCCEED.getValue());
                realAmount = realAmount.add(row.getBigDecimal("payamount"));
            }
            deduction.set("realamount", (Object)realAmount);
        }
        SaveServiceHelper.save((DynamicObject[])deductions);
    }

    public static String getBankCheckFlag(String transType, String bankCheckFlag, boolean isParentAcct) {
        if (TransTypeEnum.isLinkagePAY(transType) && EmptyUtil.isNoEmpty((String)bankCheckFlag)) {
            logger.info("lingpay bankcheckflag:{}", (Object)bankCheckFlag);
            String[] checkFlagArr = bankCheckFlag.split(";");
            if (checkFlagArr.length == 2) {
                return isParentAcct ? checkFlagArr[0] : checkFlagArr[1];
            }
        }
        return bankCheckFlag;
    }

    public static void cancelJournal(DynamicObject transBill) {
        String transType = transBill.getString("transtype");
        if (JournalBookHelper.isBookJournalType(transType)) {
            Long transId = transBill.getLong("id");
            Map<Long, String> failedMap = JournalBookHelper.cancelJournal(transBill.getDataEntityType().getName(), Collections.singletonList(transId));
            if (failedMap != null && EmptyUtil.isNoEmpty((String)failedMap.get(transId))) {
                throw new KDBizException(failedMap.get(transId));
            }
        }
    }

    public static void revertPayAcceptanceBill(DynamicObject transBill) {
        if (!TransSourceTypeEnum.isIfmPayacceptancebill(transBill.getString("sourcebilltype"))) {
            return;
        }
        Long acceptBillId = transBill.getLong("sourcebillid");
        if (EmptyUtil.isNoEmpty((Long)acceptBillId)) {
            DynamicObject acceptBill = TmcDataServiceHelper.loadSingle((Object)acceptBillId, (String)"ifm_payacceptancebill", (String)"bizstatus");
            acceptBill.set("bizstatus", (Object)PayAcceptBizStatusEnum.ACCEPTED.getValue());
            SaveServiceHelper.update((DynamicObject)acceptBill);
        }
    }

    public static SyncStatusInfo getBaseSyncStatusInfo(Long transBillid, Long payBillId, String bankPayStatus, String bankCheckFlag) {
        SyncStatusInfo syncStatusInfo = new SyncStatusInfo();
        syncStatusInfo.setBankBillId(transBillid);
        syncStatusInfo.setBatchSeqId(bankCheckFlag);
        syncStatusInfo.setBankPayStatus(bankPayStatus);
        ArrayList<SyncStatusDetail> detailList = new ArrayList<SyncStatusDetail>(10);
        SyncStatusDetail statusDetail = new SyncStatusDetail();
        statusDetail.setBankDetailSeqId(bankCheckFlag);
        statusDetail.setPayBillEntryId(transBillid);
        detailList.add(statusDetail);
        syncStatusInfo.setDetailList(detailList);
        syncStatusInfo.setPayBillId(payBillId);
        return syncStatusInfo;
    }

    public static void writeDeDuctionPayAccStatus(DynamicObject transBill) {
        String sourceType = transBill.getString("sourcebilltype");
        Long sourceId = (Long)transBill.get("sourcebillid");
        if ("ifm_deduction".equals(sourceType)) {
            ArrayList<DeductionPayBean> deductionPayBeans = new ArrayList<DeductionPayBean>(10);
            Long sourceBillEntryId = (Long)transBill.get("sourcebillentryid");
            DeductionPayBean deductionPayBean = new DeductionPayBean();
            deductionPayBean.setBillId(sourceId);
            deductionPayBean.setEntryRowId(sourceBillEntryId);
            deductionPayBeans.add(deductionPayBean);
            DeductionPayHelper.payConfirm(deductionPayBeans);
        }
    }
}

