/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.checktask;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.mservice.balance.InnerAcctBalanceService;

public class TransDetailBalanceCheckTask
implements FIDataCheckTask {
    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        String checkMsg = this.checkInnerAcctBalance();
        if (EmptyUtil.isNoEmpty((String)checkMsg)) {
            FIDataCheckUtil.saveResult((String)"ifm_inneracctbalance_check", (String)"ifm", (boolean)false, (String)String.format(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237%1$s\u65e5\u4f59\u989d\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u8d26\u6237[%2$s]", (String)"TransDetailBalanceCheckTask_0", (String)"tmc-ifm-mservice", (Object[])new Object[0]), DateUtils.formatString((Date)DateUtils.getLastDay((Date)new Date(), (int)1), (String)"yyyy-MM-dd"), checkMsg), (String)"kd.tmc.ifm.mservice.checktask.TransDetailBalanceCheckTask");
            return false;
        }
        return true;
    }

    private String checkInnerAcctBalance() {
        Date lastDay = DateUtils.getLastDay((Date)new Date(), (int)1);
        DataSet innerAcctDs = QueryServiceHelper.queryDataSet((String)"checkInnerAcctBalance", (String)"ifm_transdetail", (String)"accountbank,currency,debitamount,creditamount", (QFilter[])new QFilter[]{new QFilter("datasource", "=", (Object)"fromifm"), new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)lastDay, (boolean)false)), new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)lastDay, (boolean)true))}, null);
        DataSet acctBalanceDs = innerAcctDs.groupBy(new String[]{"accountbank", "currency"}).sum("debitamount").sum("creditamount").finish();
        HashSet<Long> acctIds = new HashSet<Long>();
        acctBalanceDs.copy().forEach(o -> acctIds.add(o.getLong("accountbank")));
        Date preDay = DateUtils.getLastDay((Date)lastDay, (int)1);
        DataSet preBalanceDs = this.getPreBalanceDs(preDay, acctIds).select(new String[]{"accountbank preaccountbank", "currency precurrency", "debitamount predebitamount", "creditamount precreditamount", "amount preamount"});
        DataSet errorDs = this.checkBalance(preBalanceDs.copy(), acctBalanceDs.copy(), lastDay, acctIds);
        if (errorDs.isEmpty()) {
            return "";
        }
        errorDs.forEach(o -> new InnerAcctBalanceService().rebuilBalance(o.getLong("accountbank"), o.getLong("currency"), DateUtils.getDataFormat((Date)lastDay, (boolean)true), DateUtils.getDataFormat((Date)new Date(), (boolean)false)));
        DataSet errorRebuildDs = this.checkBalance(preBalanceDs, acctBalanceDs, lastDay, acctIds);
        if (errorRebuildDs.isEmpty()) {
            return "";
        }
        StringBuilder acctIdStrs = new StringBuilder();
        errorRebuildDs.forEach(o -> acctIdStrs.append(o.getLong("accountbank")).append("\u3001"));
        return acctIdStrs.substring(0, acctIdStrs.length() - 1);
    }

    private DataSet checkBalance(DataSet preBalanceDs, DataSet acctBalanceDs, Date lastDay, Set<Long> acctIds) {
        DataSet lastBalanceDs = this.getPreBalanceDs(lastDay, acctIds).select(new String[]{"accountbank ltaccountbank", "currency ltcurrency", "debitamount ltdebitamount", "creditamount ltcreditamount", "amount ltamount"});
        DataSet resultBalanceDs = preBalanceDs.fullJoin(acctBalanceDs).on("preaccountbank", "accountbank").on("precurrency", "currency").select(new String[]{"case when preamount=null then creditamount-debitamount else preamount+creditamount-debitamount end reamount", "debitamount", "creditamount", "case when accountbank!=null then accountbank else preaccountbank end accountbank", "case when currency!=null then currency else precurrency end currency"}).finish();
        DataSet result = lastBalanceDs.leftJoin(resultBalanceDs).on("ltaccountbank", "accountbank").on("ltcurrency", "currency").select(new String[]{"accountbank", "currency", "reamount", "debitamount", "creditamount", "ltamount", "ltdebitamount", "ltcreditamount"}).finish();
        DataSet errorDs = result.filter("reamount!=ltamount or debitamount!=ltdebitamount or creditamount!=ltcreditamount");
        return errorDs;
    }

    private DataSet getPreBalanceDs(Date lastDay, Set<Long> acctIds) {
        DataSet innerAcctDs = QueryServiceHelper.queryDataSet((String)"getPreBalanceDs", (String)"ifm_accountbalance", (String)"accountbank,currency,debitamount,creditamount,amount", (QFilter[])new QFilter[]{new QFilter("accountbank", "in", acctIds), new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)lastDay, (boolean)false)), new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)lastDay, (boolean)true))}, null);
        return innerAcctDs;
    }
}

