/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.consistency.helper;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmBillCommonHelper;
import kd.tmc.ifm.mservice.consistency.bean.IfmConsistencyInfo;
import kd.tmc.ifm.mservice.consistency.callback.PushCasBillDtxCallback;

public class IfmConsistencyServiceHelper {
    private static final Log logger = LogFactory.getLog(IfmConsistencyServiceHelper.class);

    public static void asyncPush(IfmConsistencyInfo info) {
        String businessType = info.getBusinessType();
        logger.info("asyncPush dtx start, param{}", (Object)businessType, (Object)info.toString());
        try (DTXHandle dtx = DTX.requiresNew((String)businessType, (DBRoute)DBRouteConst.TMC, (boolean)false);){
            try {
                CommonParam param = new CommonParam();
                param.put((Object)"asyncPushInfo", (Object)info);
                param.put((Object)"currUserId", (Object)RequestContext.get().getCurrUserId());
                dtx.setBusinessType(businessType);
                dtx.setBusinessInfo(info.getBusinessIdStr());
                dtx.register(TmcAppEnum.TMC.getValue(), TmcAppEnum.IFM.getValue(), info.getServiceName(), (Param)param);
                if (info.needCallback()) {
                    dtx.setCallback(TmcAppEnum.IFM.getValue(), info.getCallback());
                }
            }
            catch (Exception e) {
                dtx.markRollback();
                logger.error("asyncPush dtx error,{}", (Object)e.getMessage());
                throw e;
            }
        }
    }

    public static void asyncPush(String businessType, String serviceName, List<Object> businessIds) {
        if (IfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue()) && EmptyUtil.isNoEmpty(businessIds)) {
            IfmConsistencyInfo consistencyInfo = IfmConsistencyInfo.build(businessType, serviceName, businessIds).setCallback(new PushCasBillDtxCallback());
            IfmConsistencyServiceHelper.asyncPush(consistencyInfo);
        }
    }
}

