/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.consistency.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.mservice.consistency.bean.IfmConsistencyInfo;

public abstract class AbstractIfmConsistencyService
extends EventualConsistencyService {
    private static final Log logger = LogFactory.getLog(AbstractIfmConsistencyService.class);
    private CommonDtxResponse response = new CommonDtxResponse();

    public DtxResponse execute(Object param, Object lastReturn) {
        CommonParam commonParam = (CommonParam)param;
        try {
            this.setCurrentUser(commonParam);
            this.doExecute(commonParam, lastReturn);
            this.setResponse(commonParam);
        }
        catch (Exception e) {
            String businessType = ((IfmConsistencyInfo)commonParam.get((Object)"asyncPushInfo")).getBusinessType();
            logger.error("\u573a\u666f\uff1a{}\uff0c\u6267\u884c\u5206\u5e03\u5f0f\u4e8b\u52a1\u5931\u8d25\uff0c\u9519\u8bef\u8be6\u60c5\uff1a{}\uff0ctraceid\uff1a{}", new Object[]{businessType, e.getMessage(), RequestContext.get().getTraceId()});
            throw e;
        }
        return this.response;
    }

    private void setCurrentUser(CommonParam commonParam) {
        long currUserId = RequestContext.get().getCurrUserId();
        Object currentUser = commonParam.get((Object)"currUserId");
        if (currUserId <= 0L && EmptyUtil.isNoEmpty((Object)currentUser)) {
            RequestContext.get().setUserId(currentUser.toString());
            logger.info("\u8bbe\u7f6e\u5f53\u524d\u767b\u5f55\u4eba{}\u3002", currentUser);
        }
    }

    private void setResponse(CommonParam commonParam) {
        IfmConsistencyInfo info = (IfmConsistencyInfo)commonParam.get((Object)"asyncPushInfo");
        this.response.put((Object)"businessIdStr", (Object)SerializationUtils.toJsonString(info.getBusinessIds()));
        this.response.put((Object)"transBillEntity", (Object)this.getTransBillEntity());
        this.response.put((Object)"businessType", (Object)info.getBusinessType());
        this.response.put((Object)"traceId", (Object)RequestContext.get().getTraceId());
    }

    public String getTransBillEntity() {
        return "";
    }

    /*
     * Could not resolve type clashes
     */
    protected void doRecive(IfmConsistencyInfo info, OperateOption option, String pushRecBillOpKey) {
        HashSet<Object> businessIds = new HashSet<Object>(info.getBusinessIds());
        QFilter qFilter = new QFilter("sourcebillid", "in", businessIds);
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billstatus,sourcebillid", (QFilter[])qFilter.toArray());
        Set sourceBillIdSet = recBills.stream().map(p -> p.getLong("sourcebillid")).collect(Collectors.toSet());
        businessIds.removeAll(sourceBillIdSet);
        if (!businessIds.isEmpty()) {
            TmcOperateServiceHelper.execOperate((String)pushRecBillOpKey, (String)info.getCfmEntityName(), (Object[])businessIds.toArray(), (OperateOption)option);
            qFilter = new QFilter("sourcebillid", "in", businessIds).and("billstatus", "in", Arrays.asList("A", "B", "C"));
            recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billstatus,sourcebillid", (QFilter[])qFilter.toArray());
        }
        option.setVariableValue("WF", "TRUE");
        StringBuilder builder = new StringBuilder();
        for (DynamicObject recBill : recBills) {
            List<Object> operateKeys = null;
            long recBillId = recBill.getLong("id");
            long sourceBillId = recBill.getLong("sourcebillid");
            switch (recBill.getString("billstatus")) {
                case "A": {
                    operateKeys = Arrays.asList("submit", "audit", "receivingrec");
                    break;
                }
                case "B": {
                    operateKeys = Arrays.asList("audit", "receivingrec");
                    break;
                }
                case "C": {
                    operateKeys = Collections.singletonList("receivingrec");
                    break;
                }
                default: {
                    operateKeys = Collections.emptyList();
                }
            }
            try {
                for (String operateKey : operateKeys) {
                    TmcOperateServiceHelper.execOperate((String)operateKey, (String)"cas_recbill", (Object[])new Object[]{recBillId}, (OperateOption)option);
                }
            }
            catch (Exception e) {
                String error = String.format("receivingrec recbill error, sourcebillid: %d, recBillId: %d, error: %s", sourceBillId, recBillId, e.getMessage());
                builder.append(error).append("\n");
                logger.error(error, (Throwable)e);
            }
        }
        if (builder.length() > 0) {
            throw new KDBizException(builder.toString());
        }
    }

    /*
     * Could not resolve type clashes
     */
    protected void doPay(IfmConsistencyInfo info, OperateOption option, String pushPayBillOpKey) {
        HashSet<Object> businessIds = new HashSet<Object>(info.getBusinessIds());
        QFilter qFilter = new QFilter("entry.e_sourcebillid", "in", businessIds);
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,entry.e_sourcebillid", (QFilter[])qFilter.toArray());
        Set sourceBillIdSet = payBills.stream().map(p -> p.getLong("entry.e_sourcebillid")).collect(Collectors.toSet());
        businessIds.removeAll(sourceBillIdSet);
        if (!businessIds.isEmpty()) {
            TmcOperateServiceHelper.execOperate((String)pushPayBillOpKey, (String)info.getCfmEntityName(), (Object[])businessIds.toArray(), (OperateOption)option);
            qFilter = new QFilter("entry.e_sourcebillid", "in", businessIds).and("billstatus", "in", Arrays.asList("A", "B", "C"));
            payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,entry.e_sourcebillid", (QFilter[])qFilter.toArray());
        }
        option.setVariableValue("WF", "TRUE");
        StringBuilder builder = new StringBuilder();
        HashSet<Long> payBillIds = new HashSet<Long>(payBills.size());
        for (DynamicObject payBill : payBills) {
            List<Object> operateKeys = null;
            long payBillId = payBill.getLong("id");
            if (!payBillIds.add(payBillId)) continue;
            long sourceBillId = payBill.getLong("entry.e_sourcebillid");
            switch (payBill.getString("billstatus")) {
                case "A": {
                    operateKeys = Arrays.asList("submit", "audit", "pay");
                    break;
                }
                case "B": {
                    operateKeys = Arrays.asList("audit", "pay");
                    break;
                }
                case "C": {
                    operateKeys = Collections.singletonList("pay");
                    break;
                }
                default: {
                    operateKeys = Collections.emptyList();
                }
            }
            try {
                for (String operateKey : operateKeys) {
                    TmcOperateServiceHelper.execOperate((String)operateKey, (String)"cas_paybill", (Object[])new Object[]{payBillId}, (OperateOption)option);
                }
            }
            catch (Exception e) {
                String error = String.format("pay paybill error, sourcebillid: %d, paybillId: %d, error: %s", sourceBillId, payBillId, e.getMessage());
                builder.append(error).append("\n");
                logger.error(error, (Throwable)e);
            }
        }
        if (builder.length() > 0) {
            throw new KDBizException(builder.toString());
        }
    }

    public abstract void doExecute(CommonParam var1, Object var2);
}

