/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.ebservice.sync;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxBranch;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.invoke.DtxResult;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.TransDetailHelper;

public class DetailMatchDtxCallback
implements DTXCallback {
    private static Log logger = LogFactory.getLog(DetailMatchDtxCallback.class);

    public void callback(DtxResult dtxResult) {
        logger.info("detail match start");
        List branchList = dtxResult.getBranchList();
        if (EmptyUtil.isEmpty((Collection)branchList)) {
            return;
        }
        DtxResponse dtxResponse = ((DtxBranch)branchList.get(0)).getDtxResponse();
        if (dtxResponse == null) {
            return;
        }
        CommonDtxResponse response = (CommonDtxResponse)dtxResponse;
        Object detailIds = response.get((Object)"detailIds");
        logger.info("detail match detailids:{}", detailIds);
        if (EmptyUtil.isNoEmpty((Object)detailIds)) {
            List transDetailIds = Arrays.stream(((String)detailIds).split(",")).map(Long::parseLong).collect(Collectors.toList());
            try (TXHandle tx = TX.requiresNew();){
                try {
                    TransDetailHelper.matchBillByBankCheckFlag(transDetailIds, (boolean)true);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            boolean isPending = QueryServiceHelper.exists((String)"ifm_transdetail", (QFilter[])new QFilter[]{new QFilter("id", "in", transDetailIds), new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue())});
            if (isPending) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u81ea\u52a8\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"DetailMatchDtxCallback_0", (String)"tmc-ifm-mservice", (Object[])new Object[0]));
            }
        }
    }
}

