/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.ebservice.sync;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.sync.IPayBillSyncStatusService;
import kd.tmc.ifm.bean.JournalInfo;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;

public class TransBillSyncStatusService
implements IPayBillSyncStatusService {
    private static final Log logger = LogFactory.getLog(TransBillSyncStatusService.class);

    public SyncStatusResult syncStatus(SyncStatusInfo info) {
        logger.info("\u5185\u90e8\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u540c\u6b65\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)SerializationUtils.toJsonString((Object)info));
        SyncStatusResult result = new SyncStatusResult();
        result.setStatusCode(EBResultStatusCode.SUCCESS);
        Long payBillId = info.getPayBillId();
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"ifm_transhandlebill");
        String transType = transBill.getString("transtype");
        String bankCheckFlag = GenBankcheckCode.genCode();
        List<Long> transDetailIds = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                String paidStatus = transBill.getString("paidstatus");
                String beiBankCheckFlag = this.doSyncStatusMainProcess(info, transBill);
                transDetailIds = this.transBillPaysuccess(transBill, paidStatus, info.getBankPayStatus(), bankCheckFlag, beiBankCheckFlag);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transBill});
            }
            catch (Exception e) {
                tx.markRollback();
                result.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result.setStatusCode(EBResultStatusCode.ROLLBACK);
                SyncStatusResult beiBankCheckFlag = result;
                if (tx != null) {
                    if (var9_10 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var9_10.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return beiBankCheckFlag;
            }
        }
        logger.info("update transbill success");
        try {
            String sourceBillType = transBill.getString("sourcebilltype");
            SyncStatusInfo syncInfo = null;
            JournalInfo journalInfo = null;
            if ("ifm_payacceptancebill".equals(sourceBillType)) {
                long casPayBillId = BankBillSyncStatusHelper.getCasPayBillId(transBill);
                if (BeBillStatusEnum.TS.getValue().equals(info.getBankPayStatus())) {
                    String bankCheckBei = TransBillHelper.getBankCheckFlag((String)transType, (String)transBill.getString("beibankcheckflag"), (boolean)false);
                    String bankCheckFlagToCas = TransBillHelper.getBankCheckFlagToCas((DynamicObject)transBill, (String)bankCheckFlag, (String)bankCheckBei);
                    logger.info("to cas bankcheckflage:{}", (Object)bankCheckFlagToCas);
                    syncInfo = this.getSyncStatusInfo(info, bankCheckFlagToCas, casPayBillId, transBill.getDate("commitbetime"));
                } else {
                    logger.info("pay not success");
                    syncInfo = this.getSyncStatusInfo(info, "", casPayBillId, transBill.getDate("commitbetime"));
                }
            }
            if (BeBillStatusEnum.TS.getValue().equals(info.getBankPayStatus())) {
                journalInfo = JournalBookHelper.createJournalInfo((DynamicObject)transBill);
            }
            BankBillSyncStatusHelper.syncPaymentBill(syncInfo, journalInfo, transDetailIds, true);
        }
        catch (Exception e) {
            result.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setStatusCode(EBResultStatusCode.ROLLBACK);
            return result;
        }
        return result;
    }

    private List<Long> transBillPaysuccess(DynamicObject transBill, String paidStatus, String bankPayStatus, String bankCheckFlag, String beiBankCheckFlag) {
        if (BeBillStatusEnum.TS.getValue().equals(bankPayStatus)) {
            if (!TransBillPaidStatusEnum.PAID.getValue().equals(paidStatus)) {
                String transType = transBill.getString("transtype");
                transBill.set("bankcheckflag", (Object)bankCheckFlag);
                String ifmBankCheckFlag = TransBillHelper.getBankCheckFlag((String)transType, (String)beiBankCheckFlag, (boolean)true);
                transBill.set("beibankcheckflag", (Object)ifmBankCheckFlag);
                TransBillHelper.writePayAccStatus((DynamicObject)transBill);
                return this.createTransDetail(transBill);
            }
            logger.info("\u5185\u90e8\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u5df2\u4ed8\u6b3e,\u4e0d\u518d\u91cd\u590d\u6267\u884c\uff0c\u5355\u636eID\uff1a{}", transBill.getPkValue());
        } else if (BeBillStatusEnum.TF.getValue().equals(bankPayStatus) && TransBillPaidStatusEnum.PAID.getValue().equals(paidStatus)) {
            TransBillHelper.cancelJournal((DynamicObject)transBill);
            TransDetailService.asyncDeleteTransDetail(transBill);
            TransBillHelper.revertPayAcceptanceBill((DynamicObject)transBill);
            DeductionPayHelper.revertDeductionBill((DynamicObject)transBill);
        }
        return null;
    }

    protected String doSyncStatusMainProcess(SyncStatusInfo info, DynamicObject transBill) {
        logger.info("-------\u6267\u884c\u5185\u90e8\u4ea4\u6613\u4ed8\u6b3e\u5355\u540c\u6b65\u72b6\u6001\u4e3b\u6d41\u7a0b: SyncSreceiveaccounttatusInfo = " + SerializationUtils.toJsonString((Object)info));
        if (!transBill.getBoolean("iscommitbe")) {
            logger.info("--\u94f6\u884c\u4ed8\u6b3e\u5355\u540c\u6b65\u72b6\u6001\u5931\u8d25\uff08\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u662f\u5426\u63d0\u4ea4\u94f6\u4f01\u4e3a\u5426\uff0c\u4e0d\u652f\u6301\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\uff1btraceid\uff1a{}", (Object)RequestContext.get().getTraceId());
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355[%s]\u662f\u5426\u63d0\u4ea4\u94f6\u4f01\u7684\u503c\u4e3a\u5426\uff0c\u4e0d\u652f\u6301\u94f6\u884c\u4ed8\u6b3e\u5355\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001", (String)"TransBillSyncStatusService_0", (String)"tmc-ifm-mservice", (Object[])new Object[]{transBill.getString("billno")}));
        }
        SyncStatusDetail infoDetail = (SyncStatusDetail)info.getDetailList().get(0);
        String bankpaystate = info.getBankPayStatus();
        String beiBankCheckFlag = infoDetail.getBankDetailSeqId();
        String bankReturnMsg = infoDetail.getEbStatusMsg();
        if (BeBillStatusEnum.OF.getValue().equals(bankpaystate) || BeBillStatusEnum.OP.getValue().equals(bankpaystate)) {
            transBill.set("bankcheckflag", null);
            transBill.set("beibankcheckflag", null);
        } else if (BeBillStatusEnum.TS.getValue().equals(bankpaystate)) {
            transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAID.getValue());
            transBill.set("paydate", (Object)new Date());
            transBill.set("bankpaystatus", (Object)bankpaystate);
            transBill.set("bankreturnmsg", (Object)bankReturnMsg);
            if (beiBankCheckFlag != null && beiBankCheckFlag.trim().length() > 0) {
                transBill.set("beibankcheckflag", (Object)beiBankCheckFlag);
            }
            transBill.set("cashier", (Object)RequestContext.get().getCurrUserId());
        } else if (BeBillStatusEnum.TF.getValue().equals(bankpaystate)) {
            transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAYING.getValue());
            transBill.set("paydate", null);
            transBill.set("bankpaystatus", (Object)bankpaystate);
            transBill.set("bankreturnmsg", (Object)bankReturnMsg);
            transBill.set("bankcheckflag", null);
            transBill.set("beibankcheckflag", null);
            transBill.set("cashier", null);
        } else {
            transBill.set("bankcheckflag", null);
            transBill.set("beibankcheckflag", null);
            transBill.set("bankpaystatus", (Object)bankpaystate);
            transBill.set("bankreturnmsg", (Object)bankReturnMsg);
            transBill.set("paydate", null);
        }
        return beiBankCheckFlag;
    }

    private SyncStatusInfo getSyncStatusInfo(SyncStatusInfo info, String IfmBankCheckFlag, long casPayBillId, Date commitbetime) {
        logger.info("transbill writeback caspaybill, tranbillid:{}, casPayBillId:{}", (Object)info.getPayBillId(), (Object)casPayBillId);
        SyncStatusInfo syncInfo = new SyncStatusInfo();
        syncInfo.setCommitBe(true);
        syncInfo.setCommitBeTime(commitbetime);
        syncInfo.setBankPayStatus(info.getBankPayStatus());
        syncInfo.setStatusCode(info.getStatusCode());
        syncInfo.setPayBillId(Long.valueOf(casPayBillId));
        List detailList = info.getDetailList();
        for (SyncStatusDetail statusDetail : detailList) {
            statusDetail.setBankDetailSeqId(IfmBankCheckFlag);
            statusDetail.setPayBillEntryId(info.getPayBillId());
        }
        syncInfo.setDetailList(detailList);
        syncInfo.setBatchSeqId(info.getBatchSeqId());
        syncInfo.setErrMsg(info.getErrMsg());
        syncInfo.setBankBillId(info.getBankBillId());
        syncInfo.setErrCode(info.getErrCode());
        return syncInfo;
    }

    private List<Long> createTransDetail(DynamicObject transBill) {
        DynamicObject[] transDetails = TransDetailService.createTransDetail(transBill);
        String sourceBillType = transBill.getString("sourcebilltype");
        if ("ifm_payacceptancebill".equals(sourceBillType)) {
            return TransDetailHelper.getTransDetails((DynamicObject[])transDetails, (boolean)true);
        }
        return null;
    }
}

