/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transdetail;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.mservice.transdetail.PayTransDetailBuilder;
import kd.tmc.ifm.mservice.transdetail.RecTransDetailBuilder;

public abstract class AbstractTransDetailBuilder {
    private DynamicObject bizBill;

    public static AbstractTransDetailBuilder createBuilder(DynamicObject bill) {
        String entityType = bill.getDataEntityType().getName();
        if ("ifm_rectransbill".equals(entityType)) {
            return new RecTransDetailBuilder(bill);
        }
        if ("ifm_transhandlebill".equals(entityType)) {
            return new PayTransDetailBuilder(bill);
        }
        throw new KDBizException("not supported");
    }

    public AbstractTransDetailBuilder(DynamicObject bill) {
        this.bizBill = bill;
    }

    public DynamicObject getBizBill() {
        return this.bizBill;
    }

    public abstract List<DynamicObject> build();

    protected Date getBizDate(Date acceptDate, Date bizDate, Date currentDate, Boolean iscommitbe) {
        Date myacceptDate = DateUtils.truncateDate((Date)acceptDate);
        Date mybizDate = DateUtils.truncateDate((Date)bizDate);
        Date mycurrentDate = DateUtils.truncateDate((Date)currentDate);
        if (iscommitbe.booleanValue()) {
            return mycurrentDate.after(myacceptDate) ? mycurrentDate : myacceptDate;
        }
        return mybizDate.after(myacceptDate) ? mybizDate : myacceptDate;
    }

    protected Date getBizTime(Date bizDate, Date currentDate) {
        String dateStr = DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd");
        String timeStr = DateUtils.formatString((Date)currentDate, (String)"HH:mm:ss");
        String datetime = dateStr + " " + timeStr;
        return DateUtils.stringToDate((String)datetime, (String)"yyyy-MM-dd HH:mm:ss");
    }
}

