/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.transhandlebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.bean.TransBillUpdatePaidInfo;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.resources.IfmMseResourceEnum;

public class TranBillCdmWritebackService {
    private static final Log logger = LogFactory.getLog(TranBillCdmWritebackService.class);
    private static final String OP_KEY = "cdmwrite";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransBillUpdatePaidInfo> updatePaidStatus(List<TransBillUpdatePaidInfo> params) {
        String paramStr = SerializationUtils.toJsonString(params);
        logger.info("TranBillCdmWritebackService params:{}", (Object)paramStr);
        if (EmptyUtil.isEmpty(params)) {
            return params;
        }
        Set transBillIds = params.stream().map(o -> o.getTransBillId()).collect(Collectors.toSet());
        Map muteLocks = MutexServiceHelper.batchRequest(transBillIds.stream().map(String::valueOf).collect(Collectors.toList()), (String)"ifm_transhandlebill", (String)OP_KEY);
        Set<Long> lockSucessIds = muteLocks.entrySet().stream().filter(o -> (Boolean)o.getValue()).map(o -> Long.valueOf((String)o.getKey())).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(lockSucessIds)) {
            this.setFailMsg(params, IfmMseResourceEnum.TranBillCdmWritebackService_7.loadKDString());
            return params;
        }
        try {
            this.updateTransBill(params, lockSucessIds);
            List<TransBillUpdatePaidInfo> list = params;
            return list;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            this.setFailMsg(params, ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        finally {
            if (EmptyUtil.isNoEmpty(lockSucessIds)) {
                MutexServiceHelper.batchRelease(lockSucessIds.stream().map(String::valueOf).collect(Collectors.toList()), (String)"ifm_transhandlebill", (String)OP_KEY);
            }
        }
        return params;
    }

    private void updateTransBill(List<TransBillUpdatePaidInfo> params, Set<Long> lockSucessIds) {
        if (EmptyUtil.isEmpty(lockSucessIds)) {
            return;
        }
        HashMap<Long, Long> transBillTocasMap = new HashMap<Long, Long>();
        try (TXHandle tx = TX.required();){
            try {
                ArrayList<DynamicObject> transBillUpdates = new ArrayList<DynamicObject>();
                DynamicObject[] transBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id,billstatus,transtype,paidstatus,settletype,billno,bizdate,bankcheckflag,paydate,sourcebillentryid,sourcebillid,sourcebilltype,settletnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", lockSucessIds)});
                Map transBillMap = Arrays.stream(transBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (v1, v2) -> v2));
                Set<Long> paidTransIds = this.getPaidTransIds(transBills);
                for (TransBillUpdatePaidInfo info : params) {
                    if (!lockSucessIds.contains(info.getTransBillId())) {
                        info.setSuccess(false);
                        info.setErrorMsg(IfmMseResourceEnum.TranBillCdmWritebackService_7.loadKDString());
                        logger.info("lock fail billid:{}", (Object)info.getTransBillId());
                        continue;
                    }
                    DynamicObject transBill = (DynamicObject)transBillMap.get(info.getTransBillId());
                    String res = this.checkUpdateLegal(transBill, info, paidTransIds);
                    if (EmptyUtil.isNoEmpty((String)res)) {
                        info.setSuccess(false);
                        info.setErrorMsg(res);
                        logger.info("check fial:{}", (Object)res);
                        continue;
                    }
                    String billPaidStatus = transBill.getString("paidstatus");
                    if (EmptyUtil.isNoEmpty((String)billPaidStatus) && billPaidStatus.equals(info.getPaidStatus())) {
                        info.setSuccess(true);
                        logger.info("paidstatus is same");
                        continue;
                    }
                    DynamicObject updateBill = this.transBillPaided(transBill, info.getPaidStatus(), info.getDraftBillno(), transBillTocasMap);
                    DynamicObject dynamicObject = updateBill = EmptyUtil.isEmpty((DynamicObject)updateBill) ? this.transBillPaiding(transBill, info.getPaidStatus()) : updateBill;
                    if (EmptyUtil.isNoEmpty((DynamicObject)updateBill)) {
                        transBillUpdates.add(updateBill);
                    }
                    info.setSuccess(true);
                }
                if (EmptyUtil.isNoEmpty(transBillUpdates)) {
                    SaveServiceHelper.update((DynamicObject[])transBillUpdates.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                this.setFailMsg(params, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        for (Map.Entry trans : transBillTocasMap.entrySet()) {
            logger.info("cas writeback start paybillid:{}", trans.getValue());
            SyncStatusInfo syncStatusInfo = BankBillSyncStatusHelper.getSyncStatusInfo((Long)trans.getKey(), (Long)trans.getValue(), "");
            BankBillSyncStatusHelper.syncPaymentBill(syncStatusInfo, null, null, true);
        }
    }

    private DynamicObject transBillPaiding(DynamicObject transBill, String paidStatus) {
        if (!TransBillPaidStatusEnum.isPaying((String)paidStatus) && !TransBillPaidStatusEnum.isWaiting((String)paidStatus)) {
            return null;
        }
        String billPaidStatus = transBill.getString("paidstatus");
        if (TransBillPaidStatusEnum.isPaid((String)billPaidStatus)) {
            logger.info("billPaidStatus is paid");
            BankBillSyncStatusHelper.revertCasPayBill(transBill);
            TransBillHelper.revertPayAcceptanceBill((DynamicObject)transBill);
            DeductionPayHelper.revertDeductionBill((DynamicObject)transBill);
            transBill.set("paydate", null);
            transBill.set("bankcheckflag", (Object)"");
            transBill.set("settletnumber", (Object)"");
        }
        transBill.set("paidstatus", (Object)paidStatus);
        return transBill;
    }

    private DynamicObject transBillPaided(DynamicObject transBill, String paidStatus, String draftBillNo, Map<Long, Long> transBillTocasMap) {
        if (!TransBillPaidStatusEnum.isPaid((String)paidStatus)) {
            return null;
        }
        transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAID.getValue());
        transBill.set("paydate", (Object)transBill.getDate("bizdate"));
        TransBillHelper.writeDeDuctionPayAccStatus((DynamicObject)transBill);
        DynamicObject acceptBill = TransBillHelper.syncAcceptanceBill((DynamicObject)transBill);
        if (EmptyUtil.isNoEmpty((DynamicObject)acceptBill) && "cas_paybill".equals(acceptBill.getString("sourcebilltype"))) {
            transBillTocasMap.put(transBill.getLong("id"), acceptBill.getLong("sourcebillid"));
        }
        transBill.set("settletnumber", (Object)draftBillNo);
        return transBill;
    }

    private String checkUpdateLegal(DynamicObject transBill, TransBillUpdatePaidInfo info, Set<Long> paidTransIds) {
        if (EmptyUtil.isEmpty((DynamicObject)transBill)) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_6.loadKDString(info.getBizBillId());
        }
        String paidStatus = info.getPaidStatus();
        if (!(TransBillPaidStatusEnum.isPaying((String)paidStatus) || TransBillPaidStatusEnum.isPaid((String)paidStatus) || TransBillPaidStatusEnum.isWaiting((String)paidStatus))) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_4.loadKDString(paidStatus);
        }
        if (!BillStatusEnum.isAudit((String)transBill.getString("billstatus")) || !TransTypeEnum.isAgentPay((Object)transBill.getString("transtype"))) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_0.loadKDString();
        }
        String tranBillPaidStatus = transBill.getString("paidstatus");
        if (TransBillPaidStatusEnum.isRefused((String)tranBillPaidStatus) || TransBillPaidStatusEnum.isDrawback((String)tranBillPaidStatus) || TransBillPaidStatusEnum.isReturnTicket((String)tranBillPaidStatus)) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_1.loadKDString(TransBillPaidStatusEnum.getName((String)tranBillPaidStatus));
        }
        DynamicObject settleMent = transBill.getDynamicObject("settletype");
        if (EmptyUtil.isEmpty((DynamicObject)settleMent) || !SettleMentTypeEnum.isBankOrBusiness((String)settleMent.getString("settlementtype"))) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_2.loadKDString();
        }
        if (TransBillPaidStatusEnum.isPaid((String)tranBillPaidStatus) && !paidTransIds.contains(transBill.getLong("id")) && !TransBillPaidStatusEnum.isWaiting((String)paidStatus)) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_3.loadKDString();
        }
        DynamicObject cdmPayBill = QueryServiceHelper.queryOne((String)"cdm_payablebill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)transBill.getLong("id")).and("id", "!=", (Object)info.getBizBillId()).and("billstatus", "!=", (Object)"H")});
        if (EmptyUtil.isNoEmpty((DynamicObject)cdmPayBill)) {
            return IfmMseResourceEnum.TranBillCdmWritebackService_5.loadKDString(transBill.getString("billno"), cdmPayBill.getString("billno"));
        }
        return "";
    }

    private Set<Long> getPaidTransIds(DynamicObject[] transBills) {
        Set<Long> transIds = Arrays.stream(transBills).filter(o -> TransBillPaidStatusEnum.isPaid((String)o.getString("paidstatus"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(transIds)) {
            return transIds;
        }
        DynamicObjectCollection cdmPayBIlls = QueryServiceHelper.query((String)"cdm_payablebill", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", transIds).and("billstatus", "!=", (Object)"H")});
        return cdmPayBIlls.stream().map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
    }

    private void setFailMsg(List<TransBillUpdatePaidInfo> infos, String errorMsg) {
        for (TransBillUpdatePaidInfo info : infos) {
            info.setSuccess(false);
            info.setErrorMsg(errorMsg);
        }
    }
}

