/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntObjectUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(IntObjectUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                result.setLog("start upgrade intobject lastpreintdate");
                this.dataUpgrade();
                result.setLog("end upgrade intobject lastpreintdate");
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
            }
        }
        return result;
    }

    private void dataUpgrade() {
        String intObjectQuerySql = "select fid,fintobjectid from t_ifm_intobject where fbiztype = ? and flastpreintdate is null";
        Object[] queryParams = new Object[]{"Internal"};
        DataSet intObjectData = DB.queryDataSet((String)"IntObjectUpgradeService", (DBRoute)DBRouteConst.TMC, (String)intObjectQuerySql, (Object[])queryParams);
        if (intObjectData.isEmpty()) {
            return;
        }
        ArrayList<Long> bankAcctIds = new ArrayList<Long>();
        for (Row intObjectDatum : intObjectData.copy()) {
            bankAcctIds.add(intObjectDatum.getLong("fintobjectid"));
        }
        logger.info("bankAcctIds:{}", (Object)bankAcctIds.stream().map(String::valueOf).collect(Collectors.joining()));
        Map<Object, Date> innerAcctMap = this.getInnerAcctMap(bankAcctIds);
        if (null == innerAcctMap || innerAcctMap.size() == 0) {
            return;
        }
        String updateSql = "update t_ifm_intobject set flastpreintdate = ? where fid = ?;";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<String> intObjectIds = new ArrayList<String>();
        for (Row intObjectDatum : intObjectData) {
            Date lastPreIntDate = innerAcctMap.get(intObjectDatum.get("fintobjectid"));
            if (EmptyUtil.isEmpty((Object)lastPreIntDate)) continue;
            Object[] params = new Object[]{lastPreIntDate, intObjectDatum.getLong("fid")};
            paramsList.add(params);
            intObjectIds.add(intObjectDatum.getString("fid"));
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, paramsList);
        }
        logger.info("upgrade intobjectIds:{}", (Object)String.join((CharSequence)",", intObjectIds));
    }

    private Map<Object, Date> getInnerAcctMap(List<Long> bankAcctIds) {
        String querySql = "select fbankaccountnumber, fid from t_bd_accountbanks where fid in (%s)";
        StringJoiner sj = new StringJoiner(",");
        bankAcctIds.forEach(v -> sj.add(v.toString()));
        DataSet bankAcctDataSet = DB.queryDataSet((String)"getInnerAcctMap", (DBRoute)DBRouteConst.SYS, (String)String.format(querySql, sj.toString()));
        if (bankAcctDataSet.isEmpty()) {
            return null;
        }
        HashMap<String, Object> bankAcctMap = new HashMap<String, Object>();
        ArrayList<String> bankAcctNumbers = new ArrayList<String>();
        for (Row row : bankAcctDataSet) {
            String bankAcctNumber = row.getString("fbankaccountnumber");
            bankAcctNumbers.add(bankAcctNumber);
            bankAcctMap.put(bankAcctNumber, row.get("fid"));
        }
        querySql = "select fnumber,fendpreinstdate from t_ifm_inneracct where fnumber in (%s)";
        StringJoiner sjs = new StringJoiner(",");
        bankAcctNumbers.forEach(v -> sjs.add(String.format("'%s'", v)));
        DataSet innerAcctDataSet = DB.queryDataSet((String)"getInnerAcctMap", (DBRoute)DBRouteConst.TMC, (String)String.format(querySql, sjs));
        if (innerAcctDataSet.isEmpty()) {
            return null;
        }
        HashMap<Object, Date> innerAcctMap = new HashMap<Object, Date>();
        for (Row row : innerAcctDataSet) {
            Date endPreInstDate;
            Object bankAcctId = bankAcctMap.get(row.getString("fnumber"));
            if (EmptyUtil.isEmpty(bankAcctId) || EmptyUtil.isEmpty((Object)(endPreInstDate = row.getDate("fendpreinstdate")))) continue;
            innerAcctMap.put(bankAcctId, endPreInstDate);
        }
        return innerAcctMap;
    }
}

