/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountacceptance;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankCloseStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class AccountAcceptChangeHandleService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) {
        super.beforeCommit(dataEntities);
        Map allFields = MetadataServiceHelper.getDataEntityType((String)"ifm_inneracct").getAllFields();
        for (DynamicObject bizDeal : dataEntities) {
            Optional<Object> innerAcctOptional = Optional.ofNullable(bizDeal.getDynamicObject("accountbank")).map(r -> r.getDynamicObject("inneracct")).map(r -> r.getPkValue());
            if (!innerAcctOptional.isPresent()) continue;
            DynamicObject innerAccount = BusinessDataServiceHelper.loadSingle((Object)innerAcctOptional.get(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneracct"));
            DynamicObjectCollection modifyEntry = bizDeal.getDynamicObjectCollection("modifyentry");
            innerAccount.set("acctstatus", (Object)InnerAcctStatusEnum.NORMAL.getValue());
            innerAccount.set("changeuser", (Object)RequestContext.get().getCurrUserId());
            innerAccount.set("changedate", (Object)new Date());
            for (DynamicObject modify : modifyEntry) {
                Object changeFieldValue;
                String changeField = modify.getString("e_changefield");
                IDataEntityProperty prop = (IDataEntityProperty)allFields.get(changeField = InnerAcctHelper.switchProperty((String)changeField));
                if (prop instanceof BasedataProp) {
                    innerAccount.set(changeField, modify.get("e_basedata"));
                    continue;
                }
                if (prop instanceof MulBasedataProp) {
                    changeFieldValue = null;
                    if (StringUtils.equals((CharSequence)"currency", (CharSequence)changeField)) {
                        changeFieldValue = modify.getDynamicObjectCollection("e_currency");
                    } else if (StringUtils.equals((CharSequence)"settlementtype", (CharSequence)changeField)) {
                        changeFieldValue = modify.getDynamicObjectCollection("e_settlementtype");
                    }
                    if (changeFieldValue == null) continue;
                    DynamicObject[] collArray = (DynamicObject[])changeFieldValue.stream().map(row -> row.getDynamicObject("fbasedataid")).toArray(DynamicObject[]::new);
                    DynamicObjectCollection collMulti = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)innerAccount, (String)changeField, (DynamicObject[])collArray);
                    innerAccount.set(changeField, (Object)collMulti);
                    continue;
                }
                if (prop instanceof DateProp) {
                    changeFieldValue = modify.get("e_afterchange");
                    innerAccount.set(changeField, (Object)DateUtils.stringToDate((String)changeFieldValue.toString(), (String)"yyyy-MM-dd"));
                    continue;
                }
                if (!(prop instanceof ComboProp) && !(prop instanceof AmountProp) && !(prop instanceof TextProp) && !(prop instanceof IntegerProp)) continue;
                changeFieldValue = modify.get("e_afterchange");
                innerAccount.set(changeField, changeFieldValue);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("applyid", bizDeal.getPkValue().toString());
            option.setVariableValue("applybillno", bizDeal.getString("billno"));
            TmcOperateServiceHelper.execOperate((String)"update", (String)"ifm_inneracct", (DynamicObject[])new DynamicObject[]{innerAccount}, (OperateOption)option);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] changeApplyBills;
        super.afterProcess(dataEntities);
        Object[] sourceIds = Arrays.stream(dataEntities).map(r -> r.getLong("sourceid")).toArray();
        for (DynamicObject closeApplyBill : changeApplyBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_changeapply"))) {
            closeApplyBill.set("billstatus", (Object)BankCloseStatusEnum.COMPLETED.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"am_changeapply", (DynamicObject[])changeApplyBills, (OperateOption)OperateOption.create());
    }
}

