/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountacceptance;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankCloseStatusEnum;
import kd.tmc.fbp.common.enums.InnerAcctAcceptStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;

public class AccountAcceptCloseHandleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AccountAcceptCloseHandleService.class);

    public void process(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.ACCEPTED.getValue());
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) {
        super.beforeCommit(dataEntities);
        Map<Long, Date> accountBankDateMap = Arrays.stream(dataEntities).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("accountbank"))).collect(Collectors.toMap(o -> o.getDynamicObject("accountbank").getLong("id"), o -> o.getDate("closedate"), (v1, v2) -> v2));
        DynamicObject[] accountBanks = this.convertFieldDynamicObjectArray(dataEntities, "accountbank");
        Map<Long, Long> innerAccountIdToBankMap = Arrays.stream(accountBanks).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("inneracct"))).collect(Collectors.toMap(o -> o.getDynamicObject("inneracct").getLong("id"), o -> o.getLong("id"), (v1, v2) -> v2));
        DynamicObject[] innerAccounts = this.convertFieldDynamicObjectArray(accountBanks, "inneracct");
        for (DynamicObject innerAccount : innerAccounts = BusinessDataServiceHelper.load((Object[])this.mapPkValues(innerAccounts), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneracct"))) {
            innerAccount.set("acctstatus", (Object)InnerAcctStatusEnum.CLOSED.getValue());
            Long bankAccountId = innerAccountIdToBankMap.get(innerAccount.getLong("id"));
            Date closeDate = DateUtils.getCurrentDate();
            if (EmptyUtil.isNoEmpty((Long)bankAccountId) && EmptyUtil.isNoEmpty((Object)accountBankDateMap.get(bankAccountId))) {
                closeDate = accountBankDateMap.get(bankAccountId);
            }
            innerAccount.set("closedate", (Object)closeDate);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_inneracct", (DynamicObject[])innerAccounts, (OperateOption)OperateOption.create());
    }

    private DynamicObject[] convertFieldDynamicObjectArray(DynamicObject[] dataEntities, String field) {
        DynamicObject[] dynamicObject = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            dynamicObject[i] = dataEntities[i].getDynamicObject(field);
        }
        return dynamicObject;
    }

    private Long[] convertFieldLongArray(DynamicObject[] dataEntities, String field) {
        Long[] longs = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            longs[i] = dataEntities[i].getLong(field);
        }
        return longs;
    }

    public void afterProcess(DynamicObject[] dataEntities) {
        super.afterProcess(dataEntities);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.closeAccounts(dataEntities);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                txHandle.markRollback();
                this.rollbackData(dataEntities);
                throw e;
            }
        }
    }

    private void rollbackData(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.WAIT.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_accountacceptancebill", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create(), (boolean)true);
        DynamicObject[] accountBanks = this.convertFieldDynamicObjectArray(dataEntities, "accountbank");
        DynamicObject[] innerAccounts = this.convertFieldDynamicObjectArray(accountBanks, "inneracct");
        for (DynamicObject innerAccount : innerAccounts = BusinessDataServiceHelper.load((Object[])this.mapPkValues(innerAccounts), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_inneracct"))) {
            innerAccount.set("acctstatus", (Object)InnerAcctStatusEnum.CLOSING.getValue());
            innerAccount.set("closedate", null);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_inneracct", (DynamicObject[])innerAccounts, (OperateOption)OperateOption.create(), (boolean)true);
    }

    private void closeAccounts(DynamicObject[] dynamicObjects) {
        DynamicObject[] closeApplyBills;
        HashMap map = new HashMap(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("closedate", dynamicObject.getDate("closedate"));
            paramMap.put("closereason", dynamicObject.getString("closereason"));
            map.put((Long)dynamicObject.getDynamicObject("accountbank").getPkValue(), paramMap);
        }
        DynamicObject[] accountBanks = this.convertFieldDynamicObjectArray(dynamicObjects, "accountbank");
        for (DynamicObject accountBank : accountBanks = TmcDataServiceHelper.load((Object[])this.mapPkValues(accountBanks), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accountbank"))) {
            accountBank.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
            Map paramMap = (Map)map.get((Long)accountBank.getPkValue());
            accountBank.set("closedate", paramMap.get("closedate"));
            accountBank.set("closereason", paramMap.get("closereason"));
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("isneedvalidate", "false");
        TmcOperateServiceHelper.execOperate((String)"closeacct", (String)"am_accountbank", (DynamicObject[])accountBanks, (OperateOption)create);
        Object[] closeApplyBillIds = this.convertFieldLongArray(dynamicObjects, "sourceid");
        for (DynamicObject closeApplyBill : closeApplyBills = BusinessDataServiceHelper.load((Object[])closeApplyBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_acctclosebill"))) {
            closeApplyBill.set("billstatus", (Object)BankCloseStatusEnum.COMPLETED.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"innersave", (String)"am_acctclosebill", (DynamicObject[])closeApplyBills, (OperateOption)OperateOption.create());
    }

    private Long[] mapPkValues(DynamicObject[] dataEntities) {
        Long[] pkValues = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            pkValues[i] = (Long)dataEntities[i].getPkValue();
        }
        return pkValues;
    }
}

