/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountacceptance;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankOpenStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InnerAcctAcceptStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.InitInnerAcctBalanceHelper;

public class AccountAcceptOpenHandleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AccountAcceptOpenHandleService.class);

    public void process(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.ACCEPTED.getValue());
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) {
        super.beforeCommit(dataEntities);
        TmcOperateServiceHelper.execOperate((String)"pushandsave", (String)"ifm_accountacceptancebill", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
    }

    public void afterProcess(DynamicObject[] dataEntities) {
        boolean result;
        super.afterProcess(dataEntities);
        String name = dataEntities[0].getDataEntityType().getName();
        Set<Long> targetBills = this.getTargetBill(name, this.mapPkValues(dataEntities), "ifm_inneracct");
        try {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_inneracct", (Object[])targetBills.toArray(), (OperateOption)OperateOption.create());
            result = operationResult.isSuccess();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.rollbackData(dataEntities);
            throw e;
        }
        if (!result) {
            this.rollbackData(dataEntities);
            KDBizException kdBizException = new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)this.operationResult));
            logger.error((Throwable)kdBizException);
            throw kdBizException;
        }
        this.writeBack(dataEntities);
        InitInnerAcctBalanceHelper.saveAccountBalance((Long[])targetBills.toArray(new Long[0]));
    }

    private void writeBack(DynamicObject[] dataEntities) {
        DynamicObject[] sourceBills;
        Object[] sourceIds = Arrays.stream(dataEntities).map(d -> d.get("sourceid")).toArray(Object[]::new);
        for (DynamicObject dynamicObject : sourceBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accopenbill"))) {
            dynamicObject.set("billstatus", (Object)BankOpenStatusEnum.COMPLETED.getValue());
            Arrays.stream(dataEntities).forEach(d -> {
                if (Objects.equals(d.get("sourceid"), dynamicObject.getPkValue())) {
                    dynamicObject.set("bankaccountnumber", d.get("bankaccountnumber"));
                    dynamicObject.set("acctname", d.get("acctname"));
                    dynamicObject.set("englishname", d.get("englishname"));
                    dynamicObject.set("shortnumber", d.get("shortnumber"));
                    dynamicObject.set("acctstyle", d.get("acctstyle"));
                    dynamicObject.set("accttype", d.get("accttype"));
                    dynamicObject.set("acctproperty", d.get("acctproperty"));
                    dynamicObject.set("opendate", d.get("opendate"));
                }
            });
        }
        TmcOperateServiceHelper.execOperate((String)"innersave", (String)"am_accopenbill", (DynamicObject[])sourceBills, (OperateOption)OperateOption.create());
    }

    private void rollbackData(DynamicObject[] dataEntities) {
        String currEntity = dataEntities[0].getDataEntityType().getName();
        Set<Long> innerAcctBillIds = this.getTargetBill(currEntity, this.mapPkValues(dataEntities), "ifm_inneracct");
        if (!CollectionUtils.isEmpty(innerAcctBillIds)) {
            this.deleteAccountBanks(innerAcctBillIds);
            this.deleteInnerAccounts(innerAcctBillIds);
        }
        Object[] sourceIds = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            dataEntities[i].set("businessstatus", (Object)InnerAcctAcceptStatusEnum.WAIT.getValue());
            dataEntities[i].set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            sourceIds[i] = dataEntities[i].getLong("sourceid");
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)currEntity, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        DynamicObject[] openApplyBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accopenbill"));
        for (int i = 0; i < openApplyBills.length; ++i) {
            openApplyBills[i].set("billstatus", (Object)BankOpenStatusEnum.OPEN_DOING.getValue());
        }
        this.saveAmAccountApply(openApplyBills);
    }

    private void saveAmAccountApply(DynamicObject[] bills) {
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    private void deleteInnerAccounts(Set<Long> innerAcctBillIds) {
        if (!CollectionUtils.isEmpty(innerAcctBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_inneracct", (Object[])innerAcctBillIds.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private void deleteAccountBanks(Set<Long> innerAcctBillIds) {
        Set<Long> accountBankIds = this.getTargetBill("ifm_inneracct", innerAcctBillIds.toArray(new Long[0]), "am_accountbank");
        if (!CollectionUtils.isEmpty(accountBankIds)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isneedvalidate", String.valueOf(false));
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"am_accountbank", (Object[])accountBankIds.toArray(), (OperateOption)operateOption);
        }
    }

    public Set<Long> getTargetBill(String currEntity, Long[] currEntityIds, String targetEntityName) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])currEntityIds);
        return (Set)targetBills.get(targetEntityName);
    }

    private Long[] mapPkValues(DynamicObject[] dataEntities) {
        Long[] pkValues = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            pkValues[i] = (Long)dataEntities[i].getPkValue();
        }
        return pkValues;
    }

    public void handlerException(DynamicObject[] dataEntities) {
        super.handlerException(dataEntities);
        this.rollbackData(dataEntities);
    }
}

