/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountacceptance;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankCloseStatusEnum;
import kd.tmc.fbp.common.enums.BankOpenStatusEnum;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.enums.InnerAcctAcceptStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AccountAcceptanceBackService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Arrays.stream(dynamicObjects).forEach(d -> {
            d.set("bankaccountnumber", null);
            d.set("acctname", null);
            d.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.BACKED.getValue());
        });
        Object[] sourceIds = (Long[])Arrays.stream(dynamicObjects).map(d -> d.getLong("sourceid")).toArray(Long[]::new);
        DynamicObject[] openApplyBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_accopenbill"));
        DynamicObject[] closeApplyBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_acctclosebill"));
        DynamicObject[] changeApplyBills = BusinessDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_changeapply"));
        for (DynamicObject openApplyBill : openApplyBills) {
            openApplyBill.set("billstatus", (Object)BankOpenStatusEnum.BACK.getValue());
            openApplyBill.set("backreason", dynamicObjects[0].get("backreason"));
        }
        for (DynamicObject closeApplyBill : closeApplyBills) {
            closeApplyBill.set("billstatus", (Object)BankCloseStatusEnum.BACK.getValue());
            closeApplyBill.set("backreason", dynamicObjects[0].get("backreason"));
        }
        for (DynamicObject changeApplyBill : changeApplyBills) {
            changeApplyBill.set("billstatus", (Object)BankCloseStatusEnum.BACK.getValue());
        }
        if (openApplyBills.length > 0) {
            TmcOperateServiceHelper.execOperate((String)"innersave", (String)"am_accopenbill", (DynamicObject[])openApplyBills, (OperateOption)OperateOption.create(), (boolean)true);
        }
        if (closeApplyBills.length > 0) {
            TmcOperateServiceHelper.execOperate((String)"save", (String)"am_acctclosebill", (DynamicObject[])closeApplyBills, (OperateOption)OperateOption.create(), (boolean)true);
            this.updateBankAccountsStatus(dynamicObjects);
            this.updateInnerAcctStatus(dynamicObjects);
        }
        if (changeApplyBills.length > 0) {
            TmcOperateServiceHelper.execOperate((String)"save", (String)"am_changeapply", (DynamicObject[])changeApplyBills, (OperateOption)OperateOption.create(), (boolean)true);
            this.updateBankAcctStatus(dynamicObjects);
        }
    }

    private void updateBankAccountsStatus(DynamicObject[] dynamicObjects) {
        DynamicObject[] bdAccountBanks;
        A[] bdBankAccountIds = Arrays.stream(dynamicObjects).map(d -> d.getDynamicObject("accountbank").getPkValue()).toArray(Object[]::new);
        for (DynamicObject bankAccount : bdAccountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,acctstatus,inneracct", (QFilter[])new QFilter[]{new QFilter("id", "in", bdBankAccountIds)})) {
            bankAccount.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])bdAccountBanks);
        }
    }

    private void updateInnerAcctStatus(DynamicObject[] dynamicObjects) {
        DynamicObject[] innerAccts;
        Set innerAcctIds = Arrays.stream(dynamicObjects).map(r -> r.getDynamicObject("accountbank")).map(r -> r.getDynamicObject("inneracct")).map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(innerAcctIds)) {
            return;
        }
        for (DynamicObject innerAcct : innerAccts = TmcDataServiceHelper.load((String)"ifm_inneracct", (String)"id,acctstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", innerAcctIds)})) {
            innerAcct.set("acctstatus", (Object)BankAcctStatusEnum.NORMAL.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])innerAccts);
    }

    private void updateBankAcctStatus(DynamicObject[] dynamicObjects) {
        DynamicObject[] changeBills = (DynamicObject[])Arrays.stream(dynamicObjects).filter(r -> StringUtils.equals((CharSequence)BusinessTypeEnum.CHANGE.getValue(), (CharSequence)r.getString("businesstype"))).toArray(DynamicObject[]::new);
        this.updateInnerAcctStatus(changeBills);
        this.updateBankAccountsStatus(changeBills);
    }
}

