/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountacceptance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankChangeStatusEnum;
import kd.tmc.fbp.common.enums.BankCloseStatusEnum;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.enums.InnerAcctAcceptStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.accountacceptance.AccountAcceptCloseHandleService;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class AccountAcceptanceUnauditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AccountAcceptCloseHandleService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourceid");
        selector.add("modifyentry");
        selector.add("modifyentry.e_changefield");
        selector.add("modifyentry.e_afterchange");
        selector.add("modifyentry.e_basedata");
        selector.add("modifyentry.e_currency");
        selector.add("modifyentry.e_settlementtype");
        return selector;
    }

    public void process(DynamicObject[] bills) throws KDException {
        ArrayList<DynamicObject> openBills = new ArrayList<DynamicObject>(bills.length);
        ArrayList<DynamicObject> closeBills = new ArrayList<DynamicObject>(bills.length);
        ArrayList<DynamicObject> changeBills = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject billDO : bills) {
            String biztype = billDO.getString("businesstype");
            if (BusinessTypeEnum.OPEN.getValue().equals(biztype)) {
                openBills.add(billDO);
                continue;
            }
            if (BusinessTypeEnum.CLOSE.getValue().equals(biztype)) {
                closeBills.add(billDO);
                continue;
            }
            if (!BusinessTypeEnum.CHANGE.getValue().equals(biztype)) continue;
            changeBills.add(billDO);
        }
        this.handleOpenBills(openBills);
        this.handleCloseBills(closeBills);
        this.handleChangeBills(changeBills);
    }

    private void handleOpenBills(List<DynamicObject> openBills) {
        for (DynamicObject billDO : openBills) {
            DynamicObject pushedAcct = TmcBotpHelper.getTargetBill((String)"ifm_accountacceptancebill", (Object)billDO.getPkValue(), (String)"ifm_inneracct");
            if (pushedAcct != null) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_inneracct", (Object[])new Object[]{pushedAcct.getPkValue()}, (OperateOption)OperateOption.create());
            }
            billDO.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.WAIT.getValue());
        }
        this.updateAccountBankApply(openBills, "am_accopenbill", BankCloseStatusEnum.CLOSE_DOING.getValue());
    }

    private void handleCloseBills(List<DynamicObject> closeBills) {
        for (DynamicObject billDO : closeBills) {
            billDO.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.WAIT.getValue());
            DynamicObject accountBank = billDO.getDynamicObject("accountbank");
            DynamicObject innerAcct = accountBank.getDynamicObject("inneracct");
            OperateOption option = OperateOption.create();
            option.setVariableValue("fromacceptance", "Y");
            TmcOperateServiceHelper.execOperate((String)"unclose", (String)"ifm_inneracct", (Object[])new Object[]{innerAcct.getPkValue()}, (OperateOption)option);
        }
        this.updateAccountBankApply(closeBills, "am_acctclosebill", BankCloseStatusEnum.CLOSE_DOING.getValue());
    }

    private void updateAccountBankApply(List<DynamicObject> bills, String applyEntryName, String billStatus) {
        DynamicObject[] closeApplyBills;
        if (EmptyUtil.isEmpty(bills)) {
            return;
        }
        Set acctBankApplyIds = bills.stream().map(d -> d.getLong("sourceid")).collect(Collectors.toSet());
        for (DynamicObject closeApplyBill : closeApplyBills = BusinessDataServiceHelper.load((String)applyEntryName, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", acctBankApplyIds)})) {
            closeApplyBill.set("billstatus", (Object)billStatus);
        }
        try (TXHandle tx = TX.requiresNew((String)"updateAccountBankApply");){
            try {
                SaveServiceHelper.save((DynamicObject[])closeApplyBills);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void handleChangeBills(List<DynamicObject> changeBills) {
        DynamicObject[] changeApplyBills;
        ArrayList<DynamicObject> innerAccts = new ArrayList<DynamicObject>(changeBills.size());
        for (DynamicObject billDO : changeBills) {
            billDO.set("businessstatus", (Object)InnerAcctAcceptStatusEnum.WAIT.getValue());
            Optional<Object> innerAcctOptional = Optional.ofNullable(billDO.getDynamicObject("accountbank")).map(r -> r.getDynamicObject("inneracct")).map(r -> r.getPkValue());
            if (!innerAcctOptional.isPresent()) continue;
            DynamicObject latestInnerAcct = BillChangeHistoryHelper.genDelChangeHistory((Long)((Long)innerAcctOptional.get()), (String)"ifm_inneracct");
            DynamicObject dataBaseAcct = TmcDataServiceHelper.loadSingle((Object)innerAcctOptional.get(), (String)"ifm_inneracct");
            DynamicObjectCollection modifyEntry = billDO.getDynamicObjectCollection("modifyentry");
            Map allFields = MetadataServiceHelper.getDataEntityType((String)"ifm_inneracct").getAllFields();
            for (DynamicObject row : modifyEntry) {
                String changeField = row.getString("e_changefield");
                if (!allFields.containsKey(changeField = InnerAcctHelper.switchProperty((String)changeField))) continue;
                dataBaseAcct.set(changeField, latestInnerAcct.get(changeField));
            }
            innerAccts.add(dataBaseAcct);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isNeedInsertHistory", " false");
        TmcOperateServiceHelper.execOperate((String)"update", (String)"ifm_inneracct", (DynamicObject[])innerAccts.toArray(new DynamicObject[0]), (OperateOption)option, (boolean)true);
        List srcBillIds = changeBills.stream().map(r -> r.getLong("sourceid")).collect(Collectors.toList());
        for (DynamicObject changeApply : changeApplyBills = BusinessDataServiceHelper.load((Object[])srcBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_changeapply"))) {
            changeApply.set("billstatus", (Object)BankChangeStatusEnum.CHANGE_DOING.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"am_changeapply", (DynamicObject[])changeApplyBills, (OperateOption)OperateOption.create(), (boolean)true);
    }
}

