/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountfrozen;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.InnerAccountBalanceHelper;

public class InnerAccountFrozenAuditService
extends AbstractTmcBizOppService {
    private static final String SELECT_PROPERTIES = "id,acctstatus";
    private static final String ACCT_STATUS = "acctstatus";

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("frozenenddate");
        selector.add("account");
        selector.add("account.number");
        selector.add("account.acctstatus");
        selector.add("settlecenter");
        selector.add("applydate");
        selector.add("auditdate");
        selector.add("frozentype");
        selector.add("frozenamount");
        selector.add("totalfrozenamount");
        selector.add("frozenstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        block6: for (DynamicObject dataEntity : dataEntities) {
            DynamicObject innerAcct = dataEntity.getDynamicObject("account");
            String frozenType = dataEntity.getString("frozentype");
            BigDecimal frozenAmount = dataEntity.getBigDecimal("frozenamount");
            String accountNumber = innerAcct.getString("number");
            Long accountId = innerAcct.getLong("id");
            switch (InnerAccountFrozenTypeEnum.getByValue((String)frozenType)) {
                case ACCOUNT_FROZEN: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.FROZEN.getValue());
                    this.syncInnerAcctStatusForAudit(accountId, frozenType);
                    this.syncAccountBanksAcctStatusForAudit(accountNumber, frozenType);
                    continue block6;
                }
                case ACCOUNT_THAW: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.THAWED.getValue());
                    this.syncInnerAcctStatusForAudit(accountId, frozenType);
                    this.syncAccountBanksAcctStatusForAudit(accountNumber, frozenType);
                    continue block6;
                }
                case AMOUNT_FROZEN: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.FROZEN.getValue());
                    BigDecimal totalFrozenAmount = dataEntity.getBigDecimal("totalfrozenamount").add(frozenAmount);
                    dataEntity.set("totalfrozenamount", (Object)totalFrozenAmount);
                    continue block6;
                }
                case AMOUNT_THAW: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.THAWED.getValue());
                    BigDecimal totalFrozenAmount = dataEntity.getBigDecimal("totalfrozenamount").subtract(frozenAmount);
                    dataEntity.set("totalfrozenamount", (Object)totalFrozenAmount);
                    continue block6;
                }
            }
        }
    }

    private void syncInnerAcctStatusForAudit(Long accountId, String frozenType) {
        DynamicObject[] innerAccts = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountId)});
        if (InnerAccountFrozenTypeEnum.isAccountFrozen((String)frozenType)) {
            for (DynamicObject innerAcct : innerAccts) {
                innerAcct.set(ACCT_STATUS, (Object)InnerAcctStatusEnum.FROZEN.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])innerAccts);
        } else if (InnerAccountFrozenTypeEnum.isAccountThaw((String)frozenType)) {
            for (DynamicObject innerAcct : innerAccts) {
                innerAcct.set(ACCT_STATUS, (Object)InnerAcctStatusEnum.NORMAL.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])innerAccts);
        }
    }

    private void syncAccountBanksAcctStatusForAudit(String bankAccountNumber, String frozenType) {
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
        if (InnerAccountFrozenTypeEnum.isAccountFrozen((String)frozenType)) {
            for (DynamicObject accountBank : accountBanks) {
                accountBank.set(ACCT_STATUS, (Object)BankAcctStatusEnum.FREEZE.getValue());
            }
        } else if (InnerAccountFrozenTypeEnum.isAccountThaw((String)frozenType)) {
            for (DynamicObject accountBank : accountBanks) {
                accountBank.set(ACCT_STATUS, (Object)BankAcctStatusEnum.NORMAL.getValue());
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])accountBanks);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject innerAcct = dataEntity.getDynamicObject("account");
            InnerAccountBalanceHelper.updateValidBalanceByInnerAcctId((Long)innerAcct.getLong("id"), (Date)dataEntity.getDate("applydate"));
        }
    }
}

