/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountfrozen;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;

public class InnerAccountFrozenAutoThawService
extends AbstractTmcBizOppService {
    private static final String SELECT_PROPERTIES = "id,settlecenter,scorg,account,applydate,frozentype,frozenstatus,frozenamount,totalfrozenamount,currency,autothawbillid";
    private static final Log logger = LogFactory.getLog(InnerAccountFrozenAutoThawService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("settlecenter");
        selector.add("account");
        selector.add("account.acctstatus");
        selector.add("applydate");
        selector.add("frozentype");
        selector.add("frozenamount");
        selector.add("latestaccountblance");
        selector.add("totalfrozenamount");
        selector.add("frozenstatus");
        selector.add("billstatus");
        selector.add("billno");
        selector.add("scorg");
        selector.add("currency");
        selector.add("creator");
        selector.add("createtime");
        selector.add("modifier");
        selector.add("modifytime");
        selector.add("auditor");
        selector.add("auditdate");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        this.dealAutoThaw(Arrays.asList(dynamicObjects));
    }

    private void dealAutoThaw(List<DynamicObject> frozenInfoList) {
        DynamicObject[] accountFrozens;
        QFilter qFilter = new QFilter("frozentype", "in", (Object)InnerAccountFrozenTypeEnum.getFronzeTypes()).and("frozenenddate", ">=", (Object)DateUtils.getCurrentDate()).and("frozenstatus", "=", (Object)InnerAccountFrozenStatusEnum.FROZEN.getValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("autothawbillid", "=", (Object)0L);
        List ids = frozenInfoList.stream().map(b -> b.getLong("id")).collect(Collectors.toList());
        qFilter.and("id", "in", ids);
        block4: for (DynamicObject accountFrozen : accountFrozens = BusinessDataServiceHelper.load((String)"ifm_accountfrozen", (String)SELECT_PROPERTIES, (QFilter[])qFilter.toArray(), (String)"auditdate desc")) {
            DynamicObject accountFrozenObj;
            DynamicObject account = accountFrozen.getDynamicObject("account");
            InnerAccountFrozenTypeEnum frozenTypeEnum = InnerAccountFrozenTypeEnum.getByValue((String)accountFrozen.getString("frozentype"));
            switch (frozenTypeEnum) {
                case ACCOUNT_FROZEN: {
                    if (InnerAcctStatusEnum.isNormal((String)account.getString("acctstatus"))) continue block4;
                    accountFrozenObj = this.createAccountFrozenObj(accountFrozen, InnerAccountFrozenTypeEnum.ACCOUNT_THAW);
                    break;
                }
                case AMOUNT_FROZEN: {
                    accountFrozenObj = this.createAccountFrozenObj(accountFrozen, InnerAccountFrozenTypeEnum.AMOUNT_THAW);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (!this.auditAccountFrozen(accountFrozenObj)) continue;
            DynamicObject srcAccountFrozen = BusinessDataServiceHelper.loadSingle((Object)accountFrozen.getLong("id"), (String)"ifm_accountfrozen");
            srcAccountFrozen.set("autothawbillid", (Object)accountFrozenObj.getLong("id"));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{srcAccountFrozen});
        }
    }

    private DynamicObject createAccountFrozenObj(DynamicObject accountFrozen, InnerAccountFrozenTypeEnum frozenType) {
        DynamicObject dataEntity = TmcDataServiceHelper.newDynamicObject((String)"ifm_accountfrozen");
        dataEntity.set("id", (Object)DB.genLongId((String)"ifm_accountfrozen"));
        dataEntity.set("billno", (Object)CodeRuleHelper.generateNumber((String)"ifm_accountfrozen", (DynamicObject)dataEntity, null, null));
        dataEntity.set("settlecenter", (Object)accountFrozen.getDynamicObject("settlecenter"));
        dataEntity.set("scorg", (Object)accountFrozen.getDynamicObject("scorg"));
        dataEntity.set("account", (Object)accountFrozen.getDynamicObject("account"));
        dataEntity.set("applydate", (Object)accountFrozen.getDate("applydate"));
        dataEntity.set("frozentype", (Object)frozenType.getValue());
        dataEntity.set("frozenamount", (Object)accountFrozen.getBigDecimal("frozenamount"));
        dataEntity.set("totalfrozenamount", (Object)accountFrozen.getBigDecimal("totalfrozenamount"));
        dataEntity.set("currency", (Object)accountFrozen.getDynamicObject("currency"));
        Timestamp currentTime = DateUtils.getCurrentTime();
        long userId = RequestContext.get().getCurrUserId();
        dataEntity.set("creator", (Object)userId);
        dataEntity.set("createtime", (Object)currentTime);
        dataEntity.set("modifytime", (Object)currentTime);
        dataEntity.set("modifier", (Object)userId);
        dataEntity.set("auditor", (Object)userId);
        dataEntity.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        dataEntity.set("frozenreason", (Object)ResManager.loadKDString((String)"\u81ea\u52a8\u89e3\u51bb", (String)"InnerAccountFrozenAutoThawService_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        dataEntity.set("autothawbillid", (Object)accountFrozen.getLong("id"));
        return dataEntity;
    }

    private boolean auditAccountFrozen(DynamicObject accountFrozen) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("strictvalidation", Boolean.TRUE.toString());
        option.setVariableValue("WF", "TRUE");
        try {
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ifm_accountfrozen", (DynamicObject[])new DynamicObject[]{accountFrozen}, (OperateOption)option);
            return result.isSuccess();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }
}

