/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.accountfrozen;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAccountFrozenStatusEnum;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;

public class InnerAccountFrozenSaveService
extends AbstractTmcBizOppService {
    private static final String VAR_OPERATION = "operation";

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("frozenenddate");
        selector.add("account");
        selector.add("settlecenter");
        selector.add("applydate");
        selector.add("auditdate");
        selector.add("frozentype");
        selector.add("frozenamount");
        selector.add("totalfrozenamount");
        selector.add("frozenstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String operation = (String)this.getOperationVariable().get(VAR_OPERATION);
        block4: for (DynamicObject dataEntity : dataEntities) {
            String frozenType = dataEntity.getString("frozentype");
            InnerAccountFrozenTypeEnum frozenTypeEnum = InnerAccountFrozenTypeEnum.getByValue((String)frozenType);
            switch (frozenTypeEnum) {
                case ACCOUNT_FROZEN: 
                case AMOUNT_FROZEN: {
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.FREEZING.getValue());
                    continue block4;
                }
                case AMOUNT_THAW: 
                case ACCOUNT_THAW: {
                    if (EmptyUtil.isEmpty((String)operation)) {
                        dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.THAWING.getValue());
                        continue block4;
                    }
                    dataEntity.set("frozenstatus", (Object)InnerAccountFrozenStatusEnum.THAWED.getValue());
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }
}

