/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bankint.preint;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.BatchIntHelper;

public class BankBatchPreIntSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizdate");
        selector.add("entry");
        selector.add("inneracct");
        selector.add("sourceentryid");
        selector.add("interestamt");
        selector.add("currency");
        selector.add("company");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("intdays");
        selector.add("intdetail_tag");
        selector.add("inttype");
        selector.add("settlecenter");
        selector.add("org");
        selector.add("rate");
        selector.add("principle");
        selector.add("intbillid");
        selector.add("intcomment");
        selector.add("intdetailnum");
        selector.add("intobject");
        selector.add("intsource");
        selector.add("actualinstamt");
        selector.add("status");
        selector.add("biztype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            String batchNo = dataEntity.getString("billno");
            String bizType = dataEntity.getString("biztype");
            ArrayList intBillIds = new ArrayList(entry.size());
            this.pushBankPreIntBills(entry, batchNo, bizType, intBillIds);
            this.checkFail(intBillIds, dataEntity, entry);
        }
    }

    private void checkFail(List intBillIds, DynamicObject batchIntBill, DynamicObjectCollection batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)batchIntBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{batchIntBill}, (OperateOption)OperateOption.create(), (boolean)true);
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"BankBatchIntSubmitService_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void pushBankPreIntBills(DynamicObjectCollection entry, String batchNo, String bizType, List intBillIds) {
        OperationResult result = null;
        for (DynamicObject row : entry) {
            DynamicObject bankPreIntBill = BatchIntHelper.pushIntBill((DynamicObject)row, (String)batchNo, (String)bizType, (String)"ifm_preintbill_bank");
            try {
                result = TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_preintbill_bank", (DynamicObject[])new DynamicObject[]{bankPreIntBill}, (OperateOption)OperateOption.create());
            }
            catch (Exception e) {
                row.set("status", (Object)"fail");
                row.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5229\u606f\u5355\u751f\u6210\u5931\u8d25\uff1a%s", (String)"BankBatchIntSubmitService_1", (String)"tmc-ifm-business", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
            }
            if (result == null) {
                return;
            }
            Object intBillId = result.getSuccessPkIds().toArray()[0];
            intBillIds.add(intBillId);
        }
        BatchIntHelper.writeBackIntDetail((DynamicObjectCollection)entry, (List)intBillIds);
    }
}

