/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bankint.preint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankBatchPreIntUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("intbillid");
        selector.add("status");
        selector.add("intdetailnum");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.deleteIntDetails(dataEntities);
        this.clearIntDetail(dataEntities);
    }

    private void clearIntDetail(DynamicObject[] bankBatchIntBills) {
        for (DynamicObject bankBatchIntBill : bankBatchIntBills) {
            DynamicObjectCollection entry = bankBatchIntBill.getDynamicObjectCollection("entry");
            entry.forEach(row -> {
                row.set("intbillid", (Object)0);
                row.set("intdetailnum", (Object)"");
                row.set("status", (Object)"");
            });
        }
    }

    private void deleteIntDetails(DynamicObject[] dataEntities) {
        ArrayList intDetails = new ArrayList(16);
        for (DynamicObject bankBatchIntBill : dataEntities) {
            DynamicObjectCollection entry = bankBatchIntBill.getDynamicObjectCollection("entry");
            intDetails.addAll(entry.stream().map(v -> v.get("intbillid")).collect(Collectors.toList()));
        }
        if (EmptyUtil.isNoEmpty(intDetails)) {
            Object[] preInts = TmcDataServiceHelper.load((String)"ifm_preintbill_bank", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", intDetails)});
            if (EmptyUtil.isEmpty((Object[])preInts)) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("operatebybatch", "true");
            Object[] auditBillIds = Arrays.stream(preInts).filter(v -> StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())).map(DataEntityBase::getPkValue).toArray();
            Object[] submitBillIds = Arrays.stream(preInts).filter(v -> StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.SUBMIT.getValue())).map(DataEntityBase::getPkValue).toArray();
            if (EmptyUtil.isNoEmpty((Object[])auditBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"ifm_preintbill_bank", (Object[])auditBillIds, (OperateOption)operateOption);
            }
            if (EmptyUtil.isNoEmpty((Object[])submitBillIds)) {
                TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"ifm_preintbill_bank", (Object[])submitBillIds, (OperateOption)operateOption);
            }
            Object[] intBillIds = Arrays.stream(preInts).map(DataEntityBase::getPkValue).toArray();
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_preintbill_bank", (Object[])intBillIds, (OperateOption)operateOption);
        }
    }
}

