/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.bankint.writeoff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.BatchIntHelper;

public class BankPreIntWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("interestday");
        selector.add("begindate");
        selector.add("intobject");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.createWriteOffBill(dataEntities);
        BatchIntHelper.writeBackIntObject((DynamicObject[])dataEntities, (boolean)false, (boolean)true);
    }

    private void createWriteOffBill(DynamicObject[] bankPreInts) {
        Object[] preIntIds = Arrays.stream(bankPreInts).map(DataEntityBase::getPkValue).toArray();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bankPreInts[0].getDynamicObjectType().getName());
        DynamicObject[] preInts = TmcDataServiceHelper.load((Object[])preIntIds, (DynamicObjectType)entityType);
        ArrayList<DynamicObject> redWriteOffPreInt = new ArrayList<DynamicObject>(bankPreInts.length);
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject bankPreInt : preInts) {
            DynamicObject newPreInt = TmcDataServiceHelper.clone((DynamicObject)bankPreInt);
            newPreInt.set("billno", (Object)"");
            newPreInt.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            newPreInt.set("biztype", (Object)"reverseint");
            newPreInt.set("writeoffstatus", (Object)"red_writeoff");
            newPreInt.set("writeoffpreintbillid", bankPreInt.getPkValue());
            newPreInt.set("createtime", (Object)new Date());
            newPreInt.set("creator", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user"));
            newPreInt.set("billhead_lk", null);
            redWriteOffPreInt.add(newPreInt);
            bankPreInt.set("writeoffstatus", (Object)"red_writeoff");
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_preintbill_bank", (DynamicObject[])preInts, (OperateOption)OperateOption.create());
        TmcOperateServiceHelper.execOperate((String)"save", (String)"ifm_preintbill_bank", (DynamicObject[])redWriteOffPreInt.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }
}

