/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.deposit;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BizDealStatusEnum;
import kd.tmc.ifm.enums.DepositBizDealType;

public class DepositBizDealAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("bizstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Object> needPushBillIds = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject bizDealBill : dataEntities) {
            String applyType = bizDealBill.getString("applytype");
            if (StringUtils.equals((CharSequence)DepositBizDealType.REVENUE.getValue(), (CharSequence)applyType)) {
                this.confirmRevenue(bizDealBill);
                continue;
            }
            needPushBillIds.add(bizDealBill.getPkValue());
        }
        if (EmptyUtil.isNoEmpty(needPushBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"pushbizbill", (String)"ifm_bizdealbill_deposit", (Object[])needPushBillIds.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private void confirmRevenue(DynamicObject bizDealBill) {
        bizDealBill.set("bizstatus", (Object)BizDealStatusEnum.DEALED.getValue());
        DynamicObject dptRevenue = TmcBotpHelper.getSourceBill((String)bizDealBill.getDataEntityType().getName(), (Object)bizDealBill.getPkValue(), (String)"cim_dptrevenue");
        if (EmptyUtil.isNoEmpty((DynamicObject)dptRevenue)) {
            TmcOperateServiceHelper.execOperate((String)"confirm", (String)"cim_dptrevenue", (DynamicObject[])new DynamicObject[]{dptRevenue}, (OperateOption)OperateOption.create());
        }
    }
}

