/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.deposit;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BizDealStatusEnum;
import kd.tmc.ifm.enums.DepositBizDealType;
import kd.tmc.ifm.helper.DepositHelper;

public class DepositBizDealPushBizBillService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("apply");
        selector.add("investvarieties");
        selector.add("bizstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bizDealBill : dataEntities) {
            this.doPushBizBill(bizDealBill);
            bizDealBill.set("bizstatus", (Object)BizDealStatusEnum.DEALED.getValue());
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void doPushBizBill(DynamicObject bizDealBill) {
        String applyType = bizDealBill.getString("applytype");
        DynamicObject investVarieties = bizDealBill.getDynamicObject("investvarieties");
        boolean isFixed = InvestTypeEnum.isFixed((String)investVarieties.getString("investtype"));
        if (StringUtils.equals((CharSequence)DepositBizDealType.DEPOSIT.getValue(), (CharSequence)applyType)) {
            this.pushDeposit(bizDealBill, isFixed);
        } else if (StringUtils.equals((CharSequence)DepositBizDealType.RELEASE.getValue(), (CharSequence)applyType)) {
            this.pushRelease(bizDealBill, isFixed);
        }
        DepositHelper.writeBackApplyBill((DynamicObject[])new DynamicObject[]{bizDealBill}, (String)"handled");
    }

    private void pushDeposit(DynamicObject bizDealBill, boolean isFixed) {
        String operateKey = isFixed ? "pushandsavedpt" : "pushandsavenoticedpt";
        String cimDptName = isFixed ? "cim_deposit" : "cim_noticedeposit";
        String ifmDptName = isFixed ? "ifm_deposit" : "ifm_notice_deposit";
        Object bizDealId = bizDealBill.getPkValue();
        TmcOperateServiceHelper.execOperateNoTransaction((String)operateKey, (String)"ifm_bizdealbill_deposit", (Object[])new Object[]{bizDealId}, (OperateOption)OperateOption.create());
        DynamicObject innerDeposit = TmcBotpHelper.getTargetBill((String)"ifm_bizdealbill_deposit", (Object)bizDealId, (String)ifmDptName);
        if (EmptyUtil.isNoEmpty((DynamicObject)innerDeposit)) {
            DynamicObject applyBill = TmcBotpHelper.getSourceBill((String)"ifm_bizdealbill_deposit", (Object)bizDealId, (String)"cim_deposit_apply");
            TmcBotpHelper.saveRelation((String)"cim_deposit_apply", (Long)applyBill.getLong("id"), (String)cimDptName, (Long)innerDeposit.getLong("id"));
        }
    }

    private void pushRelease(DynamicObject bizDealBill, boolean isFixed) {
        String operateKey = isFixed ? "pushandsaverel" : "pushandsavenoticerel";
        TmcOperateServiceHelper.execOperateNoTransaction((String)operateKey, (String)"ifm_bizdealbill_deposit", (Object[])new Object[]{bizDealBill.getPkValue()}, (OperateOption)OperateOption.create());
    }
}

