/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.deposit;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.DepositHelper;

public class DepositBizDealSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("apply");
        selector.add("bizstatus");
        selector.add("isrevenue");
        selector.add("predictinstamt");
        selector.add("realrevenue");
        selector.add("entrys");
        selector.add("sourcebillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.writeBackApplyBill(dataEntities);
        DepositHelper.writeBackRevenueBill((DynamicObject[])dataEntities, (String)"waitconfirm");
        this.dealRevenueInfo(dataEntities);
    }

    private void writeBackApplyBill(DynamicObject[] dataEntities) {
        List<DynamicObject> needWriteBackBill = Arrays.stream(dataEntities).filter(v -> !StringUtils.equals((CharSequence)v.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue()) && StringUtils.equals((CharSequence)v.getString("bizstatus"), (CharSequence)"A")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(needWriteBackBill)) {
            DepositHelper.writeBackApplyBill((DynamicObject[])needWriteBackBill.toArray(new DynamicObject[0]), (String)"handing");
        }
    }

    private void dealRevenueInfo(DynamicObject[] dataEntities) {
        for (DynamicObject depositDealBill : dataEntities) {
            String applyType = depositDealBill.getString("applytype");
            if (!StringUtils.equals((CharSequence)applyType, (CharSequence)"deposit")) continue;
            depositDealBill.set("isrevenue", (Object)false);
        }
        DepositHelper.clearRevenueInfo((DynamicObject[])dataEntities);
    }
}

