/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.deposit;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.BizDealStatusEnum;
import kd.tmc.ifm.helper.DepositHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DepositBizDealUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("apply");
        selector.add("applytype");
        selector.add("investvarieties");
        selector.add("sourcebillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bizDealBill : dataEntities) {
            this.deleteBizBill(bizDealBill);
            this.cancelRevenue(bizDealBill);
            bizDealBill.set("bizstatus", (Object)BizDealStatusEnum.UNDEAL.getValue());
        }
        DepositHelper.writeBackApplyBill((DynamicObject[])dataEntities, (String)"handing");
    }

    private void deleteBizBill(DynamicObject bizDealBill) {
        Pair<String, String> entityNamePair = this.getEntityNamePair(bizDealBill);
        if (null == entityNamePair) {
            return;
        }
        String entityName = (String)entityNamePair.getLeft();
        DynamicObject targetBill = TmcBotpHelper.getTargetBill((String)"ifm_bizdealbill_deposit", (Object)bizDealBill.getPkValue(), (String)entityName);
        if (EmptyUtil.isEmpty((DynamicObject)targetBill)) {
            return;
        }
        String billStatus = targetBill.getString("billstatus");
        OperateOption operateOption = OperateOption.create();
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])new Object[]{targetBill.getPkValue()}, (OperateOption)operateOption);
        } else if (StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.SUBMIT.getValue())) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])new Object[]{targetBill.getPkValue()}, (OperateOption)operateOption);
        }
        TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])new Object[]{targetBill.getPkValue()}, (OperateOption)operateOption);
        this.deleteOtherSideBotp(bizDealBill.getString("sourcebillno"), (String)entityNamePair.getRight(), targetBill.getLong("id"));
    }

    private void deleteOtherSideBotp(String sourceBillNo, String entityName, Long id) {
        if (EmptyUtil.isEmpty((String)sourceBillNo)) {
            return;
        }
        DynamicObject applyBill = TmcDataServiceHelper.loadSingle((String)"cim_deposit_apply", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)sourceBillNo)});
        if (EmptyUtil.isNoEmpty((DynamicObject)applyBill)) {
            TmcBotpHelper.deleteRation((String)entityName, (Long)applyBill.getLong("id"), (Long)id);
        }
    }

    private void cancelRevenue(DynamicObject bizDealBill) {
        DynamicObject dptRevenue = TmcBotpHelper.getSourceBill((String)bizDealBill.getDataEntityType().getName(), (Object)bizDealBill.getPkValue(), (String)"cim_dptrevenue");
        if (EmptyUtil.isNoEmpty((DynamicObject)dptRevenue)) {
            TmcOperateServiceHelper.execOperate((String)"cancelconfirm", (String)"cim_dptrevenue", (DynamicObject[])new DynamicObject[]{dptRevenue}, (OperateOption)OperateOption.create());
        }
    }

    private Pair<String, String> getEntityNamePair(DynamicObject bizDealBill) {
        String applyType = bizDealBill.getString("applytype");
        String investType = bizDealBill.getDynamicObject("investvarieties").getString("investtype");
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"deposit") && InvestTypeEnum.isFixed((String)investType)) {
            return Pair.of((Object)"ifm_deposit", (Object)"cim_deposit");
        }
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"deposit") && InvestTypeEnum.isNotice((String)investType)) {
            return Pair.of((Object)"ifm_notice_deposit", (Object)"cim_noticedeposit");
        }
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"release") && InvestTypeEnum.isFixed((String)investType)) {
            return Pair.of((Object)"ifm_release", (Object)"cim_release");
        }
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"release") && InvestTypeEnum.isNotice((String)investType)) {
            return Pair.of((Object)"ifm_notice_release", (Object)"cim_noticerelease");
        }
        return null;
    }
}

