/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.exrate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.TransBillHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ExchangeRateService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            BigDecimal localAmt;
            Map operVars = this.getOperationVariable();
            DynamicObject baseCurrency = dataEntity.getDynamicObject("basecurrency");
            String baseCurrencyId = (String)operVars.get("basecurrency");
            if (EmptyUtil.isEmpty((DynamicObject)baseCurrency) && EmptyUtil.isNoEmpty((String)baseCurrencyId)) {
                baseCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(baseCurrencyId), (String)"bd_currency");
                dataEntity.set("basecurrency", (Object)baseCurrency);
            }
            DynamicObject exTabel = dataEntity.getDynamicObject("exratetable");
            String exrateTable = (String)operVars.get("exratetable");
            if (EmptyUtil.isEmpty((DynamicObject)exTabel) && EmptyUtil.isNoEmpty((String)exrateTable)) {
                exTabel = TmcDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(exrateTable), (String)"bd_exratetable");
                dataEntity.set("exratetable", (Object)exTabel);
            }
            BigDecimal exRate = dataEntity.getBigDecimal("exrate");
            String quotaTion = dataEntity.getString("quotation");
            String currencyProp = "currency";
            String actpayamt = "actpayamt";
            Map<String, Pair<String, String>> propMaps = this.getPropMaps();
            Pair<String, String> props = propMaps.get(dataEntity.getDynamicObjectType().getName());
            if (props != null) {
                currencyProp = (String)props.getLeft();
                actpayamt = (String)props.getRight();
            }
            DynamicObject currency = dataEntity.getDynamicObject(currencyProp);
            BigDecimal actAmt = dataEntity.getBigDecimal(actpayamt);
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, baseCurrency}) && currency.getPkValue().equals(baseCurrency.getPkValue())) {
                dataEntity.set("exrate", (Object)BigDecimal.ONE);
                dataEntity.set("quotation", (Object)"0");
                dataEntity.set("localamt", (Object)actAmt);
                continue;
            }
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRate, quotaTion})) {
                String exrate = (String)operVars.get("exrate");
                dataEntity.set("exrate", EmptyUtil.isEmpty((String)exrate) ? BigDecimal.ONE : exrate);
                dataEntity.set("quotation", operVars.get("quotation"));
            }
            if (!EmptyUtil.isEmpty((BigDecimal)(localAmt = dataEntity.getBigDecimal("localamt"))) || !EmptyUtil.isNoEmpty((DynamicObject)baseCurrency)) continue;
            localAmt = TransBillHelper.getLocalAmt((BigDecimal)actAmt, (BigDecimal)dataEntity.getBigDecimal("exrate"), (String)dataEntity.getString("quotation"), (int)baseCurrency.getInt("amtprecision"));
            dataEntity.set("localamt", (Object)localAmt);
        }
    }

    private Map<String, Pair<String, String>> getPropMaps() {
        HashMap<String, Pair<String, String>> propMaps = new HashMap<String, Pair<String, String>>();
        propMaps.put("ifm_deduction", Pair.of((Object)"receivecurrency", (Object)"receiveamount"));
        propMaps.put("ifm_rectransbill", Pair.of((Object)"currency", (Object)"actrecamt"));
        return propMaps;
    }
}

