/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class InnerAcctAuthService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            data.set("authquerpt", (Object)true);
            data.set("modifier", (Object)RequestContext.get().getCurrUserId());
            data.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        this.updateBankAccount(dataEntities);
    }

    private void updateBankAccount(DynamicObject[] dataEntities) {
        DynamicObject[] accountBanks;
        List pkValues = Arrays.stream(dataEntities).map(d -> d.getLong("id")).collect(Collectors.toList());
        for (DynamicObject accountBank : accountBanks = BusinessDataServiceHelper.load((String)"am_accountbank", (String)String.join((CharSequence)",", "authquerpt", "modifier", "modifytime"), (QFilter[])new QFilter("inneracct", "in", pkValues).toArray())) {
            accountBank.set("authquerpt", (Object)true);
            accountBank.set("modifier", (Object)RequestContext.get().getCurrUserId());
            accountBank.set("modifytime", (Object)new Date());
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])accountBanks);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }
}

