/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class InnerAcctCloseService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("acctstatus");
        list.add("closereason");
        list.add("closedate");
        list.add("relationacc");
        return list;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map operationVariable = this.getOperationVariable();
        String closeReason = (String)operationVariable.get("closereason");
        Date closeDate = null;
        if (operationVariable.get("closedate") != null) {
            closeDate = DateUtils.stringToDate((String)((String)operationVariable.get("closedate")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        for (DynamicObject data : dataEntities) {
            data.set("acctstatus", (Object)InnerAcctStatusEnum.CLOSED.getValue());
            data.set("closereason", (Object)closeReason);
            data.set("closedate", (Object)closeDate);
            data.set("relationacc", null);
        }
        this.closeBankAccount(dataEntities, closeReason, closeDate);
    }

    private void closeBankAccount(DynamicObject[] dataEntities, String closeReason, Date closeDate) {
        List pkValues = Arrays.stream(dataEntities).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
        InnerAcctHelper.updateIntObjectStatus(pkValues, (BaseEnableEnum)BaseEnableEnum.DISABLE);
        DynamicObjectCollection accountBanks = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter("inneracct", "in", pkValues).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)accountBanks)) {
            return;
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("isneedvalidate", "false");
        create.setVariableValue("closereason", closeReason);
        if (EmptyUtil.isEmpty((Object)closeDate)) {
            closeDate = DateUtils.getCurrentTime();
        }
        create.setVariableValue("closedate", DateUtils.formatString((Date)closeDate, (String)"yyyy-MM-dd HH:mm:ss"));
        TmcOperateServiceHelper.execOperate((String)"closeacct", (String)"am_accountbank", (Object[])accountBanks.stream().map(o -> o.getLong("id")).toArray(), (OperateOption)create, (boolean)true);
    }
}

