/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.InitInnerAcctBalanceHelper;

public class InnerAcctDoSaveService
extends AbstractTmcBizOppService {
    private DynamicObject[] cloneDataEntities = null;
    private boolean isSuccess;

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.cloneDataEntities = new DynamicObject[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            this.cloneDataEntities[i] = this.genCloneDataEntities(dataEntities[i]);
        }
        this.operationResult = TmcOperateServiceHelper.execOperate((String)"directsave", (String)"ifm_inneracct", (DynamicObject[])this.cloneDataEntities, (OperateOption)OperateOption.create());
    }

    private DynamicObject genCloneDataEntities(DynamicObject dataEntity) {
        DynamicObject clone = TmcDataServiceHelper.clone((DynamicObject)dataEntity);
        clone.set("id", (Object)DB.genLongId((String)"t_ifm_inneracct"));
        return clone;
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        if (this.cloneDataEntities == null) {
            return;
        }
        Object[] pkValues = Arrays.stream(this.cloneDataEntities).map(DataEntityBase::getPkValue).toArray(Object[]::new);
        try {
            this.operationResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_inneracct", (Object[])pkValues, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            this.deleteInnerAccounts(pkValues);
            throw e;
        }
        if (!this.operationResult.isSuccess()) {
            this.deleteInnerAccounts(pkValues);
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)this.operationResult));
        }
        Long[] longs = (Long[])Arrays.stream(this.cloneDataEntities).map(d -> (Long)d.getPkValue()).toArray(Long[]::new);
        InitInnerAcctBalanceHelper.saveAccountBalance((Long[])longs);
        this.isSuccess = true;
    }

    private void deleteInnerAccounts(Object[] pkValues) {
        TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_inneracct", (Object[])pkValues, (OperateOption)OperateOption.create());
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        if (this.isSuccess) {
            e.setSuccessPkIds(Arrays.stream(this.cloneDataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
    }
}

