/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.InitInnerAcctBalanceHelper;

public class InnerAcctImportSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("finorg");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object[] finOrgIds = (Long[])Arrays.stream(dataEntities).map(d -> (Long)d.getDynamicObject("finorg").getPkValue()).toArray(Long[]::new);
        DynamicObject[] openBanks = BusinessDataServiceHelper.load((Object[])finOrgIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
        for (DynamicObject dataEntity : dataEntities) {
            Optional<DynamicObject> finOrgOptional = Arrays.stream(openBanks).filter(o -> dataEntity.getDynamicObject("finorg").getPkValue().equals(o.getPkValue())).findFirst();
            finOrgOptional.ifPresent(dynamicObject -> dataEntity.set("org", (Object)dynamicObject.getDynamicObject("org")));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Object[] pkValues = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(Object[]::new);
        try {
            this.operationResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_inneracct", (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_inneracct", (Object[])pkValues, (OperateOption)OperateOption.create());
            throw e;
        }
        if (this.operationResult.isSuccess()) {
            Long[] longs = (Long[])Arrays.stream(dataEntities).map(d -> (Long)d.getPkValue()).toArray(Long[]::new);
            InitInnerAcctBalanceHelper.saveAccountBalance((Long[])longs);
        } else {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_inneracct", (Object[])pkValues, (OperateOption)OperateOption.create());
        }
    }
}

