/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class InnerAcctIscSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("name");
        selector.add("open_date");
        selector.add("mgrstratg");
        selector.add("currency_mgrfee");
        selector.add("mgrfee");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) {
        Object[] finOrgIds = (Long[])Arrays.stream(dataEntities).map(d -> (Long)d.getDynamicObject("finorg").getPkValue()).toArray(Long[]::new);
        DynamicObject[] openBanks = BusinessDataServiceHelper.load((Object[])finOrgIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
        for (DynamicObject dataEntity : dataEntities) {
            Optional<DynamicObject> finOrgOptional = Arrays.stream(openBanks).filter(o -> dataEntity.getDynamicObject("finorg").getPkValue().equals(o.getPkValue())).findFirst();
            finOrgOptional.ifPresent(finOrg -> dataEntity.set("org", (Object)finOrg.getDynamicObject("org")));
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        ArrayList<Long> toPushAcctIds = new ArrayList<Long>(5);
        for (DynamicObject dataEntity : dataEntities) {
            boolean isFromDB = TmcDataServiceHelper.isFromDatabase((DynamicObject)dataEntity);
            Long innerAcctId = dataEntity.getLong("id");
            if (isFromDB) {
                QFilter bankAcctQF = new QFilter("inneracct.id", "=", (Object)innerAcctId);
                if (TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])bankAcctQF.toArray())) continue;
                toPushAcctIds.add(innerAcctId);
                continue;
            }
            toPushAcctIds.add(innerAcctId);
        }
        if (toPushAcctIds.size() > 0) {
            DynamicObject[] acctBanks = TmcBotpHelper.batchPush((Object[])toPushAcctIds.toArray(), (String)"ifm_inneracct", (String)"am_accountbank");
            TmcOperateServiceHelper.execOperate((String)"save", (String)"am_accountbank", (DynamicObject[])acctBanks, (OperateOption)OperateOption.create(), (boolean)true);
        }
        for (DynamicObject dataEntity : dataEntities) {
            if (toPushAcctIds.contains(dataEntity.getLong("id"))) continue;
            InnerAcctHelper.updateBankAcct((DynamicObject)dataEntity, (Map)this.getOperationVariable());
        }
    }
}

