/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.inneracct;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class InnerAcctUpdateService
extends AbstractTmcBizOppService {
    private static final List<String> IGNOR_FIELD_ARR = Arrays.asList("creator", "createtime", "modifier", "modifytime");

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            boolean isFromDb = TmcDataServiceHelper.isFromDatabase((DynamicObject)dataEntity);
            boolean isdrawobject = dataEntity.getBoolean("isdrawobject");
            if (!isFromDb) continue;
            this.dealHistoryVersion(dataEntity);
            InnerAcctHelper.updateBankAcct((DynamicObject)dataEntity, (Map)this.getOperationVariable());
            if (!isdrawobject) continue;
            QFilter qFilter = new QFilter("intobject", "=", dataEntity.getPkValue());
            DynamicObject intobject = BusinessDataServiceHelper.loadSingle((String)"ifm_intobject", (String)String.join((CharSequence)",", "id", "name", "number"), (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObject)intobject)) continue;
            intobject.set("name", (Object)dataEntity.getString("name"));
            intobject.set("number", (Object)dataEntity.getString("number"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{intobject});
        }
    }

    private boolean isHasColumnCHanged(DynamicObject dataEntity, DynamicObject oldInnerAcct) {
        boolean isChange = false;
        Map allFields = MetadataServiceHelper.getDataEntityType((String)"ifm_inneracct").getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            String newVal;
            String field = (String)entry.getKey();
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
            Set fieldSet = properties.stream().map(r -> r.getName()).collect(Collectors.toSet());
            if (!fieldSet.contains(field) || IGNOR_FIELD_ARR.contains(field)) continue;
            if (prop instanceof ComboProp || prop instanceof TextProp) {
                String oldVal = Optional.ofNullable(oldInnerAcct.getString(field)).orElse("");
                if (oldVal.equals(newVal = Optional.ofNullable(dataEntity.getString(field)).orElse(""))) continue;
                isChange = true;
                break;
            }
            if (prop instanceof MulBasedataProp) {
                DynamicObjectCollection oldCols = oldInnerAcct.getDynamicObjectCollection(field);
                DynamicObjectCollection newCols = dataEntity.getDynamicObjectCollection(field);
                List oldList = oldCols.stream().map(r -> r.getDynamicObject("fbasedataid")).map(r -> r.getString("id")).collect(Collectors.toList());
                List newList = newCols.stream().map(r -> r.getDynamicObject("fbasedataid")).map(r -> r.getString("id")).collect(Collectors.toList());
                oldList.sort(Comparator.comparing(String::hashCode));
                newList.sort(Comparator.comparing(String::hashCode));
                if (oldList.toString().equals(newList.toString())) continue;
                isChange = true;
                break;
            }
            if (prop instanceof DateProp) {
                Date oldDate = oldInnerAcct.getDate(field);
                Date newDate = dataEntity.getDate(field);
                if (!(EmptyUtil.isEmpty((Object)oldDate) && EmptyUtil.isNoEmpty((Object)newDate) || EmptyUtil.isEmpty((Object)newDate) && EmptyUtil.isNoEmpty((Object)oldDate)) && (!EmptyUtil.isNoEmpty((Object)oldDate) || !EmptyUtil.isNoEmpty((Object)newDate) || oldDate.compareTo(newDate) == 0)) continue;
                isChange = true;
                break;
            }
            if (prop instanceof BasedataProp) {
                long newId;
                long oldId = Optional.ofNullable(oldInnerAcct.getDynamicObject(field)).map(r -> r.getLong("id")).orElse(0L);
                if (oldId == (newId = Optional.ofNullable(dataEntity.getDynamicObject(field)).map(r -> r.getLong("id")).orElse(0L).longValue())) continue;
                isChange = true;
                break;
            }
            if (prop instanceof DecimalProp) {
                String oldVal = Optional.ofNullable(oldInnerAcct.get(field)).map(r -> String.valueOf(r)).orElse("");
                if (oldVal.equals(newVal = Optional.ofNullable(dataEntity.get(field)).map(r -> String.valueOf(r)).orElse(""))) continue;
                isChange = true;
                break;
            }
            if (dataEntity.get(field) == oldInnerAcct.get(field)) continue;
            isChange = true;
            break;
        }
        return isChange;
    }

    private void dealHistoryVersion(DynamicObject dataEntity) {
        Map variableMap = this.getOperationVariable();
        if (variableMap.containsKey("isNeedInsertHistory")) {
            dataEntity.set("acctstatus", (Object)InnerAcctStatusEnum.CHANGING.getValue());
        } else if (variableMap.containsKey("applyid")) {
            DynamicObject oldInnerAcct = TmcDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)dataEntity.getDynamicObjectType().getName());
            oldInnerAcct.set("acctstatus", (Object)InnerAcctStatusEnum.NORMAL.getValue());
            this.setChangeUse(oldInnerAcct);
            BillChangeHistoryHelper.addChangeHistory((Long)Long.valueOf((String)variableMap.get("applyid")), (String)"ifm_accountacceptancebill", (String)((String)variableMap.get("applybillno")), (String)"", (String)"IN", (DynamicObject)oldInnerAcct);
        } else {
            DynamicObject oldInnerAcct = TmcDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)dataEntity.getDynamicObjectType().getName());
            if (this.isHasColumnCHanged(dataEntity, oldInnerAcct)) {
                this.setChangeUse(oldInnerAcct);
                BillChangeHistoryHelper.addChangeHistory(null, (String)"", (String)"", (String)"", (String)"IN", (DynamicObject)oldInnerAcct);
            }
        }
    }

    private void setChangeUse(DynamicObject innerAcct) {
        DynamicObject user = TmcDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        innerAcct.set("changeuser", (Object)user);
        innerAcct.set("changedate", (Object)new Date());
    }
}

