/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.interest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.IntSourceEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;
import kd.tmc.ifm.mservice.consistency.bean.IfmConsistencyInfo;
import kd.tmc.ifm.mservice.consistency.callback.PushCasBillDtxCallback;
import kd.tmc.ifm.mservice.consistency.helper.IfmConsistencyServiceHelper;

public class CurrentIntBillAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("intobject");
        selector.add("settlecenter");
        selector.add("biztype");
        selector.add("actualinstamt");
        selector.add("org");
        selector.add("intsource");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        ArrayList<DynamicObject> autoPushBills = new ArrayList<DynamicObject>();
        for (DynamicObject currentIntBill : dataEntities) {
            if (!CurrentBizTypeEnum.isCurrentInt((String)currentIntBill.getString("biztype"))) continue;
            SettleIntWriteOffHelper.writeBackIntObjectIntDay((DynamicObject)currentIntBill);
            SettleIntWriteOffHelper.autoWriteOff((DynamicObject)currentIntBill);
            String intSource = currentIntBill.getString("intsource");
            if (!IntSourceEnum.isInnerAcct((String)intSource)) continue;
            autoPushBills.add(currentIntBill);
        }
        if (EmptyUtil.isNoEmpty(autoPushBills)) {
            this.doAutoPush(autoPushBills);
        }
    }

    private void doAutoPush(List<DynamicObject> currentIntBills) {
        Object[] ids = currentIntBills.stream().map(DataEntityBase::getPkValue).toArray();
        TmcOperateServiceHelper.execOperate((String)"pushandsave", (String)"ifm_currentintbill", (Object[])ids, (OperateOption)OperateOption.create());
        List billIds = currentIntBills.stream().filter(this::isPushRecBill).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(billIds)) {
            IfmConsistencyInfo consistencyInfo = IfmConsistencyInfo.build((String)"currentInst_autoPush", (String)"currentIntPushRecService", billIds).setCallback((DTXCallback)new PushCasBillDtxCallback());
            IfmConsistencyServiceHelper.asyncPush((IfmConsistencyInfo)consistencyInfo);
        }
    }

    private boolean isPushRecBill(DynamicObject currentIntBill) {
        DynamicObject org = currentIntBill.getDynamicObject("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.FS.getId(), (long)org.getLong("id"), (String)"fs001");
        }
        return false;
    }
}

