/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.loancontract;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractBotpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sl = super.getSelector();
        sl.add("bizdealno");
        sl.add("loanapply");
        return sl;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        block14: for (DynamicObject bill : dataEntities) {
            String entityName;
            switch (entityName = bill.getDataEntityType().getName()) {
                case "ifm_loancontractbill": {
                    this.genLoanContractBillRelation(bill);
                    continue block14;
                }
                case "ifm_loanbill": {
                    this.genLoanBillRelation(bill);
                    continue block14;
                }
                case "ifm_contractextendbill": {
                    this.genExtendBillRelation(bill);
                    continue block14;
                }
                case "ifm_repaymentbill": {
                    this.genRepayBillRelation(bill);
                    continue block14;
                }
                case "ifm_interestbill": {
                    this.genInterestBillRelation(bill);
                }
            }
        }
    }

    private void genLoanContractBillRelation(DynamicObject loanContractBill) {
        DynamicObject loanApply = loanContractBill.getDynamicObject("loanapply");
        if (EmptyUtil.isNoEmpty((DynamicObject)loanApply)) {
            Long loanContractId = loanContractBill.getLong("id");
            this.genRelation("cfm_loan_apply", loanApply.getLong("id"), "cfm_loancontractbill", loanContractId);
        }
    }

    private void genExtendBillRelation(DynamicObject extendBill) {
        Long contractId = extendBill.getLong("sourcebillid");
        Long extendBillId = extendBill.getLong("id");
        if (EmptyUtil.isNoEmpty((String)extendBill.getString("bizdealno"))) {
            this.genRelation("ifm_loancontractbill", contractId, "ifm_contractextendbill", extendBillId);
        } else {
            this.genRelation("cfm_loancontractbill", contractId, "cfm_loancontractbill", extendBillId);
        }
    }

    private void genLoanBillRelation(DynamicObject loanBill) {
        Long loanContractId = loanBill.getLong("sourcebillid");
        Long loanBillId = loanBill.getLong("id");
        if (EmptyUtil.isNoEmpty((String)loanBill.getString("bizdealno"))) {
            this.genRelation("ifm_loancontractbill", loanContractId, "ifm_loanbill", loanBillId);
        } else {
            this.genRelation("cfm_loancontractbill", loanContractId, "cfm_loanbill", loanBillId);
        }
    }

    private void genRepayBillRelation(DynamicObject RepayBill) {
        Long repayBillId = RepayBill.getLong("id");
        DynamicObject repayBill = TmcDataServiceHelper.loadSingle((Object)repayBillId, (String)"cfm_repaymentbill");
        DynamicObjectCollection entrys = repayBill.getDynamicObjectCollection("loans");
        List loanBillIds = entrys.stream().map(o -> o.getDynamicObject("e_loanbill").getLong("id")).collect(Collectors.toList());
        for (Long loanBillId : loanBillIds) {
            if (EmptyUtil.isNoEmpty((String)RepayBill.getString("bizdealno"))) {
                this.genRelation("ifm_loanbill", loanBillId, "ifm_repaymentbill", repayBillId);
                continue;
            }
            this.genRelation("cfm_loanbill", loanBillId, "cfm_repaymentbill", repayBillId);
        }
    }

    private void genInterestBillRelation(DynamicObject interestBill) {
        Long loanBillId = interestBill.getLong("sourcebillid");
        Long interestBillId = interestBill.getLong("id");
        if (EmptyUtil.isNoEmpty((String)interestBill.getString("bizdealno"))) {
            this.genRelation("ifm_loanbill", loanBillId, "ifm_interestbill", interestBillId);
        } else {
            this.genRelation("cfm_loanbill", loanBillId, "cfm_interestbill", interestBillId);
        }
    }

    protected abstract void genRelation(String var1, Long var2, String var3, Long var4);
}

