/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.loancontract;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.loancontract.AbstractBotpService;

public class BotpRemoveService
extends AbstractBotpService {
    @Override
    protected void genRelation(String srcEntity, Long srcBillId, String destEntity, Long destBillId) {
        BotpRemoveService.deleteRation(destEntity, destBillId, srcEntity, srcBillId);
    }

    public static void deleteRation(String destEntityKey, Long FTBILLID, String srcEntityKey, Long FSBillId) {
        Long fTTableId = BotpRemoveService.getTableIdByEntityKey(destEntityKey);
        Long fSTableId = BotpRemoveService.getTableIdByEntityKey(srcEntityKey);
        try (TXHandle tx = TX.requiresNew();){
            BotpRemoveService.deleteLkRation(destEntityKey, fTTableId, FTBILLID, fSTableId, FSBillId);
        }
        tx = TX.requiresNew();
        var7_7 = null;
        try {
            String sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ? and FTTableId = ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])new Object[]{FSBillId, FTBILLID, fTTableId});
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static void deleteLkRation(String dEntityKey, Long FTTableId, Long FTBILLID, Long FSTableId, Long FSBillId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dEntityKey);
        DBRoute dbRoute = DBRouteConst.TMC;
        if (EmptyUtil.isNoEmpty((String)entityType.getDBRouteKey())) {
            dbRoute = new DBRoute(entityType.getDBRouteKey());
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)dEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items != null && items.size() > 0) {
            lk = ((LinkSetItemElement)items.get(0)).getTableName();
        }
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
        String sBuilder_tc = "delete from  " + tc + " where FSBillId= ? and FTId= ? and FTTableId =?";
        params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_tc.add(new SqlParameter(":FTId", -5, (Object)FTBILLID));
        params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_tc, (Object[])params_tc.toArray(new SqlParameter[params_tc.size()]));
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
        String sBuilder_lk = "delete from  " + lk + " where FSBillId= ? and FId= ? and FSTABLEID =?";
        params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_lk.add(new SqlParameter(":FId", -5, (Object)FTBILLID));
        params_lk.add(new SqlParameter(":FSTABLEID", -5, (Object)FSTableId));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_lk, (Object[])params_lk.toArray(new SqlParameter[params_lk.size()]));
    }

    private static Long getTableIdByEntityKey(final String entityName) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FEntityKey = ? ");
        parameters[0] = new SqlParameter(":FEntityKey", 12, (Object)entityName);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(entityName);
                    tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRouteConst.META, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getTableId();
    }
}

