/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.payacceptancebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;

public class AcceptancePushTransHelper {
    private static Log logger = LogFactory.getLog(AcceptancePushTransHelper.class);

    public static void autoTrans(DynamicObject[] infos, OperationResult opResult) throws KDException {
        DynamicObject[] transBills = null;
        try {
            String sourceEntity = infos[0].getDataEntityType().getName();
            Object[] pkIds = Arrays.stream(infos).map(o -> o.getPkValue()).toArray();
            transBills = TmcBotpHelper.batchPush((Object[])pkIds, (String)sourceEntity, (String)"ifm_transhandlebill");
        }
        catch (Exception exception) {
            AcceptancePushTransHelper.rollback(infos);
            logger.error((Throwable)exception);
            throw new KDBizException(String.valueOf(exception));
        }
        for (DynamicObject bill : transBills) {
            String transType = bill.getString("transtype");
            if (!TransTypeEnum.INNER_TRANSFER.getValue().equals(transType)) continue;
            bill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        OperationResult pushSaveResult = null;
        pushSaveResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"ifm_transhandlebill", (DynamicObject[])transBills, (OperateOption)OperateOption.create());
        List errorInfos = pushSaveResult.getAllErrorOrValidateInfo();
        if (errorInfos != null && errorInfos.size() > 0) {
            StringBuilder sBuilder = new StringBuilder();
            for (IOperateInfo errorInfo : errorInfos) {
                sBuilder.append(errorInfo.getMessage());
                sBuilder.append(';');
            }
            logger.error("\u751f\u6210\u5185\u90e8\u91d1\u878d\u4ea4\u6613\u5355\u4fdd\u5b58\u5931\u8d25", (Object)sBuilder.toString());
        }
        List successPkIds = new ArrayList(10);
        successPkIds = pushSaveResult.getSuccessPkIds();
        if (successPkIds == null || successPkIds.size() == 0) {
            AcceptancePushTransHelper.rollback(infos);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5185\u90e8\u91d1\u878d\u4ea4\u6613\u5355\u5931\u8d25", (String)"AcceptancePushTransHelper_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("id", "in", successPkIds);
        DynamicObject[] newTransBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id,transtype,sourcebillid", (QFilter[])qFilter.toArray());
        ArrayList<Long> innerTransferBillId = new ArrayList<Long>(10);
        ArrayList<Long> successPushIds = new ArrayList<Long>(10);
        for (DynamicObject bill : newTransBills) {
            Long sourceBillid = bill.getLong("sourcebillid");
            successPushIds.add(sourceBillid);
            String transType = bill.getString("transtype");
            if (!TransTypeEnum.INNER_TRANSFER.getValue().equals(transType)) continue;
            innerTransferBillId.add(bill.getLong("id"));
        }
        ArrayList<DynamicObject> failedPushed = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : infos) {
            Long billId = obj.getLong("id");
            if (successPushIds.contains(billId)) continue;
            failedPushed.add(obj);
        }
        if (failedPushed.size() > 0) {
            AcceptancePushTransHelper.rollback(failedPushed.toArray(new DynamicObject[0]));
            for (DynamicObject obj : failedPushed) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setPkValue(obj.getPkValue());
                String billno = obj.getString("billno");
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\u751f\u6210\u5185\u90e8\u91d1\u878d\u4ea4\u6613\u5355\u5931\u8d25", (String)"PayAcceptanceSubmitService_0", (String)"tmc-ifm-business", (Object[])new Object[0]), billno));
                opResult.addErrorInfo(operateErrorInfo);
            }
        }
        if (innerTransferBillId.size() == 0) {
            return;
        }
        OperationResult commitInnerTransResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"commitifm", (String)"ifm_transhandlebill", (Object[])innerTransferBillId.toArray(), (OperateOption)OperateOption.create());
        if (!commitInnerTransResult.isSuccess()) {
            List commitErrors = commitInnerTransResult.getAllErrorOrValidateInfo();
            StringBuilder errBuilder = new StringBuilder();
            for (IOperateInfo errorInfo : commitErrors) {
                errBuilder.append(errorInfo.getMessage());
                errBuilder.append(';');
            }
            logger.error("\u81ea\u52a8\u63d0\u4ea4\u5185\u90e8\u91d1\u878d\u6709\u5931\u8d25\u7684", (Object)errBuilder.toString());
        }
    }

    public static void pushToTrans(DynamicObject[] dynamicObjects) throws KDException {
        OperationResult opResult = null;
        try {
            opResult = TmcOperateServiceHelper.execOperate((String)"pushandsave", (String)"ifm_payacceptancebill", (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
        }
        catch (Exception exception) {
            AcceptancePushTransHelper.rollback(dynamicObjects);
            logger.error("\u751f\u6210\u91d1\u878d\u4ea4\u6613\u5355\u5931\u8d25", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5185\u90e8\u91d1\u878d\u4ea4\u6613\u5355\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"AcceptancePushTransHelper_1", (String)"tmc-ifm-business", (Object[])new Object[]{exception}));
        }
    }

    static void rollback(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> rollbackBillList = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("bizstatus", (Object)PayAcceptBizStatusEnum.ACCEPTING.getValue());
            dynamicObject.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            rollbackBillList.add(dynamicObject);
        }
        if (rollbackBillList.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])rollbackBillList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    handle.markRollback();
                    throw e;
                }
            }
        }
    }
}

