/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.preinterest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentPreIntBillRedWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("writeoffstatus");
        selector.add("writeoffamt");
        selector.add("nowriteoffamt");
        selector.add("modifier");
        selector.add("modifytime");
        selector.add("batchnoid");
        return selector;
    }

    public void process(DynamicObject[] preIntBills) throws KDException {
        preIntBills = this.loadComplexProp(preIntBills);
        ArrayList<DynamicObject> redWriteOffPreInt = new ArrayList<DynamicObject>(preIntBills.length);
        this.executeRedWriteOff(preIntBills, redWriteOffPreInt);
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("redwriteoffop", "redwriteoffop");
        OperationResult submitRes = TmcOperateServiceHelper.execOperate((String)"submit", (String)"ifm_currentintbill", (DynamicObject[])redWriteOffPreInt.toArray(new DynamicObject[0]), (OperateOption)opOption);
        List redWriteOffPreIntPkIds = submitRes.getSuccessPkIds();
        TmcOperateServiceHelper.execOperate((String)"audit", (String)"ifm_currentintbill", (Object[])redWriteOffPreIntPkIds.toArray(), (OperateOption)opOption);
        SaveServiceHelper.save((DynamicObject[])preIntBills);
    }

    private void executeRedWriteOff(DynamicObject[] preIntBills, List<DynamicObject> redWriteOffPreInt) {
        DynamicObject user = TmcDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        String batchNoParam = (String)this.getOperationVariable().get("redwriteoffbatch");
        Long batchNoId = EmptyUtil.isEmpty((String)batchNoParam) ? DB.genGlobalLongId() : Long.parseLong(batchNoParam);
        for (DynamicObject preIntBill : preIntBills) {
            this.cloneNewPreInt(preIntBill, user, redWriteOffPreInt, batchNoId);
            preIntBill.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            preIntBill.set("writeoffamt", preIntBill.get("actualinstamt"));
            preIntBill.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            preIntBill.set("modifier", (Object)user);
            preIntBill.set("modifytime", (Object)new Date());
            preIntBill.set("batchnoid", (Object)batchNoId);
            SettleIntWriteOffHelper.writeBackIntObjectPreIntDay((DynamicObject)preIntBill);
        }
    }

    private void cloneNewPreInt(DynamicObject preIntBill, DynamicObject user, List<DynamicObject> redWriteOffPreInt, Long batchNoId) {
        DynamicObject newPreInt = TmcDataServiceHelper.clone((DynamicObject)preIntBill);
        newPreInt.set("billhead_lk", null);
        newPreInt.set("billno", (Object)"");
        newPreInt.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        newPreInt.set("writeoffpreintbillid", preIntBill.getPkValue());
        newPreInt.set("biztype", (Object)"reversepreint");
        newPreInt.set("writeoffamt", preIntBill.get("actualinstamt"));
        newPreInt.set("nowriteoffamt", (Object)BigDecimal.ZERO);
        newPreInt.set("createtime", (Object)new Date());
        newPreInt.set("creator", (Object)user);
        newPreInt.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
        newPreInt.set("batchnoid", (Object)batchNoId);
        redWriteOffPreInt.add(newPreInt);
    }

    private DynamicObject[] loadComplexProp(DynamicObject[] preIntBills) {
        Object[] pks = Arrays.stream(preIntBills).filter(v -> CurrentBizTypeEnum.isPreInt((String)v.getString("biztype"))).map(DataEntityBase::getPkValue).toArray();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ifm_currentintbill");
        return TmcDataServiceHelper.load((Object[])pks, (DynamicObjectType)entityType);
    }
}

