/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.product;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.ServiceCategoryEnum;

public class LoanDepProductDisableService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("servicecategory");
        selector.add("credittype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            DynamicObject creditType = data.getDynamicObject("credittype");
            if (creditType == null) continue;
            CreditLimitServiceHelper.deleteCreditVariety((Long)creditType.getLong("id"), (Long)data.getLong("id"), (String)data.getDynamicObjectType().getName());
        }
        List numbers = Arrays.stream(dataEntities).filter(v -> !StringUtils.equals((CharSequence)ServiceCategoryEnum.LOAN.getValue(), (CharSequence)v.getString("servicecategory"))).map(v -> v.getString("number")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(numbers)) {
            return;
        }
        QFilter qfilter = new QFilter("number", "in", numbers).and(new QFilter("enable", "=", (Object)true));
        Object[] investVarieties = TmcDataServiceHelper.load((String)"cim_investvarieties", (String)"id,enable,status", (QFilter[])qfilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])investVarieties)) {
            TmcOperateServiceHelper.execOperate((String)"disable", (String)"cim_investvarieties", (DynamicObject[])investVarieties, (OperateOption)OperateOption.create());
        }
    }
}

