/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.product;

import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.ServiceCategoryEnum;

public class LoanDepProductSaveService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            String rateType = dataEntity.getString("ratetype");
            if (InterestTypeEnum.FIXED.getValue().equals(rateType) || InterestTypeEnum.AGREE.getValue().equals(rateType)) {
                dataEntity.set("referrate", null);
                dataEntity.set("ratesignbp", null);
                dataEntity.set("ratefloatpoints", null);
            } else if (InterestTypeEnum.FLOAT.getValue().equals(rateType)) {
                dataEntity.set("productprice", null);
            }
            String centerName = Optional.ofNullable(dataEntity.getDynamicObject("center")).map(r -> r.getString("name")).orElse("");
            dataEntity.set("describle", (Object)centerName);
            this.syncToInvest(dataEntity);
            this.updateCreditType(dataEntity);
        }
    }

    private void syncToInvest(DynamicObject product) {
        String category = product.getString("servicecategory");
        String rateType = product.getString("ratetype");
        if (!StringUtils.equals((CharSequence)category, (CharSequence)ServiceCategoryEnum.LOAN.getValue()) && (StringUtils.equals((CharSequence)"fixed", (CharSequence)rateType) || StringUtils.equals((CharSequence)"float", (CharSequence)rateType))) {
            DynamicObject investVarieties;
            String number = product.getString("number");
            DynamicObject investFormDB = TmcDataServiceHelper.loadSingle((String)"cim_investvarieties", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            if (EmptyUtil.isNoEmpty((DynamicObject)investFormDB)) {
                investVarieties = TmcDataServiceHelper.loadSingle((Object)investFormDB.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_investvarieties"));
                investVarieties.set("modifytime", (Object)DateUtils.getCurrentTime());
                investVarieties.set("modifier", (Object)RequestContext.get().getCurrUserId());
            } else {
                investVarieties = TmcDataServiceHelper.newDynamicObject((String)"cim_investvarieties");
                investVarieties.set("creator", (Object)RequestContext.get().getCurrUserId());
                investVarieties.set("createtime", (Object)DateUtils.getCurrentTime());
            }
            this.copyProperties(product, investVarieties);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_investvarieties", (DynamicObject[])new DynamicObject[]{investVarieties}, (OperateOption)OperateOption.create());
        } else {
            this.deleteInvest(product.getString("number"));
        }
    }

    private void copyProperties(DynamicObject product, DynamicObject investVarieties) {
        investVarieties.set("number", (Object)product.getString("number"));
        investVarieties.set("name", product.get("name"));
        investVarieties.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        investVarieties.set("enable", product.get("enable"));
        investVarieties.set("longnumber", (Object)product.getString("number"));
        investVarieties.set("level", (Object)1);
        investVarieties.set("fullname", product.get("name"));
        investVarieties.set("isleaf", (Object)true);
        investVarieties.set("investsource", (Object)"settlecenter");
        investVarieties.set("ispreset", (Object)false);
        String cateGory = product.getString("servicecategory");
        String investType = StringUtils.equals((CharSequence)cateGory, (CharSequence)ServiceCategoryEnum.DEPOSIT.getValue()) ? "fixed" : "notice";
        investVarieties.set("investtype", (Object)investType);
        investVarieties.set("isproduct", (Object)"1");
        String centerName = Optional.ofNullable(product.getDynamicObject("center")).map(r -> r.getString("name")).orElse("");
        investVarieties.set("describle", (Object)centerName);
    }

    private void deleteInvest(String number) {
        DynamicObject investFormDB = TmcDataServiceHelper.loadSingle((String)"cim_investvarieties", (String)"isleaf,id,enable,parent,isproduct", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (EmptyUtil.isNoEmpty((DynamicObject)investFormDB)) {
            investFormDB.set("enable", (Object)"1");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("deletefromproduct", "true");
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_investvarieties", (DynamicObject[])new DynamicObject[]{investFormDB}, (OperateOption)operateOption);
        }
    }

    private void updateCreditType(DynamicObject data) {
        boolean isCreditTypeChanged;
        String status = data.getString("enable");
        if (BaseEnableEnum.DISABLE.getValue().equals(status)) {
            return;
        }
        DynamicObject creditTypeFromDb = null;
        if (TmcDataServiceHelper.isFromDatabase((DynamicObject)data)) {
            DynamicObject dataFromDb = TmcDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)data.getDataEntityType().getName(), (String)"credittype");
            creditTypeFromDb = dataFromDb.getDynamicObject("credittype");
        }
        DynamicObject creditTypeNew = data.getDynamicObject("credittype");
        boolean bl = isCreditTypeChanged = creditTypeFromDb != null && creditTypeNew != null && !creditTypeFromDb.getPkValue().equals(creditTypeNew.getPkValue()) || creditTypeFromDb == null && creditTypeNew != null || creditTypeFromDb != null && creditTypeNew == null;
        if (isCreditTypeChanged) {
            if (creditTypeFromDb != null) {
                CreditLimitServiceHelper.deleteCreditVariety((Long)creditTypeFromDb.getLong("id"), (Long)data.getLong("id"), (String)data.getDynamicObjectType().getName());
            }
            if (creditTypeNew != null) {
                CreditLimitServiceHelper.addCreditVariety((Long)creditTypeNew.getLong("id"), (Long)data.getLong("id"), (String)data.getDynamicObjectType().getName());
            }
        }
    }
}

