/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.rectransbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;

public class RecTransRevokeService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject transBill : dataEntities) {
            ArrayList<Long> ids = new ArrayList<Long>(4);
            ids.add(transBill.getLong("id"));
            TransDetailService.revertTransDetail((DynamicObject)transBill);
            this.cancelJournal(transBill);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_rectransbill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private void cancelJournal(DynamicObject transBill) {
        String transType = transBill.getString("transtype");
        if (!transType.equals(TransTypeEnum.INNER_FUND_COLLECTION.getValue())) {
            return;
        }
        Long transId = transBill.getLong("id");
        Map failedMap = JournalBookHelper.cancelJournal((String)transBill.getDataEntityType().getName(), Collections.singletonList(transId));
        if (failedMap != null && EmptyUtil.isNoEmpty((String)((String)failedMap.get(transId)))) {
            throw new KDBizException((String)failedMap.get(transId));
        }
    }
}

