/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.repaymentbill;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.BizDealHelper;
import kd.tmc.ifm.helper.IfmLoanWriteBackHelper;
import kd.tmc.ifm.mservice.consistency.helper.IfmConsistencyServiceHelper;

public class IfmRepaymentAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loans");
        selector.add("e_ispayinst");
        selector.add("e_loanbill");
        selector.add("datasource");
        selector.add("bankcheckflag");
        selector.add("isrelcash");
        selector.add("eassrcid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject repay : dataEntities) {
            for (DynamicObject entry : repay.getDynamicObjectCollection("loans")) {
                QFilter instFilter;
                List rateIdList;
                boolean isPayInst = entry.getBoolean("e_ispayinst");
                if (!isPayInst || EmptyUtil.isEmpty((Collection)(rateIdList = QueryServiceHelper.queryPrimaryKeys((String)"ifm_interestbill", (QFilter[])(instFilter = new QFilter("sourcebillid", "=", entry.getDynamicObject("e_loanbill").getPkValue()).and(new QFilter("repaymentid", "=", repay.getPkValue()))).toArray(), null, (int)-1)))) continue;
                DynamicObject rateBill = BusinessDataServiceHelper.loadSingle(rateIdList.get(0), (String)"ifm_interestbill");
                BizDealHelper.genBatchIntBill((Long)rateBill.getLong("id"), (String)"1", (String)repay.getString("datasource"));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject repayBill : dataEntities) {
            TmcOperateServiceHelper.execOperate((String)"businessconfirm", (String)"ifm_repaymentbill", (Object[])new Object[]{repayBill.getLong("id")}, (OperateOption)OperateOption.create());
            IfmLoanWriteBackHelper.writeBack((DynamicObject)repayBill);
        }
        this.pushPayInfo(dataEntities);
    }

    private void pushPayInfo(DynamicObject[] dataEntities) {
        List autoPushBillIds = Arrays.stream(dataEntities).filter(BizDealHelper::isCanPush2IfmBill).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(autoPushBillIds)) {
            TmcOperateServiceHelper.execOperate((String)"push2transhandle", (String)"ifm_repaymentbill", (Object[])autoPushBillIds.toArray(), (OperateOption)OperateOption.create());
            IfmConsistencyServiceHelper.asyncPush((String)"repayment_autoPushPay", (String)"rePaymenBillPushPayService", autoPushBillIds);
        }
    }
}

