/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.settcentersetting;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InnerAccountInitBackService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InnerAccountInitBackService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("inneraccount");
        selector.add("amountdate");
        selector.add("amount");
        selector.add("currency");
        selector.add("isinit");
        return selector;
    }

    public void process(DynamicObject[] dts) throws KDException {
        List innerAccountIdList = Stream.of(dts).map(v -> v.get("inneraccount.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("inneracct.id", "in", innerAccountIdList);
        DynamicObjectCollection accountIdInfo = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,inneracct.id,company,openorg,bank", (QFilter[])new QFilter[]{qFilter});
        Map innerAccountIdAndAccountMap = accountIdInfo.stream().collect(Collectors.toMap(e -> e.getLong("inneracct.id"), Function.identity()));
        ArrayList<DynamicObject> initSet = new ArrayList<DynamicObject>(dts.length);
        for (DynamicObject initDO : dts) {
            boolean isInit = initDO.getBoolean("isinit");
            if (!isInit) continue;
            long innerAccountPkId = initDO.getLong("inneraccount.id");
            DynamicObject accountObj = (DynamicObject)innerAccountIdAndAccountMap.get(innerAccountPkId);
            Long accountPkId = accountObj.getLong("id");
            DynamicObject currency = initDO.getDynamicObject("currency");
            QFilter inittransQF = new QFilter("sourcebillid", "=", (Object)accountPkId);
            inittransQF.and("sourcebilltype", "=", (Object)"bd_accountbanks");
            inittransQF.and("currency.id", "=", currency.getPkValue());
            DynamicObjectCollection inittransIds = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id", (QFilter[])inittransQF.toArray());
            List transIds = inittransIds.stream().map(o -> o.get("id")).collect(Collectors.toList());
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transdetail", (Object[])transIds.toArray(), (OperateOption)OperateOption.create());
            initDO.set("isinit", (Object)0);
            initSet.add(initDO);
        }
        SaveServiceHelper.save((DynamicObject[])initSet.toArray(new DynamicObject[0]));
        this.updateSettleCenterSetting(initSet);
    }

    private void updateSettleCenterSetting(List<DynamicObject> initSet) {
        List pkList = initSet.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject innerAccount = (DynamicObject)initSet.get(0).get("inneraccount");
        DynamicObject finOrg = (DynamicObject)innerAccount.get("finorg");
        QFilter initFilter = new QFilter("isinit", "=", (Object)"1");
        QFilter currIdFilter = new QFilter("id", "not in", pkList);
        Object[] scDbObjs = BusinessDataServiceHelper.load((String)"ifm_settcentersetting", (String)"id,inneraccinit,modifier,modifytime,settlecenter", (QFilter[])new QFilter[]{new QFilter("settlecenter.id", "=", finOrg.getPkValue())});
        if (EmptyUtil.isEmpty((Object[])scDbObjs)) {
            return;
        }
        Object scObj = scDbObjs[0];
        QFilter scIdFilter = new QFilter("inneraccount.finorg.id", "=", (Object)scObj.getLong("settlecenter.id"));
        boolean exists = QueryServiceHelper.exists((String)"ifm_inneraccountinit", (QFilter[])new QFilter[]{initFilter.and(currIdFilter).and(scIdFilter)});
        if (!exists) {
            scObj.set("inneraccinit", (Object)0);
            scObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            scObj.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scObj});
        }
    }
}

