/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.settcentersetting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InitInnerAcctBalanceHelper;

public class InnerAccountInitService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(InnerAccountInitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("inneraccount");
        selector.add("amountdate");
        selector.add("amount");
        selector.add("currency");
        selector.add("isinit");
        return selector;
    }

    public void process(DynamicObject[] dts) throws KDException {
        List innerAcctIdList = Stream.of(dts).map(v -> v.get("inneraccount.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("inneracct.id", "in", innerAcctIdList);
        DynamicObject[] acctBanks = TmcDataServiceHelper.load((String)"bd_accountbanks", (String)"id,inneracct.id,company,openorg,bank, scorg", (QFilter[])new QFilter[]{qFilter});
        if (acctBanks == null || acctBanks.length == 0) {
            logger.error("\u5185\u90e8\u8d26\u6237\u521d\u59cb\u5316\u5f02\u5e38\u5728\u94f6\u884c\u8d26\u6237\u8868\u6570\u636e\u5339\u914d\u4e0d\u5230\u94f6\u884c\u8d26\u6237");
            throw new KDBizException(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"InnerAccountInitService_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        Map inneracct2AcctbankMap = Arrays.asList(acctBanks).stream().collect(Collectors.toMap(e -> e.getLong("inneracct.id"), Function.identity(), (v1, v2) -> v2));
        ArrayList<DynamicObject> initSet = new ArrayList<DynamicObject>(dts.length);
        for (DynamicObject initDO : dts) {
            boolean isInit = initDO.getBoolean("isinit");
            if (isInit) continue;
            long innerAcctId = initDO.getLong("inneraccount.id");
            DynamicObject acctBank = (DynamicObject)inneracct2AcctbankMap.get(innerAcctId);
            BigDecimal amount = initDO.getBigDecimal("amount");
            Date amountDate = (Date)initDO.get("amountdate");
            DynamicObject currency = (DynamicObject)initDO.get("currency");
            initDO.set("isinit", (Object)"1");
            initSet.add(initDO);
            InitInnerAcctBalanceHelper.createInitTransDetail((DynamicObject)acctBank, (DynamicObject)currency, (BigDecimal)amount, (Date)amountDate);
        }
        SaveServiceHelper.save((DynamicObject[])initSet.toArray(new DynamicObject[0]));
        this.updateSettleCenterSetting(initSet);
    }

    private void updateSettleCenterSetting(List<DynamicObject> initSet) {
        DynamicObject innerAcct = (DynamicObject)initSet.get(0).get("inneraccount");
        DynamicObject finOrg = (DynamicObject)innerAcct.get("finorg");
        Object[] scDbObjs = BusinessDataServiceHelper.load((String)"ifm_settcentersetting", (String)"id,inneraccinit,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("settlecenter.id", "=", finOrg.getPkValue())});
        if (EmptyUtil.isEmpty((Object[])scDbObjs)) {
            return;
        }
        Object scDbObj = scDbObjs[0];
        scDbObj.set("inneraccinit", (Object)"1");
        scDbObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        scDbObj.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scDbObj});
    }
}

