/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.ebservice.sync.TransBillSyncStatusService;

public class TransHandelSynStatusService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TransHandelSynStatusService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject transBill : dataEntities) {
            boolean isCommitbe = transBill.getBoolean("iscommitbe");
            String paidStatus = transBill.getString("paidstatus");
            boolean isPay = TransBillPaidStatusEnum.PAID.getValue().equals(paidStatus);
            if (!isPay && isCommitbe && TransBillPaidStatusEnum.PAYING.getValue().equals(paidStatus)) {
                DynamicObject bankpayBill = QueryServiceHelper.queryOne((String)"bei_bankpaybill", (String)"id,bankpaystate,sourcebillid,statementrefno,bankreturnmsg", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", transBill.getPkValue())});
                logger.info("cas update");
                this.synTransBillStatus(bankpayBill, transBill.getDate("commitbetime"));
            }
            if (!isPay || !"ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) continue;
            TransBillHelper.writePayAccStatus((DynamicObject)transBill);
            long casPayBillId = BankBillSyncStatusHelper.getCasPayBillId((DynamicObject)transBill);
            DynamicObject casPayBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)casPayBillId)});
            if (EmptyUtil.isEmpty((DynamicObject)casPayBill)) {
                logger.info("casPayBill is empty, casPayBillId:{}", (Object)casPayBillId);
                return;
            }
            if (BillStatusEnum.BEING.getValue().equals(casPayBill.getString("billstatus"))) {
                String bankCheckBei = TransBillHelper.getBankCheckFlag((String)transBill.getString("transtype"), (String)transBill.getString("beibankcheckflag"), (boolean)false);
                String bankCheckFlagToCas = TransBillHelper.getBankCheckFlagToCas((DynamicObject)transBill, (String)transBill.getString("bankcheckflag"), (String)bankCheckBei);
                logger.info("cas update being");
                SyncStatusInfo info = BankBillSyncStatusHelper.getSyncStatusInfo((Long)transBill.getLong("id"), (Long)casPayBill.getLong("id"), (String)bankCheckFlagToCas);
                info.setCommitBe(true);
                info.setCommitBeTime(transBill.getDate("commitbetime"));
                BankBillSyncStatusHelper.syncBankBill((SyncStatusInfo)info);
                this.detailMatch(transBill.getLong("id"));
                continue;
            }
            if (!BillStatusEnum.PAYED.getValue().equals(casPayBill.getString("billstatus"))) continue;
            logger.info("match details");
            this.detailMatch(transBill.getLong("id"));
        }
    }

    private void detailMatch(Long tranBillId) {
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)tranBillId), new QFilter("receredtype", "=", (Object)ReceredtypeEnum.Pending.getValue())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)details)) {
            TransDetailHelper.matchBillByBankCheckFlag(details.stream().map(o -> o.getLong("id")).collect(Collectors.toList()), (boolean)true);
        }
    }

    private void synTransBillStatus(DynamicObject bankpayBill, Date commitbeTime) {
        SyncStatusInfo info = this.getSyncStatusInfo(bankpayBill);
        info.setCommitBeTime(commitbeTime);
        new TransBillSyncStatusService().syncStatus(info);
    }

    private SyncStatusInfo getSyncStatusInfo(DynamicObject bankpayBill) {
        SyncStatusInfo info = new SyncStatusInfo();
        info.setCommitBe(true);
        info.setBankBillId(Long.valueOf(bankpayBill.getLong("id")));
        info.setBankPayStatus(bankpayBill.getString("bankpaystate"));
        info.setPayBillId(Long.valueOf(bankpayBill.getLong("sourcebillid")));
        info.setStatusCode(EBResultStatusCode.SUCCESS);
        info.setEntityType("ifm_transhandlebill");
        SyncStatusDetail detail = new SyncStatusDetail();
        detail.setBankDetailSeqId(bankpayBill.getString("statementrefno"));
        detail.setEbStatusMsg(bankpayBill.getString("bankreturnmsg"));
        info.setDetailList(Collections.singletonList(detail));
        return info;
    }
}

